/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.validate.Violation;
import java.util.Collections;
import java.util.List;

public class ValidationResult {
    private final List<Violation> violations;
    public static final ValidationResult EMPTY = new ValidationResult(Collections.emptyList());

    public ValidationResult(List<Violation> violations) {
        this.violations = violations;
    }

    public boolean isSuccess() {
        return this.violations.isEmpty();
    }

    public List<Violation> getViolations() {
        return this.violations;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Validation error:");
        for (Violation violation : this.violations) {
            builder.append("\n - ");
            if (!violation.getFieldPath().isEmpty()) {
                builder.append(violation.getFieldPath());
                builder.append(": ");
            }
            builder.append(String.format("%s [%s]", violation.getMessage(), violation.getConstraintId()));
        }
        return builder.toString();
    }
}

