/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.ValidationResult;
import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.validate.Violation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

class ValueEvaluator
implements Evaluator {
    @Nullable
    private Object zero;
    private final List<Evaluator> evaluators = new ArrayList<Evaluator>();
    private boolean ignoreEmpty;

    ValueEvaluator() {
    }

    @Override
    public boolean tautology() {
        return this.evaluators.isEmpty();
    }

    @Override
    public ValidationResult evaluate(Value val, boolean failFast) throws ExecutionException {
        if (this.shouldIgnore(val.value(Object.class))) {
            return ValidationResult.EMPTY;
        }
        ArrayList<Violation> violations = new ArrayList<Violation>();
        for (Evaluator evaluator : this.evaluators) {
            ValidationResult evalResult = evaluator.evaluate(val, failFast);
            if (failFast && !evalResult.getViolations().isEmpty()) {
                return evalResult;
            }
            violations.addAll(evalResult.getViolations());
        }
        if (violations.isEmpty()) {
            return ValidationResult.EMPTY;
        }
        return new ValidationResult(violations);
    }

    public void append(Evaluator eval) {
        if (!eval.tautology()) {
            this.evaluators.add(eval);
        }
    }

    public void setIgnoreEmpty(Object zero) {
        this.ignoreEmpty = true;
        this.zero = zero;
    }

    private boolean shouldIgnore(Object value) {
        return this.ignoreEmpty && Objects.equals(value, this.zero);
    }
}

