/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.expression;

import build.buf.protovalidate.exceptions.CompilationException;
import build.buf.protovalidate.internal.expression.Expression;
import com.google.api.expr.v1alpha1.Type;
import org.projectnessie.cel.Ast;
import org.projectnessie.cel.Env;

public class AstExpression {
    public final Ast ast;
    public final Expression source;

    private AstExpression(Ast ast, Expression source) {
        this.ast = ast;
        this.source = source;
    }

    public static AstExpression newAstExpression(Env env, Expression expr) throws CompilationException {
        Env.AstIssuesTuple astIssuesTuple = env.compile(expr.expression);
        if (astIssuesTuple.hasIssues()) {
            throw new CompilationException("Failed to compile expression " + expr.id + ":\n" + astIssuesTuple.getIssues());
        }
        Ast ast = astIssuesTuple.getAst();
        Type outType = ast.getResultType();
        if (outType.getPrimitive() != Type.PrimitiveType.BOOL && outType.getPrimitive() != Type.PrimitiveType.STRING) {
            throw new CompilationException(String.format("Expression outputs, wanted either bool or string: %s %s", expr.id, outType));
        }
        return new AstExpression(ast, expr);
    }
}

