/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.ValidationResult;
import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.evaluator.ErrorPathUtils;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.protovalidate.internal.evaluator.ValueEvaluator;
import build.buf.validate.Violation;
import java.util.ArrayList;
import java.util.List;

class ListEvaluator
implements Evaluator {
    final ValueEvaluator itemConstraints = new ValueEvaluator();

    ListEvaluator() {
    }

    @Override
    public boolean tautology() {
        return this.itemConstraints.tautology();
    }

    @Override
    public ValidationResult evaluate(Value val, boolean failFast) throws ExecutionException {
        ArrayList<Violation> allViolations = new ArrayList<Violation>();
        List<Value> repeatedValues = val.repeatedValue();
        for (int i = 0; i < repeatedValues.size(); ++i) {
            ValidationResult evalResult = this.itemConstraints.evaluate(repeatedValues.get(i), failFast);
            if (evalResult.getViolations().isEmpty()) continue;
            List<Violation> violations = ErrorPathUtils.prefixErrorPaths(evalResult.getViolations(), "[%d]", i);
            if (failFast && !violations.isEmpty()) {
                return evalResult;
            }
            allViolations.addAll(violations);
        }
        return new ValidationResult(allViolations);
    }
}

