/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.validate.Violation;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import java.util.List;
import java.util.stream.Collectors;

final class ErrorPathUtils {
    private ErrorPathUtils() {
    }

    @FormatMethod
    static List<Violation> prefixErrorPaths(List<Violation> violations, @FormatString String format, Object ... args) {
        String prefix = String.format(format, args);
        return violations.stream().map(violation -> {
            String fieldPath = violation.getFieldPath();
            String prefixedFieldPath = fieldPath.isEmpty() ? prefix : (fieldPath.charAt(0) == '[' ? prefix + fieldPath : Strings.lenientFormat((String)"%s.%s", (Object[])new Object[]{prefix, fieldPath}));
            return violation.toBuilder().setFieldPath(prefixedFieldPath).build();
        }).collect(Collectors.toList());
    }
}

