/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.ValidationResult;
import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.validate.Violation;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class AnyEvaluator
implements Evaluator {
    private final Descriptors.FieldDescriptor typeURLDescriptor;
    private final Set<String> in;
    private final Set<String> notIn;

    AnyEvaluator(Descriptors.FieldDescriptor typeURLDescriptor, List<String> in, List<String> notIn) {
        this.typeURLDescriptor = typeURLDescriptor;
        this.in = AnyEvaluator.stringsToSet(in);
        this.notIn = AnyEvaluator.stringsToSet(notIn);
    }

    @Override
    public ValidationResult evaluate(Value val, boolean failFast) throws ExecutionException {
        Violation violation;
        Message anyValue = val.messageValue();
        if (anyValue == null) {
            return ValidationResult.EMPTY;
        }
        ArrayList<Violation> violationList = new ArrayList<Violation>();
        String typeURL = (String)anyValue.getField(this.typeURLDescriptor);
        if (!this.in.isEmpty() && !this.in.contains(typeURL)) {
            violation = Violation.newBuilder().setConstraintId("any.in").setMessage("type URL must be in the allow list").build();
            violationList.add(violation);
            if (failFast) {
                return new ValidationResult(violationList);
            }
        }
        if (!this.notIn.isEmpty() && this.notIn.contains(typeURL)) {
            violation = Violation.newBuilder().setConstraintId("any.not_in").setMessage("type URL must not be in the block list").build();
            violationList.add(violation);
        }
        return new ValidationResult(violationList);
    }

    @Override
    public boolean tautology() {
        return this.in.isEmpty() && this.notIn.isEmpty();
    }

    private static Set<String> stringsToSet(List<String> strings) {
        if (strings.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(strings);
    }
}

