/*
 * Decompiled with CFR 0.152.
 */
package build.buf.connect.protocols;

import build.buf.connect.Code;
import build.buf.connect.ConnectError;
import build.buf.connect.ConnectErrorDetail;
import build.buf.connect.ErrorDetailParser;
import build.buf.connect.Interceptor;
import build.buf.connect.ProtocolClientConfig;
import build.buf.connect.SerializationStrategy;
import build.buf.connect.StreamFunction;
import build.buf.connect.StreamResult;
import build.buf.connect.UnaryFunction;
import build.buf.connect.compression.CompressionPool;
import build.buf.connect.compression.RequestCompression;
import build.buf.connect.http.HTTPRequest;
import build.buf.connect.http.HTTPResponse;
import build.buf.connect.http.TracingInfo;
import build.buf.connect.protocols.Envelope;
import build.buf.connect.protocols.GRPCCompletion;
import build.buf.connect.protocols.GRPCCompletionParser;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J8\u0010\u000f\u001a\u0018\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00120\u0010j\u0002`\u0013*\u0018\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00120\u0010j\u0002`\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lbuild/buf/connect/protocols/GRPCInterceptor;", "Lbuild/buf/connect/Interceptor;", "clientConfig", "Lbuild/buf/connect/ProtocolClientConfig;", "(Lbuild/buf/connect/ProtocolClientConfig;)V", "completionParser", "Lbuild/buf/connect/protocols/GRPCCompletionParser;", "responseCompressionPool", "Lbuild/buf/connect/compression/CompressionPool;", "serializationStrategy", "Lbuild/buf/connect/SerializationStrategy;", "streamFunction", "Lbuild/buf/connect/StreamFunction;", "unaryFunction", "Lbuild/buf/connect/UnaryFunction;", "withGRPCRequestHeaders", "", "", "", "Lbuild/buf/connect/Headers;", "library"})
public final class GRPCInterceptor
implements Interceptor {
    @NotNull
    private final ProtocolClientConfig clientConfig;
    @NotNull
    private final SerializationStrategy serializationStrategy;
    @NotNull
    private final GRPCCompletionParser completionParser;
    @Nullable
    private CompressionPool responseCompressionPool;

    public GRPCInterceptor(@NotNull ProtocolClientConfig clientConfig) {
        Intrinsics.checkNotNullParameter(clientConfig, "clientConfig");
        this.clientConfig = clientConfig;
        this.serializationStrategy = this.clientConfig.getSerializationStrategy();
        this.completionParser = new GRPCCompletionParser(this.serializationStrategy.errorDetailParser());
    }

    @Override
    @NotNull
    public UnaryFunction unaryFunction() {
        return new UnaryFunction((Function1<? super HTTPRequest, HTTPRequest>)new Function1<HTTPRequest, HTTPRequest>(this){
            final /* synthetic */ GRPCInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final HTTPRequest invoke(@NotNull HTTPRequest request) {
                RequestCompression requestCompression;
                Buffer buffer;
                Throwable $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(request, "request");
                Map requestHeaders = new LinkedHashMap<K, V>();
                requestHeaders.putAll(request.getHeaders());
                if (!((Collection)GRPCInterceptor.access$getClientConfig$p(this.this$0).compressionPools()).isEmpty()) {
                    Collection<String> collection;
                    void $this$map$iv;
                    Iterable iterable = GRPCInterceptor.access$getClientConfig$p(this.this$0).compressionPools();
                    String string = "grpc-accept-encoding";
                    Map map2 = requestHeaders;
                    boolean $i$f$map = false;
                    void var5_8 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        void compressionPool;
                        T item$iv$iv = iterator2.next();
                        CompressionPool compressionPool2 = (CompressionPool)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(compressionPool.name());
                    }
                    collection = (List)destination$iv$iv;
                    map2.put(string, collection);
                }
                Closeable $i$f$map = new Buffer();
                $this$mapTo$iv$iv = null;
                try {
                    Buffer buffer2 = (Buffer)$i$f$map;
                    boolean bl = false;
                    if (request.getMessage() != null) {
                        buffer2.write(request.getMessage());
                    }
                    buffer = buffer2;
                }
                catch (Throwable throwable) {
                    $this$mapTo$iv$iv = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally($i$f$map, $this$mapTo$iv$iv);
                }
                Buffer requestMessage = buffer;
                RequestCompression requestCompression2 = requestCompression = GRPCInterceptor.access$getClientConfig$p(this.this$0).getRequestCompression();
                RequestCompression requestCompression3 = requestCompression;
                Buffer envelopedMessage = Envelope.Companion.pack(requestMessage, (CompressionPool)(requestCompression2 == null ? null : requestCompression2.getCompressionPool()), requestCompression3 == null ? null : Integer.valueOf(requestCompression3.getMinBytes()));
                return new HTTPRequest(request.getUrl(), Intrinsics.stringPlus("application/grpc+", GRPCInterceptor.access$getSerializationStrategy$p(this.this$0).serializationName()), GRPCInterceptor.access$withGRPCRequestHeaders(this.this$0, requestHeaders), envelopedMessage.readByteArray());
            }
        }, (Function1<? super HTTPResponse, HTTPResponse>)new Function1<HTTPResponse, HTTPResponse>(this){
            final /* synthetic */ GRPCInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final HTTPResponse invoke(@NotNull HTTPResponse response) {
                HTTPResponse hTTPResponse;
                GRPCCompletion completion;
                Intrinsics.checkNotNullParameter(response, "response");
                if (response.getCode() != Code.OK) {
                    return response;
                }
                Map<String, List<String>> trailers = response.getTrailers();
                GRPCCompletion gRPCCompletion = completion = GRPCInterceptor.access$getCompletionParser$p(this.this$0).parse$library(trailers);
                Code code = gRPCCompletion == null ? null : gRPCCompletion.getCode();
                if (code == null) {
                    code = Code.UNKNOWN;
                }
                Code code2 = code;
                Map<String, List<String>> responseHeaders = MapsKt.toMutableMap(response.getHeaders());
                List<String> list = responseHeaders.get("grpc-encoding");
                CompressionPool compressionPool = GRPCInterceptor.access$getClientConfig$p(this.this$0).compressionPool(list == null ? null : CollectionsKt.first(list));
                if (code2 == Code.OK) {
                    Buffer message = Envelope.Companion.unpackWithHeaderByte(response.getMessage().getBuffer(), compressionPool).component2();
                    ConnectError connectError = response.getError();
                    TracingInfo tracingInfo = response.getTracingInfo();
                    hTTPResponse = new HTTPResponse(code2, responseHeaders, message, trailers, tracingInfo, connectError);
                } else {
                    String string;
                    Buffer result2 = new Buffer();
                    if (completion != null) {
                        ByteString errorMessage2 = completion.getMessage();
                        result2.write(errorMessage2);
                    }
                    ErrorDetailParser errorDetailParser = GRPCInterceptor.access$getSerializationStrategy$p(this.this$0).errorDetailParser();
                    GRPCCompletion gRPCCompletion2 = completion;
                    if (gRPCCompletion2 == null) {
                        string = null;
                    } else {
                        ByteString byteString = gRPCCompletion2.getMessage();
                        string = byteString == null ? null : byteString.utf8();
                    }
                    GRPCCompletion gRPCCompletion3 = completion;
                    List<ConnectErrorDetail> list2 = gRPCCompletion3 == null ? null : gRPCCompletion3.getErrorDetails();
                    if (list2 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    ConnectError connectError = new ConnectError(code2, errorDetailParser, string, null, list2, null, 40, null);
                    TracingInfo tracingInfo = response.getTracingInfo();
                    hTTPResponse = new HTTPResponse(code2, responseHeaders, result2, trailers, tracingInfo, connectError);
                }
                return hTTPResponse;
            }
        });
    }

    @Override
    @NotNull
    public StreamFunction streamFunction() {
        return new StreamFunction((Function1<? super HTTPRequest, HTTPRequest>)new Function1<HTTPRequest, HTTPRequest>(this){
            final /* synthetic */ GRPCInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final HTTPRequest invoke(@NotNull HTTPRequest request) {
                Intrinsics.checkNotNullParameter(request, "request");
                return new HTTPRequest(request.getUrl(), Intrinsics.stringPlus("application/grpc+", GRPCInterceptor.access$getSerializationStrategy$p(this.this$0).serializationName()), GRPCInterceptor.access$withGRPCRequestHeaders(this.this$0, request.getHeaders()), request.getMessage());
            }
        }, (Function1<? super Buffer, Buffer>)new Function1<Buffer, Buffer>(this){
            final /* synthetic */ GRPCInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Buffer invoke(@NotNull Buffer buffer) {
                RequestCompression requestCompression;
                Intrinsics.checkNotNullParameter(buffer, "buffer");
                RequestCompression requestCompression2 = requestCompression = GRPCInterceptor.access$getClientConfig$p(this.this$0).getRequestCompression();
                RequestCompression requestCompression3 = requestCompression;
                return Envelope.Companion.pack(buffer, (CompressionPool)(requestCompression2 == null ? null : requestCompression2.getCompressionPool()), requestCompression3 == null ? null : Integer.valueOf(requestCompression3.getMinBytes()));
            }
        }, (Function1<? super StreamResult<Buffer>, ? extends StreamResult<Buffer>>)new Function1<StreamResult<Buffer>, StreamResult<Buffer>>(this){
            final /* synthetic */ GRPCInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final StreamResult<Buffer> invoke(@NotNull StreamResult<Buffer> res) {
                Intrinsics.checkNotNullParameter(res, "res");
                StreamResult streamResult2 = (StreamResult)res.fold((Function1)new Function1<StreamResult.Headers<Buffer>, StreamResult<Buffer>>(this.this$0){
                    final /* synthetic */ GRPCInterceptor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final StreamResult<Buffer> invoke(@NotNull StreamResult.Headers<Buffer> result2) {
                        void $this$filterTo$iv$iv;
                        Intrinsics.checkNotNullParameter(result2, "result");
                        Map<String, List<String>> $this$filter$iv = result2.getHeaders();
                        boolean $i$f$filter = false;
                        Map<String, List<String>> map2 = $this$filter$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>();
                        boolean $i$f$filterTo = false;
                        Iterator<Map.Entry<K, V>> iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry<K, V> element$iv$iv;
                            Map.Entry<K, V> entry = element$iv$iv = iterator2.next();
                            boolean bl = false;
                            if (!(!StringsKt.startsWith$default((String)entry.getKey(), "trailer", false, 2, null))) continue;
                            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                        }
                        Map<K, V> responseHeaders = MapsKt.toMutableMap(destination$iv$iv);
                        List list = (List)responseHeaders.get("grpc-encoding");
                        GRPCInterceptor.access$setResponseCompressionPool$p(this.this$0, GRPCInterceptor.access$getClientConfig$p(this.this$0).compressionPool(list == null ? null : (String)CollectionsKt.first(list)));
                        return new StreamResult.Headers<Output>(responseHeaders);
                    }
                }, (Function1)new Function1<StreamResult.Message<Buffer>, StreamResult<Buffer>>(this.this$0){
                    final /* synthetic */ GRPCInterceptor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final StreamResult<Buffer> invoke(@NotNull StreamResult.Message<Buffer> result2) {
                        Intrinsics.checkNotNullParameter(result2, "result");
                        Buffer unpackedMessage = Envelope.Companion.unpackWithHeaderByte(result2.getMessage(), GRPCInterceptor.access$getResponseCompressionPool$p(this.this$0)).component2();
                        return new StreamResult.Message<Buffer>(unpackedMessage);
                    }
                }, (Function1)new Function1<StreamResult.Complete<Buffer>, StreamResult<Buffer>>(this.this$0){
                    final /* synthetic */ GRPCInterceptor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final StreamResult<Buffer> invoke(@NotNull StreamResult.Complete<Buffer> result2) {
                        ConnectError connectError;
                        ConnectError connectError2;
                        List<ConnectErrorDetail> details;
                        GRPCCompletion completion;
                        Intrinsics.checkNotNullParameter(result2, "result");
                        Map<String, List<String>> streamTrailers = result2.getTrailers();
                        GRPCCompletion gRPCCompletion = completion = GRPCInterceptor.access$getCompletionParser$p(this.this$0).parse$library(streamTrailers);
                        Code code = gRPCCompletion == null ? null : gRPCCompletion.getCode();
                        if (code == null) {
                            code = Code.UNKNOWN;
                        }
                        Code code2 = code;
                        GRPCCompletion gRPCCompletion2 = completion;
                        ByteString message = gRPCCompletion2 == null ? null : gRPCCompletion2.getMessage();
                        GRPCCompletion gRPCCompletion3 = completion;
                        List<ConnectErrorDetail> list = details = gRPCCompletion3 == null ? null : gRPCCompletion3.getErrorDetails();
                        if (result2.connectError() != null) {
                            connectError2 = result2.connectError();
                        } else if (result2.getError() != null || code2 != Code.OK) {
                            ErrorDetailParser errorDetailParser = GRPCInterceptor.access$getSerializationStrategy$p(this.this$0).errorDetailParser();
                            ByteString byteString = message;
                            String string = byteString == null ? null : byteString.utf8();
                            Throwable throwable = result2.getError();
                            List<ConnectErrorDetail> list2 = details;
                            if (list2 == null) {
                                list2 = CollectionsKt.emptyList();
                            }
                            connectError2 = new ConnectError(code2, errorDetailParser, string, throwable, list2, streamTrailers);
                        } else {
                            connectError2 = null;
                        }
                        ConnectError connectError3 = connectError = connectError2;
                        Code code3 = connectError3 == null ? null : connectError3.getCode();
                        if (code3 == null) {
                            code3 = Code.OK;
                        }
                        return new StreamResult.Complete<Output>(code3, connectError, streamTrailers);
                    }
                });
                return streamResult2;
            }
        });
    }

    private final Map<String, List<String>> withGRPCRequestHeaders(Map<String, ? extends List<String>> $this$withGRPCRequestHeaders) {
        Map<String, List<String>> headers = MapsKt.toMutableMap($this$withGRPCRequestHeaders);
        headers.put("x-user-agent", CollectionsKt.listOf("@bufbuild/connect-kotlin"));
        headers.put("te", CollectionsKt.listOf("trailers"));
        RequestCompression requestCompression = this.clientConfig.getRequestCompression();
        if (requestCompression != null) {
            headers.put("grpc-encoding", CollectionsKt.listOf(requestCompression.getCompressionPool().name()));
        }
        return headers;
    }

    public static final /* synthetic */ ProtocolClientConfig access$getClientConfig$p(GRPCInterceptor $this) {
        return $this.clientConfig;
    }

    public static final /* synthetic */ SerializationStrategy access$getSerializationStrategy$p(GRPCInterceptor $this) {
        return $this.serializationStrategy;
    }

    public static final /* synthetic */ Map access$withGRPCRequestHeaders(GRPCInterceptor $this, Map $receiver) {
        return $this.withGRPCRequestHeaders($receiver);
    }

    public static final /* synthetic */ GRPCCompletionParser access$getCompletionParser$p(GRPCInterceptor $this) {
        return $this.completionParser;
    }

    public static final /* synthetic */ void access$setResponseCompressionPool$p(GRPCInterceptor $this, CompressionPool compressionPool) {
        $this.responseCompressionPool = compressionPool;
    }

    public static final /* synthetic */ CompressionPool access$getResponseCompressionPool$p(GRPCInterceptor $this) {
        return $this.responseCompressionPool;
    }
}

