/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi;

import com.squareup.moshi.AdapterMethodsFactory;
import com.squareup.moshi.ArrayJsonAdapter;
import com.squareup.moshi.ClassJsonAdapter;
import com.squareup.moshi.CollectionJsonAdapter;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonQualifier;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.MapJsonAdapter;
import com.squareup.moshi.RecordJsonAdapter;
import com.squareup.moshi.StandardJsonAdapters;
import com.squareup.moshi.Types;
import com.squareup.moshi.internal.Util;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public final class Moshi {
    static final List<JsonAdapter.Factory> BUILT_IN_FACTORIES = new ArrayList<JsonAdapter.Factory>(5);
    private final List<JsonAdapter.Factory> factories;
    private final int lastOffset;
    private final ThreadLocal<LookupChain> lookupChainThreadLocal = new ThreadLocal();
    private final Map<Object, JsonAdapter<?>> adapterCache = new LinkedHashMap();

    Moshi(Builder builder) {
        ArrayList<JsonAdapter.Factory> factories = new ArrayList<JsonAdapter.Factory>(builder.factories.size() + BUILT_IN_FACTORIES.size());
        factories.addAll(builder.factories);
        factories.addAll(BUILT_IN_FACTORIES);
        this.factories = Collections.unmodifiableList(factories);
        this.lastOffset = builder.lastOffset;
    }

    @CheckReturnValue
    public <T> JsonAdapter<T> adapter(Type type2) {
        return this.adapter(type2, Util.NO_ANNOTATIONS);
    }

    @CheckReturnValue
    public <T> JsonAdapter<T> adapter(Class<T> type2) {
        return this.adapter(type2, Util.NO_ANNOTATIONS);
    }

    @CheckReturnValue
    public <T> JsonAdapter<T> adapter(Type type2, Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        return this.adapter(type2, Collections.singleton(Types.createJsonQualifierImplementation(annotationType)));
    }

    @CheckReturnValue
    public <T> JsonAdapter<T> adapter(Type type2, Class<? extends Annotation> ... annotationTypes) {
        if (annotationTypes.length == 1) {
            return this.adapter(type2, annotationTypes[0]);
        }
        LinkedHashSet<Annotation> annotations2 = new LinkedHashSet<Annotation>(annotationTypes.length);
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            annotations2.add(Types.createJsonQualifierImplementation(annotationType));
        }
        return this.adapter(type2, Collections.unmodifiableSet(annotations2));
    }

    @CheckReturnValue
    public <T> JsonAdapter<T> adapter(Type type2, Set<? extends Annotation> annotations2) {
        return this.adapter(type2, annotations2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckReturnValue
    public <T> JsonAdapter<T> adapter(Type type2, Set<? extends Annotation> annotations2, @Nullable String fieldName) {
        if (type2 == null) {
            throw new NullPointerException("type == null");
        }
        if (annotations2 == null) {
            throw new NullPointerException("annotations == null");
        }
        type2 = Util.removeSubtypeWildcard(Util.canonicalize(type2));
        Object cacheKey = this.cacheKey(type2, annotations2);
        Map<Object, JsonAdapter<?>> map2 = this.adapterCache;
        synchronized (map2) {
            JsonAdapter<?> result2 = this.adapterCache.get(cacheKey);
            if (result2 != null) {
                return result2;
            }
        }
        LookupChain lookupChain = this.lookupChainThreadLocal.get();
        if (lookupChain == null) {
            lookupChain = new LookupChain();
            this.lookupChainThreadLocal.set(lookupChain);
        }
        boolean success = false;
        JsonAdapter adapterFromCall = lookupChain.push(type2, fieldName, cacheKey);
        try {
            if (adapterFromCall != null) {
                JsonAdapter jsonAdapter = adapterFromCall;
                return jsonAdapter;
            }
            int i = 0;
            int size = this.factories.size();
            while (i < size) {
                JsonAdapter<?> result3 = this.factories.get(i).create(type2, annotations2, this);
                if (result3 != null) {
                    lookupChain.adapterFound(result3);
                    success = true;
                    JsonAdapter<?> jsonAdapter = result3;
                    return jsonAdapter;
                }
                ++i;
            }
            throw new IllegalArgumentException("No JsonAdapter for " + Util.typeAnnotatedWithAnnotations(type2, annotations2));
        }
        catch (IllegalArgumentException e) {
            throw lookupChain.exceptionWithLookupStack(e);
        }
        finally {
            lookupChain.pop(success);
        }
    }

    @CheckReturnValue
    public <T> JsonAdapter<T> nextAdapter(JsonAdapter.Factory skipPast, Type type2, Set<? extends Annotation> annotations2) {
        if (annotations2 == null) {
            throw new NullPointerException("annotations == null");
        }
        type2 = Util.removeSubtypeWildcard(Util.canonicalize(type2));
        int skipPastIndex = this.factories.indexOf(skipPast);
        if (skipPastIndex == -1) {
            throw new IllegalArgumentException("Unable to skip past unknown factory " + skipPast);
        }
        int size = this.factories.size();
        for (int i = skipPastIndex + 1; i < size; ++i) {
            JsonAdapter<?> result2 = this.factories.get(i).create(type2, annotations2, this);
            if (result2 == null) continue;
            return result2;
        }
        throw new IllegalArgumentException("No next JsonAdapter for " + Util.typeAnnotatedWithAnnotations(type2, annotations2));
    }

    @CheckReturnValue
    public Builder newBuilder() {
        int i;
        Builder result2 = new Builder();
        int limit = this.lastOffset;
        for (i = 0; i < limit; ++i) {
            result2.add(this.factories.get(i));
        }
        limit = this.factories.size() - BUILT_IN_FACTORIES.size();
        for (i = this.lastOffset; i < limit; ++i) {
            result2.addLast(this.factories.get(i));
        }
        return result2;
    }

    private Object cacheKey(Type type2, Set<? extends Annotation> annotations2) {
        if (annotations2.isEmpty()) {
            return type2;
        }
        return Arrays.asList(type2, annotations2);
    }

    static <T> JsonAdapter.Factory newAdapterFactory(final Type type2, final JsonAdapter<T> jsonAdapter) {
        if (type2 == null) {
            throw new IllegalArgumentException("type == null");
        }
        if (jsonAdapter == null) {
            throw new IllegalArgumentException("jsonAdapter == null");
        }
        return new JsonAdapter.Factory(){

            @Override
            @Nullable
            public JsonAdapter<?> create(Type targetType, Set<? extends Annotation> annotations2, Moshi moshi) {
                return annotations2.isEmpty() && Util.typesMatch(type2, targetType) ? jsonAdapter : null;
            }
        };
    }

    static <T> JsonAdapter.Factory newAdapterFactory(final Type type2, final Class<? extends Annotation> annotation, final JsonAdapter<T> jsonAdapter) {
        if (type2 == null) {
            throw new IllegalArgumentException("type == null");
        }
        if (annotation == null) {
            throw new IllegalArgumentException("annotation == null");
        }
        if (jsonAdapter == null) {
            throw new IllegalArgumentException("jsonAdapter == null");
        }
        if (!annotation.isAnnotationPresent(JsonQualifier.class)) {
            throw new IllegalArgumentException(annotation + " does not have @JsonQualifier");
        }
        if (annotation.getDeclaredMethods().length > 0) {
            throw new IllegalArgumentException("Use JsonAdapter.Factory for annotations with elements");
        }
        return new JsonAdapter.Factory(){

            @Override
            @Nullable
            public JsonAdapter<?> create(Type targetType, Set<? extends Annotation> annotations2, Moshi moshi) {
                if (Util.typesMatch(type2, targetType) && annotations2.size() == 1 && Util.isAnnotationPresent(annotations2, annotation)) {
                    return jsonAdapter;
                }
                return null;
            }
        };
    }

    static {
        BUILT_IN_FACTORIES.add(StandardJsonAdapters.FACTORY);
        BUILT_IN_FACTORIES.add(CollectionJsonAdapter.FACTORY);
        BUILT_IN_FACTORIES.add(MapJsonAdapter.FACTORY);
        BUILT_IN_FACTORIES.add(ArrayJsonAdapter.FACTORY);
        BUILT_IN_FACTORIES.add(RecordJsonAdapter.FACTORY);
        BUILT_IN_FACTORIES.add(ClassJsonAdapter.FACTORY);
    }

    public static final class Builder {
        final List<JsonAdapter.Factory> factories = new ArrayList<JsonAdapter.Factory>();
        int lastOffset = 0;

        public <T> Builder add(Type type2, JsonAdapter<T> jsonAdapter) {
            return this.add(Moshi.newAdapterFactory(type2, jsonAdapter));
        }

        public <T> Builder add(Type type2, Class<? extends Annotation> annotation, JsonAdapter<T> jsonAdapter) {
            return this.add(Moshi.newAdapterFactory(type2, annotation, jsonAdapter));
        }

        public Builder add(JsonAdapter.Factory factory) {
            if (factory == null) {
                throw new IllegalArgumentException("factory == null");
            }
            this.factories.add(this.lastOffset++, factory);
            return this;
        }

        public Builder add(Object adapter) {
            if (adapter == null) {
                throw new IllegalArgumentException("adapter == null");
            }
            return this.add(AdapterMethodsFactory.get(adapter));
        }

        public <T> Builder addLast(Type type2, JsonAdapter<T> jsonAdapter) {
            return this.addLast(Moshi.newAdapterFactory(type2, jsonAdapter));
        }

        public <T> Builder addLast(Type type2, Class<? extends Annotation> annotation, JsonAdapter<T> jsonAdapter) {
            return this.addLast(Moshi.newAdapterFactory(type2, annotation, jsonAdapter));
        }

        public Builder addLast(JsonAdapter.Factory factory) {
            if (factory == null) {
                throw new IllegalArgumentException("factory == null");
            }
            this.factories.add(factory);
            return this;
        }

        public Builder addLast(Object adapter) {
            if (adapter == null) {
                throw new IllegalArgumentException("adapter == null");
            }
            return this.addLast(AdapterMethodsFactory.get(adapter));
        }

        @CheckReturnValue
        public Moshi build() {
            return new Moshi(this);
        }
    }

    final class LookupChain {
        final List<Lookup<?>> callLookups = new ArrayList();
        final Deque<Lookup<?>> stack = new ArrayDeque();
        boolean exceptionAnnotated;

        LookupChain() {
        }

        <T> JsonAdapter<T> push(Type type2, @Nullable String fieldName, Object cacheKey) {
            int size = this.callLookups.size();
            for (int i = 0; i < size; ++i) {
                Lookup<?> lookup = this.callLookups.get(i);
                if (!lookup.cacheKey.equals(cacheKey)) continue;
                Lookup<?> hit = lookup;
                this.stack.add(hit);
                return hit.adapter != null ? hit.adapter : hit;
            }
            Lookup lookup = new Lookup(type2, fieldName, cacheKey);
            this.callLookups.add(lookup);
            this.stack.add(lookup);
            return null;
        }

        <T> void adapterFound(JsonAdapter<T> result2) {
            Lookup<?> currentLookup = this.stack.getLast();
            currentLookup.adapter = result2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void pop(boolean success) {
            this.stack.removeLast();
            if (!this.stack.isEmpty()) {
                return;
            }
            Moshi.this.lookupChainThreadLocal.remove();
            if (success) {
                Map map2 = Moshi.this.adapterCache;
                synchronized (map2) {
                    int size = this.callLookups.size();
                    for (int i = 0; i < size; ++i) {
                        Lookup<?> lookup = this.callLookups.get(i);
                        JsonAdapter replaced = Moshi.this.adapterCache.put(lookup.cacheKey, lookup.adapter);
                        if (replaced == null) continue;
                        lookup.adapter = replaced;
                        Moshi.this.adapterCache.put(lookup.cacheKey, replaced);
                    }
                }
            }
        }

        IllegalArgumentException exceptionWithLookupStack(IllegalArgumentException e) {
            if (this.exceptionAnnotated) {
                return e;
            }
            this.exceptionAnnotated = true;
            int size = this.stack.size();
            if (size == 1 && this.stack.getFirst().fieldName == null) {
                return e;
            }
            StringBuilder errorMessageBuilder = new StringBuilder(e.getMessage());
            Iterator<Lookup<?>> i = this.stack.descendingIterator();
            while (i.hasNext()) {
                Lookup<?> lookup = i.next();
                errorMessageBuilder.append("\nfor ").append(lookup.type);
                if (lookup.fieldName == null) continue;
                errorMessageBuilder.append(' ').append(lookup.fieldName);
            }
            return new IllegalArgumentException(errorMessageBuilder.toString(), e);
        }
    }

    static final class Lookup<T>
    extends JsonAdapter<T> {
        final Type type;
        @Nullable
        final String fieldName;
        final Object cacheKey;
        @Nullable
        JsonAdapter<T> adapter;

        Lookup(Type type2, @Nullable String fieldName, Object cacheKey) {
            this.type = type2;
            this.fieldName = fieldName;
            this.cacheKey = cacheKey;
        }

        @Override
        public T fromJson(JsonReader reader) throws IOException {
            if (this.adapter == null) {
                throw new IllegalStateException("JsonAdapter isn't ready");
            }
            return this.adapter.fromJson(reader);
        }

        @Override
        public void toJson(JsonWriter writer, T value) throws IOException {
            if (this.adapter == null) {
                throw new IllegalStateException("JsonAdapter isn't ready");
            }
            this.adapter.toJson(writer, value);
        }

        public String toString() {
            return this.adapter != null ? this.adapter.toString() : super.toString();
        }
    }
}

