/*
 * Decompiled with CFR 0.152.
 */
package build.buf.connect.compression;

import build.buf.connect.compression.CompressionPool;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.GzipSink;
import okio.GzipSource;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lbuild/buf/connect/compression/GzipCompressionPool;", "Lbuild/buf/connect/compression/CompressionPool;", "()V", "compress", "Lokio/Buffer;", "buffer", "decompress", "name", "", "library"})
public final class GzipCompressionPool
implements CompressionPool {
    @NotNull
    public static final GzipCompressionPool INSTANCE = new GzipCompressionPool();

    private GzipCompressionPool() {
    }

    @Override
    @NotNull
    public String name() {
        return "gzip";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Buffer compress(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Buffer gzippedSink = new Buffer();
        Closeable closeable = (Closeable)new GzipSink((Sink)gzippedSink);
        Throwable throwable = null;
        try {
            GzipSink source = (GzipSink)closeable;
            boolean bl = false;
            source.write(buffer, buffer.size());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return gzippedSink;
    }

    @Override
    @NotNull
    public Buffer decompress(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Buffer result = new Buffer();
        GzipSource source = new GzipSource((Source)buffer);
        while (source.read(result, Integer.MAX_VALUE) != -1L) {
        }
        return result;
    }
}

