/*
 * Decompiled with CFR 0.152.
 */
package build.buf.connect.protocols;

import build.buf.connect.Code;
import build.buf.connect.ConnectError;
import build.buf.connect.ErrorDetailParser;
import build.buf.connect.Interceptor;
import build.buf.connect.ProtocolClientConfig;
import build.buf.connect.RequestCompression;
import build.buf.connect.SerializationStrategy;
import build.buf.connect.StreamFunction;
import build.buf.connect.StreamResult;
import build.buf.connect.UnaryFunction;
import build.buf.connect.compression.CompressionPool;
import build.buf.connect.http.HTTPRequest;
import build.buf.connect.http.HTTPResponse;
import build.buf.connect.http.TracingInfo;
import build.buf.connect.protocols.ConnectConstants;
import build.buf.connect.protocols.Envelope;
import build.buf.connect.protocols.GRPCCompletion;
import build.buf.connect.protocols.GRPCCompletionParser;
import build.buf.connect.protocols.GRPCWebInterceptor;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e0\fj\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J8\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e0\fj\u0002`\u0017*\u0018\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e0\fj\u0002`\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lbuild/buf/connect/protocols/GRPCWebInterceptor;", "Lbuild/buf/connect/Interceptor;", "clientConfig", "Lbuild/buf/connect/ProtocolClientConfig;", "(Lbuild/buf/connect/ProtocolClientConfig;)V", "completionParser", "Lbuild/buf/connect/protocols/GRPCCompletionParser;", "responseCompressionPool", "Lbuild/buf/connect/compression/CompressionPool;", "serializationStrategy", "Lbuild/buf/connect/SerializationStrategy;", "parseGrpcWebTrailer", "", "", "", "Lbuild/buf/connect/Trailers;", "buffer", "Lokio/Buffer;", "streamFunction", "Lbuild/buf/connect/StreamFunction;", "unaryFunction", "Lbuild/buf/connect/UnaryFunction;", "withGRPCRequestHeaders", "Lbuild/buf/connect/Headers;", "library"})
public final class GRPCWebInterceptor
implements Interceptor {
    @NotNull
    private final ProtocolClientConfig clientConfig;
    @NotNull
    private final SerializationStrategy serializationStrategy;
    @NotNull
    private final GRPCCompletionParser completionParser;
    @Nullable
    private CompressionPool responseCompressionPool;

    public GRPCWebInterceptor(@NotNull ProtocolClientConfig clientConfig) {
        Intrinsics.checkNotNullParameter((Object)clientConfig, (String)"clientConfig");
        this.clientConfig = clientConfig;
        this.serializationStrategy = this.clientConfig.getSerializationStrategy();
        this.completionParser = new GRPCCompletionParser(this.serializationStrategy.errorDetailParser());
    }

    @Override
    @NotNull
    public UnaryFunction unaryFunction() {
        return new UnaryFunction((Function1<? super HTTPRequest, HTTPRequest>)((Function1)new Function1<HTTPRequest, HTTPRequest>(this){
            final /* synthetic */ GRPCWebInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final HTTPRequest invoke(@NotNull HTTPRequest request) {
                Buffer buffer;
                Closeable $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Map requestHeaders = new LinkedHashMap<K, V>();
                requestHeaders.putAll(request.getHeaders());
                if (!((Collection)GRPCWebInterceptor.access$getClientConfig$p(this.this$0).compressionPools()).isEmpty()) {
                    Collection<String> collection;
                    void $this$map$iv;
                    Iterable iterable = GRPCWebInterceptor.access$getClientConfig$p(this.this$0).compressionPools();
                    String string = "grpc-accept-encoding";
                    Map map = requestHeaders;
                    boolean $i$f$map = false;
                    void var5_8 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void compressionPool;
                        T item$iv$iv = iterator.next();
                        CompressionPool compressionPool2 = (CompressionPool)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(compressionPool.name());
                    }
                    collection = (List)destination$iv$iv;
                    map.put(string, collection);
                }
                RequestCompression requestCompressionPool = GRPCWebInterceptor.access$getClientConfig$p(this.this$0).getRequestCompression();
                $this$mapTo$iv$iv = (Closeable)new Buffer();
                Throwable throwable = null;
                try {
                    Buffer buffer2 = (Buffer)$this$mapTo$iv$iv;
                    boolean bl = false;
                    if (request.getMessage() != null) {
                        buffer2.write(request.getMessage());
                    }
                    buffer = buffer2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)$this$mapTo$iv$iv, (Throwable)throwable);
                }
                Buffer requestMessage = buffer;
                RequestCompression requestCompression = requestCompressionPool;
                RequestCompression requestCompression2 = requestCompressionPool;
                Buffer envelopedMessage = Envelope.Companion.pack(requestMessage, requestCompression != null ? requestCompression.getCompressionPool() : null, requestCompression2 != null ? Integer.valueOf(requestCompression2.getMinBytes()) : null);
                return HTTPRequest.clone$default(request, request.getUrl(), "application/grpc-web+" + GRPCWebInterceptor.access$getSerializationStrategy$p(this.this$0).serializationName(), GRPCWebInterceptor.access$withGRPCRequestHeaders(this.this$0, requestHeaders), envelopedMessage.readByteArray(), null, 16, null);
            }
        }), (Function1<? super HTTPResponse, HTTPResponse>)((Function1)new Function1<HTTPResponse, HTTPResponse>(this){
            final /* synthetic */ GRPCWebInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final HTTPResponse invoke(@NotNull HTTPResponse response) {
                HTTPResponse hTTPResponse;
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (response.getCode() != Code.OK) {
                    Code code = response.getCode();
                    Map map = MapsKt.toMutableMap(response.getHeaders());
                    Buffer buffer = new Buffer();
                    Map map2 = MapsKt.emptyMap();
                    ConnectError connectError = response.getError();
                    TracingInfo tracingInfo = response.getTracingInfo();
                    return new HTTPResponse(code, map, (BufferedSource)buffer, map2, tracingInfo, connectError);
                }
                Map responseHeaders = MapsKt.toMutableMap(response.getHeaders());
                List list = (List)responseHeaders.get("grpc-encoding");
                CompressionPool compressionPool = GRPCWebInterceptor.access$getClientConfig$p(this.this$0).compressionPool(list != null ? (String)CollectionsKt.first((List)list) : null);
                if (response.getMessage().exhausted()) {
                    Map<String, List<String>> trailers = response.getHeaders();
                    GRPCCompletion completion = GRPCWebInterceptor.access$getCompletionParser$p(this.this$0).parse$library(trailers);
                    Object object = completion;
                    if (object == null || (object = object.getCode()) == null) {
                        object = response.getCode();
                    }
                    Object code = object;
                    Buffer result = new Buffer();
                    if (completion != null) {
                        ByteString errorMessage = completion.getMessage();
                        result.write(errorMessage);
                    }
                    ErrorDetailParser errorDetailParser = GRPCWebInterceptor.access$getSerializationStrategy$p(this.this$0).errorDetailParser();
                    GRPCCompletion gRPCCompletion = completion;
                    String string = gRPCCompletion != null && (gRPCCompletion = gRPCCompletion.getMessage()) != null ? gRPCCompletion.utf8() : null;
                    Object object2 = completion;
                    if (object2 == null || (object2 = ((GRPCCompletion)object2).getErrorDetails()) == null) {
                        object2 = CollectionsKt.emptyList();
                    }
                    ConnectError connectError = new ConnectError((Code)((Object)code), errorDetailParser, string, null, (List)object2, null, 40, null);
                    TracingInfo tracingInfo = response.getTracingInfo();
                    hTTPResponse = new HTTPResponse((Code)((Object)code), responseHeaders, (BufferedSource)result, trailers, tracingInfo, connectError);
                } else {
                    ConnectError connectError;
                    Object finalCode;
                    Buffer trailerBuffer;
                    Buffer responseBuffer = response.getMessage().getBuffer();
                    Buffer currentMessage = new Buffer();
                    byte header = responseBuffer.readByte();
                    int length = responseBuffer.readInt();
                    currentMessage.writeByte((int)header);
                    currentMessage.writeInt(length);
                    currentMessage.write(responseBuffer, (long)length);
                    Pair<Integer, Buffer> pair = Envelope.Companion.unpackWithHeaderByte(currentMessage, compressionPool);
                    int headerByte = ((Number)pair.component1()).intValue();
                    Buffer unpacked = (Buffer)pair.component2();
                    Buffer trailerBuffer2 = (headerByte & 0x80) == 128 ? unpacked : (trailerBuffer = (Buffer)Envelope.Companion.unpackWithHeaderByte(responseBuffer, compressionPool).component2());
                    Map finalTrailers = GRPCWebInterceptor.access$parseGrpcWebTrailer(this.this$0, trailerBuffer2);
                    GRPCCompletion completionWithMessage = GRPCWebInterceptor.access$getCompletionParser$p(this.this$0).parse$library(finalTrailers);
                    Object object = completionWithMessage;
                    if (object == null || (object = object.getCode()) == null) {
                        object = Code.UNKNOWN;
                    }
                    if ((finalCode = object) != Code.OK && completionWithMessage != null) {
                        Buffer result = new Buffer();
                        ByteString errorMessage = completionWithMessage.getMessage();
                        result.write(errorMessage);
                        connectError = new ConnectError((Code)((Object)finalCode), GRPCWebInterceptor.access$getSerializationStrategy$p(this.this$0).errorDetailParser(), errorMessage.utf8(), null, completionWithMessage.getErrorDetails(), null, 40, null);
                    } else {
                        connectError = null;
                    }
                    ConnectError error = connectError;
                    TracingInfo tracingInfo = response.getTracingInfo();
                    hTTPResponse = new HTTPResponse((Code)((Object)finalCode), responseHeaders, (BufferedSource)unpacked, finalTrailers, tracingInfo, error);
                }
                return hTTPResponse;
            }
        }));
    }

    @Override
    @NotNull
    public StreamFunction streamFunction() {
        return new StreamFunction((Function1<? super HTTPRequest, HTTPRequest>)((Function1)new Function1<HTTPRequest, HTTPRequest>(this){
            final /* synthetic */ GRPCWebInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final HTTPRequest invoke(@NotNull HTTPRequest request) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                return HTTPRequest.clone$default(request, request.getUrl(), "application/grpc-web+" + GRPCWebInterceptor.access$getSerializationStrategy$p(this.this$0).serializationName(), GRPCWebInterceptor.access$withGRPCRequestHeaders(this.this$0, request.getHeaders()), request.getMessage(), null, 16, null);
            }
        }), (Function1<? super Buffer, Buffer>)((Function1)new Function1<Buffer, Buffer>(this){
            final /* synthetic */ GRPCWebInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Buffer invoke(@NotNull Buffer buffer) {
                RequestCompression requestCompression;
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                RequestCompression requestCompression2 = requestCompression = GRPCWebInterceptor.access$getClientConfig$p(this.this$0).getRequestCompression();
                RequestCompression requestCompression3 = requestCompression;
                return Envelope.Companion.pack(buffer, requestCompression2 != null ? requestCompression2.getCompressionPool() : null, requestCompression3 != null ? Integer.valueOf(requestCompression3.getMinBytes()) : null);
            }
        }), (Function1<? super StreamResult<Buffer>, ? extends StreamResult<Buffer>>)((Function1)new Function1<StreamResult<Buffer>, StreamResult<Buffer>>(this){
            final /* synthetic */ GRPCWebInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final StreamResult<Buffer> invoke(@NotNull StreamResult<Buffer> res) {
                Intrinsics.checkNotNullParameter(res, (String)"res");
                StreamResult streamResult2 = (StreamResult)res.fold((Function1)new Function1<StreamResult.Headers<Buffer>, StreamResult<Buffer>>(this.this$0){
                    final /* synthetic */ GRPCWebInterceptor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final StreamResult<Buffer> invoke(@NotNull StreamResult.Headers<Buffer> result) {
                        void $this$filterTo$iv$iv;
                        Intrinsics.checkNotNullParameter(result, (String)"result");
                        Map<String, List<String>> $this$filter$iv = result.getHeaders();
                        boolean $i$f$filter = false;
                        Map<String, List<String>> map = $this$filter$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>();
                        boolean $i$f$filterTo = false;
                        Iterator<Map.Entry<K, V>> iterator = $this$filterTo$iv$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<K, V> element$iv$iv;
                            Map.Entry<K, V> entry = element$iv$iv = iterator.next();
                            boolean bl = false;
                            if (!(!StringsKt.startsWith$default((String)((String)entry.getKey()), (String)"trailer", (boolean)false, (int)2, null))) continue;
                            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                        }
                        Map responseHeaders = MapsKt.toMutableMap((Map)destination$iv$iv);
                        List list = (List)responseHeaders.get("grpc-encoding");
                        GRPCWebInterceptor.access$setResponseCompressionPool$p(this.this$0, GRPCWebInterceptor.access$getClientConfig$p(this.this$0).compressionPool(list != null ? (String)CollectionsKt.first((List)list) : null));
                        Map streamTrailers = responseHeaders;
                        GRPCCompletion completion = GRPCWebInterceptor.access$getCompletionParser$p(this.this$0).parse$library(streamTrailers);
                        if (completion != null) {
                            ConnectError error = completion.getCode() != Code.OK ? new ConnectError(completion.getCode(), GRPCWebInterceptor.access$getSerializationStrategy$p(this.this$0).errorDetailParser(), completion.getMessage().utf8(), null, completion.getErrorDetails(), streamTrailers, 8, null) : (ConnectError)null;
                            return new StreamResult.Complete<Output>(completion.getCode(), error, responseHeaders);
                        }
                        return new StreamResult.Headers<Output>(responseHeaders);
                    }
                }, (Function1)new Function1<StreamResult.Message<Buffer>, StreamResult<Buffer>>(this.this$0){
                    final /* synthetic */ GRPCWebInterceptor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final StreamResult<Buffer> invoke(@NotNull StreamResult.Message<Buffer> result) {
                        Intrinsics.checkNotNullParameter(result, (String)"result");
                        Pair<Integer, Buffer> pair = Envelope.Companion.unpackWithHeaderByte(result.getMessage(), GRPCWebInterceptor.access$getResponseCompressionPool$p(this.this$0));
                        int headerByte = ((Number)pair.component1()).intValue();
                        Buffer unpackedMessage = (Buffer)pair.component2();
                        if ((headerByte & 0x80) == 128) {
                            GRPCCompletion completion;
                            Map streamTrailers = GRPCWebInterceptor.access$parseGrpcWebTrailer(this.this$0, unpackedMessage);
                            GRPCCompletion gRPCCompletion = completion = GRPCWebInterceptor.access$getCompletionParser$p(this.this$0).parse$library(streamTrailers);
                            Intrinsics.checkNotNull((Object)gRPCCompletion);
                            Code code = gRPCCompletion.getCode();
                            ConnectError connectError = result.connectError() != null ? result.connectError() : (result.getError() != null || code != Code.OK ? new ConnectError(code, GRPCWebInterceptor.access$getSerializationStrategy$p(this.this$0).errorDetailParser(), completion.getMessage().utf8(), result.getError(), completion.getErrorDetails(), streamTrailers) : (ConnectError)null);
                            return new StreamResult.Complete<Output>(code, connectError, streamTrailers);
                        }
                        return new StreamResult.Message<Buffer>(unpackedMessage);
                    }
                }, streamFunction.streamResult.3.INSTANCE);
                return streamResult2;
            }
        }));
    }

    private final Map<String, List<String>> withGRPCRequestHeaders(Map<String, ? extends List<String>> $this$withGRPCRequestHeaders) {
        boolean bl;
        Map headers;
        block5: {
            headers = MapsKt.toMutableMap($this$withGRPCRequestHeaders);
            Iterable $this$none$iv = headers.keySet();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)it, (String)"x-user-agent", (boolean)true)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            headers.put("x-user-agent", CollectionsKt.listOf((Object)("grpc-kotlin-connect/" + ConnectConstants.INSTANCE.getVERSION())));
        }
        headers.put("te", CollectionsKt.listOf((Object)"trailers"));
        RequestCompression requestCompression = this.clientConfig.getRequestCompression();
        if (requestCompression != null) {
            headers.put("grpc-encoding", CollectionsKt.listOf((Object)requestCompression.getCompressionPool().name()));
        }
        return headers;
    }

    private final Map<String, List<String>> parseGrpcWebTrailer(Buffer buffer) {
        Map trailers = new LinkedHashMap();
        String[] stringArray = new String[]{"\r\n"};
        List lines = StringsKt.split$default((CharSequence)buffer.readUtf8(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        for (String line : lines) {
            String value;
            String name;
            int i;
            if (Intrinsics.areEqual((Object)line, (Object)"") || (i = StringsKt.indexOf$default((CharSequence)line, (String)":", (int)0, (boolean)false, (int)6, null)) <= 0) continue;
            String string = line.substring(0, i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Intrinsics.checkNotNullExpressionValue((Object)((Object)StringsKt.trim((CharSequence)string)).toString().toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String string2 = line.substring(i + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            Intrinsics.checkNotNullExpressionValue((Object)((Object)StringsKt.trim((CharSequence)string2)).toString().toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String string3 = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            trailers.put(string3, CollectionsKt.listOf((Object)value));
        }
        return trailers;
    }

    public static final /* synthetic */ ProtocolClientConfig access$getClientConfig$p(GRPCWebInterceptor $this) {
        return $this.clientConfig;
    }

    public static final /* synthetic */ SerializationStrategy access$getSerializationStrategy$p(GRPCWebInterceptor $this) {
        return $this.serializationStrategy;
    }

    public static final /* synthetic */ Map access$withGRPCRequestHeaders(GRPCWebInterceptor $this, Map $receiver) {
        return $this.withGRPCRequestHeaders($receiver);
    }

    public static final /* synthetic */ GRPCCompletionParser access$getCompletionParser$p(GRPCWebInterceptor $this) {
        return $this.completionParser;
    }

    public static final /* synthetic */ Map access$parseGrpcWebTrailer(GRPCWebInterceptor $this, Buffer buffer) {
        return $this.parseGrpcWebTrailer(buffer);
    }

    public static final /* synthetic */ void access$setResponseCompressionPool$p(GRPCWebInterceptor $this, CompressionPool compressionPool) {
        $this.responseCompressionPool = compressionPool;
    }

    public static final /* synthetic */ CompressionPool access$getResponseCompressionPool$p(GRPCWebInterceptor $this) {
        return $this.responseCompressionPool;
    }
}

