/*
 * Decompiled with CFR 0.152.
 */
package build.buf.connect.protocols;

import build.buf.connect.Code;
import build.buf.connect.ConnectError;
import build.buf.connect.ConnectErrorDetail;
import build.buf.connect.ErrorDetailParser;
import build.buf.connect.Interceptor;
import build.buf.connect.ProtocolClientConfig;
import build.buf.connect.SerializationStrategy;
import build.buf.connect.StreamFunction;
import build.buf.connect.StreamResult;
import build.buf.connect.UnaryFunction;
import build.buf.connect.compression.CompressionPool;
import build.buf.connect.compression.RequestCompression;
import build.buf.connect.http.HTTPRequest;
import build.buf.connect.http.HTTPResponse;
import build.buf.connect.http.TracingInfo;
import build.buf.connect.protocols.ConnectInterceptor;
import build.buf.connect.protocols.ConnectInterceptorKt;
import build.buf.connect.protocols.EndStreamResponseJSON;
import build.buf.connect.protocols.Envelope;
import build.buf.connect.protocols.ErrorDetailPayloadJSON;
import build.buf.connect.protocols.ErrorPayloadJSON;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.kotlin.reflect.KotlinJsonAdapterFactory;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u001c\u0010\u0014\u001a\u0018\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00170\u0015j\u0002`\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lbuild/buf/connect/protocols/ConnectInterceptor;", "Lbuild/buf/connect/Interceptor;", "clientConfig", "Lbuild/buf/connect/ProtocolClientConfig;", "(Lbuild/buf/connect/ProtocolClientConfig;)V", "moshi", "Lcom/squareup/moshi/Moshi;", "kotlin.jvm.PlatformType", "responseCompressionPool", "Lbuild/buf/connect/compression/CompressionPool;", "serializationStrategy", "Lbuild/buf/connect/SerializationStrategy;", "parseConnectEndStream", "Lbuild/buf/connect/StreamResult$Complete;", "Lokio/Buffer;", "source", "parseConnectUnaryError", "Lbuild/buf/connect/ConnectError;", "code", "Lbuild/buf/connect/Code;", "headers", "", "", "", "Lbuild/buf/connect/Headers;", "parseErrorDetails", "Lbuild/buf/connect/ConnectErrorDetail;", "jsonClass", "Lbuild/buf/connect/protocols/ErrorPayloadJSON;", "streamFunction", "Lbuild/buf/connect/StreamFunction;", "unaryFunction", "Lbuild/buf/connect/UnaryFunction;", "library"})
public final class ConnectInterceptor
implements Interceptor {
    @NotNull
    private final ProtocolClientConfig clientConfig;
    private final Moshi moshi;
    @NotNull
    private final SerializationStrategy serializationStrategy;
    @Nullable
    private CompressionPool responseCompressionPool;

    public ConnectInterceptor(@NotNull ProtocolClientConfig clientConfig) {
        Intrinsics.checkNotNullParameter((Object)clientConfig, (String)"clientConfig");
        this.clientConfig = clientConfig;
        this.moshi = new Moshi.Builder().add((JsonAdapter.Factory)new KotlinJsonAdapterFactory()).build();
        this.serializationStrategy = this.clientConfig.getSerializationStrategy();
    }

    @Override
    @NotNull
    public UnaryFunction unaryFunction() {
        return new UnaryFunction((Function1<? super HTTPRequest, HTTPRequest>)((Function1)new Function1<HTTPRequest, HTTPRequest>(this){
            final /* synthetic */ ConnectInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final HTTPRequest invoke(@NotNull HTTPRequest request) {
                Buffer buffer;
                Buffer buffer2;
                Closeable $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Object object = new Pair[]{TuplesKt.to((Object)"connect-protocol-version", (Object)CollectionsKt.listOf((Object)"1"))};
                Map requestHeaders = MapsKt.mutableMapOf((Pair[])object);
                requestHeaders.putAll(request.getHeaders());
                if (!((Collection)ConnectInterceptor.access$getClientConfig$p(this.this$0).compressionPools()).isEmpty()) {
                    Collection<String> collection;
                    void $this$map$iv;
                    object = ConnectInterceptor.access$getClientConfig$p(this.this$0).compressionPools();
                    String string = "accept-encoding";
                    Map map = requestHeaders;
                    boolean $i$f$map = false;
                    void var5_8 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void compressionPool;
                        T item$iv$iv = iterator.next();
                        CompressionPool compressionPool2 = (CompressionPool)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(compressionPool.name());
                    }
                    collection = (List)destination$iv$iv;
                    map.put(string, collection);
                }
                RequestCompression requestCompression = ConnectInterceptor.access$getClientConfig$p(this.this$0).getRequestCompression();
                $this$mapTo$iv$iv = (Closeable)new Buffer();
                Throwable throwable = null;
                try {
                    Buffer buffer3 = (Buffer)$this$mapTo$iv$iv;
                    boolean bl = false;
                    if (request.getMessage() != null) {
                        buffer3.write(request.getMessage());
                    }
                    buffer2 = buffer3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)$this$mapTo$iv$iv, (Throwable)throwable);
                }
                Buffer requestMessage = buffer2;
                if (requestCompression != null && requestCompression.shouldCompress(requestMessage)) {
                    requestHeaders.put("content-encoding", CollectionsKt.listOf((Object)requestCompression.getCompressionPool().name()));
                    buffer = requestCompression.getCompressionPool().compress(requestMessage);
                } else {
                    buffer = requestMessage;
                }
                Buffer finalRequestBody = buffer;
                return new HTTPRequest(request.getUrl(), request.getContentType(), requestHeaders, finalRequestBody.readByteArray());
            }
        }), (Function1<? super HTTPResponse, HTTPResponse>)((Function1)new Function1<HTTPResponse, HTTPResponse>(this){
            final /* synthetic */ ConnectInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final HTTPResponse invoke(@NotNull HTTPResponse response) {
                ConnectError connectError;
                Buffer message;
                Pair pair;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Map trailers = new LinkedHashMap<K, V>();
                trailers.putAll(ConnectInterceptorKt.access$toTrailers(response.getHeaders()));
                trailers.putAll(response.getTrailers());
                Map<String, List<String>> $this$filter$iv = response.getHeaders();
                boolean $i$f$filter = false;
                Map<String, List<String>> map = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$filterTo = false;
                Object object = $this$filterTo$iv$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry<K, V> element$iv$iv;
                    Map.Entry<K, V> entry = element$iv$iv = object.next();
                    boolean bl = false;
                    if (!(!StringsKt.startsWith$default((String)((String)entry.getKey()), (String)"trailer", (boolean)false, (int)2, null))) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Map responseHeaders = MapsKt.toMutableMap((Map)destination$iv$iv);
                List list = (List)responseHeaders.get("content-encoding");
                CompressionPool compressionPool = ConnectInterceptor.access$getClientConfig$p(this.this$0).compressionPool(list == null ? null : (String)CollectionsKt.first((List)list));
                if (response.getCode() != Code.OK) {
                    ConnectError error = ConnectInterceptor.access$parseConnectUnaryError(this.this$0, response.getCode(), response.getHeaders(), response.getMessage().getBuffer());
                    pair = TuplesKt.to((Object)((Object)error.getCode()), (Object)error);
                } else {
                    pair = TuplesKt.to((Object)((Object)response.getCode()), null);
                }
                Pair pair2 = pair;
                Code code = (Code)((Object)pair2.component1());
                ConnectError connectError2 = (ConnectError)pair2.component2();
                CompressionPool compressionPool2 = compressionPool;
                Buffer buffer = compressionPool2 == null ? null : compressionPool2.decompress(response.getMessage().getBuffer());
                if (buffer == null) {
                    buffer = message = response.getMessage().getBuffer();
                }
                if ((connectError = response.getError()) == null) {
                    connectError = connectError2;
                }
                object = connectError;
                TracingInfo tracingInfo = response.getTracingInfo();
                return new HTTPResponse(code, responseHeaders, (BufferedSource)message, trailers, tracingInfo, (ConnectError)object);
            }
        }));
    }

    @Override
    @NotNull
    public StreamFunction streamFunction() {
        RequestCompression requestCompression = this.clientConfig.getRequestCompression();
        return new StreamFunction((Function1<? super HTTPRequest, HTTPRequest>)((Function1)new Function1<HTTPRequest, HTTPRequest>(requestCompression, this){
            final /* synthetic */ RequestCompression $requestCompression;
            final /* synthetic */ ConnectInterceptor this$0;
            {
                this.$requestCompression = $requestCompression;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final HTTPRequest invoke(@NotNull HTTPRequest request) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Object object = new Pair[]{TuplesKt.to((Object)"connect-protocol-version", (Object)CollectionsKt.listOf((Object)"1"))};
                Map requestHeaders = MapsKt.mutableMapOf((Pair[])object);
                requestHeaders.putAll(request.getHeaders());
                if (this.$requestCompression != null) {
                    requestHeaders.put("connect-content-encoding", CollectionsKt.listOf((Object)this.$requestCompression.getCompressionPool().name()));
                }
                object = ConnectInterceptor.access$getClientConfig$p(this.this$0).compressionPools();
                String string = "connect-accept-encoding";
                Map map = requestHeaders;
                boolean $i$f$map = false;
                void var5_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void entry;
                    CompressionPool compressionPool = (CompressionPool)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(entry.name());
                }
                collection = (List)destination$iv$iv;
                map.put(string, collection);
                return new HTTPRequest(request.getUrl(), request.getContentType(), requestHeaders, request.getMessage());
            }
        }), (Function1<? super Buffer, Buffer>)((Function1)new Function1<Buffer, Buffer>(requestCompression){
            final /* synthetic */ RequestCompression $requestCompression;
            {
                this.$requestCompression = $requestCompression;
                super(1);
            }

            @NotNull
            public final Buffer invoke(@NotNull Buffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                RequestCompression requestCompression = this.$requestCompression;
                CompressionPool compressionPool = requestCompression == null ? null : requestCompression.getCompressionPool();
                RequestCompression requestCompression2 = this.$requestCompression;
                return Envelope.Companion.pack(buffer, compressionPool, requestCompression2 == null ? null : Integer.valueOf(requestCompression2.getMinBytes()));
            }
        }), (Function1<? super StreamResult<Buffer>, ? extends StreamResult<Buffer>>)((Function1)new Function1<StreamResult<Buffer>, StreamResult<Buffer>>(this){
            final /* synthetic */ ConnectInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final StreamResult<Buffer> invoke(@NotNull StreamResult<Buffer> res) {
                Intrinsics.checkNotNullParameter(res, (String)"res");
                StreamResult streamResult2 = (StreamResult)res.fold((Function1)new Function1<StreamResult.Headers<Buffer>, StreamResult<Buffer>>(this.this$0){
                    final /* synthetic */ ConnectInterceptor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final StreamResult<Buffer> invoke(@NotNull StreamResult.Headers<Buffer> result) {
                        void $this$filterTo$iv$iv;
                        Intrinsics.checkNotNullParameter(result, (String)"result");
                        Map<String, List<String>> $this$filter$iv = result.getHeaders();
                        boolean $i$f$filter = false;
                        Map<String, List<String>> map = $this$filter$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>();
                        boolean $i$f$filterTo = false;
                        Iterator<Map.Entry<K, V>> iterator = $this$filterTo$iv$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<K, V> element$iv$iv;
                            Map.Entry<K, V> entry = element$iv$iv = iterator.next();
                            boolean bl = false;
                            if (!(!StringsKt.startsWith$default((String)((String)entry.getKey()), (String)"trailer", (boolean)false, (int)2, null))) continue;
                            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                        }
                        Map responseHeaders = MapsKt.toMutableMap((Map)destination$iv$iv);
                        List list = (List)responseHeaders.get("connect-content-encoding");
                        ConnectInterceptor.access$setResponseCompressionPool$p(this.this$0, ConnectInterceptor.access$getClientConfig$p(this.this$0).compressionPool(list == null ? null : (String)CollectionsKt.first((List)list)));
                        return new StreamResult.Headers<Output>(responseHeaders);
                    }
                }, (Function1)new Function1<StreamResult.Message<Buffer>, StreamResult<Buffer>>(this.this$0){
                    final /* synthetic */ ConnectInterceptor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final StreamResult<Buffer> invoke(@NotNull StreamResult.Message<Buffer> result) {
                        Intrinsics.checkNotNullParameter(result, (String)"result");
                        Pair<Integer, Buffer> pair = Envelope.Companion.unpackWithHeaderByte(result.getMessage(), ConnectInterceptor.access$getResponseCompressionPool$p(this.this$0));
                        int headerByte = ((Number)pair.component1()).intValue();
                        Buffer unpackedMessage = (Buffer)pair.component2();
                        boolean isEndStream = (headerByte >> 1 & 1) == 1;
                        return isEndStream ? (StreamResult)ConnectInterceptor.access$parseConnectEndStream(this.this$0, unpackedMessage) : (StreamResult)new StreamResult.Message<Buffer>(unpackedMessage);
                    }
                }, streamFunction.streamResult.3.INSTANCE);
                return streamResult2;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final StreamResult.Complete<Buffer> parseConnectEndStream(Buffer source) {
        StreamResult.Complete<Buffer> complete;
        JsonAdapter adapter = this.moshi.adapter(EndStreamResponseJSON.class);
        Closeable closeable = (Closeable)source;
        Throwable throwable = null;
        try {
            Map map;
            EndStreamResponseJSON endStreamResponseJSON;
            block17: {
                Buffer bufferedSource = (Buffer)closeable;
                boolean bl = false;
                String errorJSON = bufferedSource.readUtf8();
                try {
                    if ((EndStreamResponseJSON)adapter.fromJson(errorJSON) != null) break block17;
                    StreamResult.Complete<Buffer> complete2 = new StreamResult.Complete<Buffer>(Code.OK, null, null, 6, null);
                    return complete2;
                }
                catch (Throwable e) {
                    StreamResult.Complete<Buffer> complete3 = new StreamResult.Complete<Buffer>(Code.UNKNOWN, e, null, 4, null);
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    return complete3;
                }
            }
            EndStreamResponseJSON endStreamResponseJSON2 = endStreamResponseJSON;
            EndStreamResponseJSON endStreamResponseJSON3 = endStreamResponseJSON2;
            Map<String, List<String>> map2 = endStreamResponseJSON3.getMetadata();
            if (map2 == null) {
                map = null;
            } else {
                void $this$mapKeysTo$iv$iv;
                Map<String, List<String>> $this$mapKeys$iv = map2;
                boolean $i$f$mapKeys = false;
                Map<String, List<String>> map3 = $this$mapKeys$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                boolean $i$f$mapKeysTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    String string;
                    void it$iv$iv;
                    void entry;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Map map4 = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)((String)entry.getKey()).toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                    Map map5 = map4;
                    boolean bl2 = false;
                    entry2 = it$iv$iv.getValue();
                    map5.put(string, entry2);
                }
                map = destination$iv$iv;
            }
            Map metadata = map;
            ErrorPayloadJSON errorPayloadJSON = endStreamResponseJSON3.getError();
            if ((errorPayloadJSON == null ? null : errorPayloadJSON.getCode()) == null) {
                Map map6 = metadata;
                if (map6 == null) {
                    map6 = MapsKt.emptyMap();
                }
                StreamResult.Complete<Buffer> complete4 = new StreamResult.Complete<Buffer>(Code.OK, null, map6, 2, null);
                return complete4;
            }
            Code code = Code.Companion.fromName(endStreamResponseJSON3.getError().getCode());
            ErrorDetailParser errorDetailParser = this.serializationStrategy.errorDetailParser();
            String string = endStreamResponseJSON3.getError().getMessage();
            List<ConnectErrorDetail> list = this.parseErrorDetails(endStreamResponseJSON3.getError());
            Map map7 = metadata;
            if (map7 == null) {
                map7 = MapsKt.emptyMap();
            }
            complete = new StreamResult.Complete<Buffer>(code, new ConnectError(code, errorDetailParser, string, null, list, map7, 8, null), null, 4, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ConnectError parseConnectUnaryError(Code code, Map<String, ? extends List<String>> headers, Buffer source) {
        ConnectError connectError;
        if (source == null) {
            return new ConnectError(code, this.serializationStrategy.errorDetailParser(), "empty error message from source", null, null, null, 56, null);
        }
        Closeable closeable = (Closeable)source;
        Throwable throwable = null;
        try {
            ErrorPayloadJSON errorPayloadJSON;
            block11: {
                Buffer bufferedSource = (Buffer)closeable;
                boolean bl = false;
                JsonAdapter adapter = this.moshi.adapter(ErrorPayloadJSON.class);
                String errorJSON = bufferedSource.readUtf8();
                try {
                    if ((ErrorPayloadJSON)adapter.fromJson(errorJSON) != null) break block11;
                    ConnectError connectError2 = new ConnectError(code, this.serializationStrategy.errorDetailParser(), errorJSON, null, null, null, 56, null);
                    return connectError2;
                }
                catch (Throwable e) {
                    ConnectError connectError3 = new ConnectError(Code.UNKNOWN, this.serializationStrategy.errorDetailParser(), errorJSON, null, null, null, 56, null);
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    return connectError3;
                }
            }
            ErrorPayloadJSON errorPayloadJSON2 = errorPayloadJSON;
            ErrorPayloadJSON errorPayloadJSON3 = errorPayloadJSON2;
            List<ConnectErrorDetail> errorDetails = this.parseErrorDetails(errorPayloadJSON3);
            connectError = new ConnectError(Code.Companion.fromName(errorPayloadJSON3.getCode()), this.serializationStrategy.errorDetailParser(), errorPayloadJSON3.getMessage(), null, errorDetails, headers, 8, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return connectError;
    }

    private final List<ConnectErrorDetail> parseErrorDetails(ErrorPayloadJSON jsonClass) {
        List errorDetails = new ArrayList();
        ErrorPayloadJSON errorPayloadJSON = jsonClass;
        List list = errorPayloadJSON == null ? null : errorPayloadJSON.getDetails();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        for (ErrorDetailPayloadJSON detail : list) {
            if (detail.getType() == null) continue;
            String payload = detail.getValue();
            if (payload == null) {
                errorDetails.add(new ConnectErrorDetail(detail.getType(), ByteString.EMPTY));
                continue;
            }
            errorDetails.add(new ConnectErrorDetail(detail.getType(), ByteString.Companion.encodeUtf8(payload)));
        }
        return errorDetails;
    }

    public static final /* synthetic */ ProtocolClientConfig access$getClientConfig$p(ConnectInterceptor $this) {
        return $this.clientConfig;
    }

    public static final /* synthetic */ ConnectError access$parseConnectUnaryError(ConnectInterceptor $this, Code code, Map headers, Buffer source) {
        return $this.parseConnectUnaryError(code, headers, source);
    }

    public static final /* synthetic */ void access$setResponseCompressionPool$p(ConnectInterceptor $this, CompressionPool compressionPool) {
        $this.responseCompressionPool = compressionPool;
    }

    public static final /* synthetic */ CompressionPool access$getResponseCompressionPool$p(ConnectInterceptor $this) {
        return $this.responseCompressionPool;
    }

    public static final /* synthetic */ StreamResult.Complete access$parseConnectEndStream(ConnectInterceptor $this, Buffer source) {
        return $this.parseConnectEndStream(source);
    }
}

