// Copyright 2022-2023 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package build.buf.connect.protocols

import build.buf.connect.Code
import build.buf.connect.ConnectErrorDetail
import okio.ByteString

/**
 * Represents the parsed data structure from the GRPC trailers.
 */
internal data class GRPCCompletion(
    // The status code of the response.
    val code: Code,
    // The numerical status parsed from trailers.
    val status: Int?,
    // Message data.
    val message: ByteString,
    // List of error details.
    val errorDetails: List<ConnectErrorDetail>
)
