/*
 * Decompiled with CFR 0.152.
 */
package build.buf.connect.http;

import build.buf.connect.Code;
import build.buf.connect.ConnectError;
import build.buf.connect.StreamResult;
import build.buf.connect.http.ConnectOkHttpClientKt;
import build.buf.connect.http.HTTPClientInterface;
import build.buf.connect.http.HTTPRequest;
import build.buf.connect.http.HTTPResponse;
import build.buf.connect.http.OkHttpStreamKt;
import build.buf.connect.http.Stream;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2(\u0010\u000b\u001a$\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J.\u0010\u0013\u001a\f\u0012\u0004\u0012\u00020\u00100\u0014j\u0002`\u00152\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00100\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lbuild/buf/connect/http/ConnectOkHttpClient;", "Lbuild/buf/connect/http/HTTPClientInterface;", "client", "Lokhttp3/OkHttpClient;", "(Lokhttp3/OkHttpClient;)V", "getClient", "()Lokhttp3/OkHttpClient;", "stream", "Lbuild/buf/connect/http/Stream;", "request", "Lbuild/buf/connect/http/HTTPRequest;", "onResult", "Lkotlin/Function2;", "Lbuild/buf/connect/StreamResult;", "Lokio/Buffer;", "Lkotlin/coroutines/Continuation;", "", "", "(Lbuild/buf/connect/http/HTTPRequest;Lkotlin/jvm/functions/Function2;)Lbuild/buf/connect/http/Stream;", "unary", "Lkotlin/Function0;", "Lbuild/buf/connect/http/Cancelable;", "Lkotlin/Function1;", "Lbuild/buf/connect/http/HTTPResponse;", "library"})
public final class ConnectOkHttpClient
implements HTTPClientInterface {
    @NotNull
    private final OkHttpClient client;

    public ConnectOkHttpClient(@NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
    }

    @NotNull
    public final OkHttpClient getClient() {
        return this.client;
    }

    @Override
    @NotNull
    public Function0<Unit> unary(@NotNull HTTPRequest request, @NotNull Function1<? super HTTPResponse, Unit> onResult) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onResult, (String)"onResult");
        Request.Builder builder = new Request.Builder();
        for (Map.Entry<String, List<String>> entry : request.getHeaders().entrySet()) {
            for (String values : entry.getValue()) {
                builder.addHeader(entry.getKey(), values);
            }
        }
        MediaType mediaType = MediaType.Companion.get(request.getContentType());
        byte[] byArray = request.getMessage();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        RequestBody requestBody = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (MediaType)mediaType, (byte[])byArray, (int)0, (int)0, (int)12, null);
        Request callRequest = builder.url(request.getUrl()).post(requestBody).build();
        Call newCall = this.client.newCall(callRequest);
        Function0 cancelable2 = (Function0)new Function0<Unit>(newCall){
            final /* synthetic */ Call $newCall;
            {
                this.$newCall = $newCall;
                super(0);
            }

            public final void invoke() {
                this.$newCall.cancel();
            }
        };
        try {
            newCall.enqueue(new Callback(onResult){
                final /* synthetic */ Function1<HTTPResponse, Unit> $onResult;
                {
                    this.$onResult = $onResult;
                }

                public void onFailure(@NotNull Call call, @NotNull IOException e) {
                    String string;
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    String string2 = e.getMessage();
                    if (string2 == null) {
                        string = null;
                    } else {
                        String string3 = string2.toLowerCase(Locale.ROOT);
                        string = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    }
                    Code code = Intrinsics.areEqual(string, (Object)"canceled") ? Code.CANCELED : Code.UNKNOWN;
                    this.$onResult.invoke((Object)new HTTPResponse(code, MapsKt.emptyMap(), (BufferedSource)new Buffer(), MapsKt.emptyMap(), new ConnectError(code, null, e.getMessage(), e, null, null, 50, null)));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onResponse(@NotNull Call call, @NotNull Response response) {
                    Buffer buffer;
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    ResponseBody responseBody = response.body();
                    if (responseBody == null) {
                        buffer = null;
                    } else {
                        BufferedSource bufferedSource = responseBody.source();
                        if (bufferedSource == null) {
                            buffer = null;
                        } else {
                            Closeable closeable = (Closeable)bufferedSource;
                            Throwable throwable = null;
                            try {
                                BufferedSource bufferedSource2 = (BufferedSource)closeable;
                                boolean bl = false;
                                Buffer buffer2 = new Buffer();
                                buffer2.writeAll((Source)bufferedSource2);
                                Buffer buffer3 = buffer2;
                                buffer = buffer3;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        }
                    }
                    Buffer responseBuffer = buffer;
                    Code code = Code.Companion.fromHTTPStatus(response.code());
                    Map<String, List<String>> map = ConnectOkHttpClientKt.toLowerCaseKeysMultiMap(response.headers());
                    Buffer buffer4 = responseBuffer;
                    if (buffer4 == null) {
                        buffer4 = new Buffer();
                    }
                    this.$onResult.invoke((Object)new HTTPResponse(code, map, (BufferedSource)buffer4, ConnectOkHttpClientKt.toLowerCaseKeysMultiMap(response.trailers()), null, 16, null));
                }
            });
        }
        catch (Throwable e) {
            onResult.invoke((Object)new HTTPResponse(Code.UNKNOWN, MapsKt.emptyMap(), (BufferedSource)new Buffer(), MapsKt.emptyMap(), new ConnectError(Code.UNKNOWN, null, e.getMessage(), e, null, null, 50, null)));
        }
        return cancelable2;
    }

    @Override
    @NotNull
    public Stream stream(@NotNull HTTPRequest request, @NotNull Function2<? super StreamResult<Buffer>, ? super Continuation<? super Unit>, ? extends Object> onResult) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onResult, (String)"onResult");
        return OkHttpStreamKt.initializeStream(this.client, request, onResult);
    }
}

