/*
 * Decompiled with CFR 0.152.
 */
package build.buf.connect.protocols;

import build.buf.connect.Code;
import build.buf.connect.ConnectError;
import build.buf.connect.ErrorDetailParser;
import build.buf.connect.Interceptor;
import build.buf.connect.ProtocolClientConfig;
import build.buf.connect.StreamFunction;
import build.buf.connect.StreamResult;
import build.buf.connect.UnaryFunction;
import build.buf.connect.compression.CompressionPool;
import build.buf.connect.compression.IdentityCompressionPool;
import build.buf.connect.http.HTTPRequest;
import build.buf.connect.http.HTTPResponse;
import build.buf.connect.protocolclientoptions.SerializationStrategy;
import build.buf.connect.protocols.Envelope;
import build.buf.connect.protocols.GRPCCompletion;
import build.buf.connect.protocols.GRPCCompletionParser;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J8\u0010\u000f\u001a\u0018\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00120\u0010j\u0002`\u0013*\u0018\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00120\u0010j\u0002`\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lbuild/buf/connect/protocols/GRPCInterceptor;", "Lbuild/buf/connect/Interceptor;", "clientConfig", "Lbuild/buf/connect/ProtocolClientConfig;", "(Lbuild/buf/connect/ProtocolClientConfig;)V", "completionParser", "Lbuild/buf/connect/protocols/GRPCCompletionParser;", "responseCompressionPool", "Lbuild/buf/connect/compression/CompressionPool;", "serializationStrategy", "Lbuild/buf/connect/protocolclientoptions/SerializationStrategy;", "streamFunction", "Lbuild/buf/connect/StreamFunction;", "unaryFunction", "Lbuild/buf/connect/UnaryFunction;", "withGRPCRequestHeaders", "", "", "", "Lbuild/buf/connect/Headers;", "library"})
public final class GRPCInterceptor
implements Interceptor {
    @NotNull
    private final ProtocolClientConfig clientConfig;
    @NotNull
    private final SerializationStrategy serializationStrategy;
    @NotNull
    private final GRPCCompletionParser completionParser;
    @Nullable
    private CompressionPool responseCompressionPool;

    public GRPCInterceptor(@NotNull ProtocolClientConfig clientConfig) {
        Intrinsics.checkNotNullParameter((Object)clientConfig, (String)"clientConfig");
        this.clientConfig = clientConfig;
        this.serializationStrategy = this.clientConfig.getSerializationStrategy();
        this.completionParser = new GRPCCompletionParser(this.serializationStrategy.errorDetailParser());
    }

    @Override
    @NotNull
    public UnaryFunction unaryFunction() {
        return new UnaryFunction((Function1<? super HTTPRequest, HTTPRequest>)((Function1)new Function1<HTTPRequest, HTTPRequest>(this){
            final /* synthetic */ GRPCInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final HTTPRequest invoke(@NotNull HTTPRequest request) {
                Buffer buffer;
                Closeable $this$filterTo$iv$iv;
                void $this$filter$iv;
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Map requestHeaders = new LinkedHashMap<K, V>();
                requestHeaders.putAll(request.getHeaders());
                Map<String, CompressionPool> map = GRPCInterceptor.access$getClientConfig$p(this.this$0).getCompressionPools();
                String string = "grpc-accept-encoding";
                Map map2 = requestHeaders;
                boolean $i$f$map = false;
                void var5_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void entry;
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry2 = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((String)entry.getKey());
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                iterator = $this$filterTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv$iv = iterator.next();
                    String name = (String)((Object)element$iv$iv);
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)name, (Object)IdentityCompressionPool.INSTANCE.name()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                collection = (List)destination$iv$iv;
                map2.put(string, collection);
                CompressionPool requestCompressionPool = GRPCInterceptor.access$getClientConfig$p(this.this$0).compressionPool(GRPCInterceptor.access$getClientConfig$p(this.this$0).getRequestCompressionName());
                $this$filterTo$iv$iv = (Closeable)new Buffer();
                Throwable throwable = null;
                try {
                    Buffer buffer2 = (Buffer)$this$filterTo$iv$iv;
                    boolean bl = false;
                    if (request.getMessage() != null) {
                        buffer2.write(request.getMessage());
                    }
                    buffer = buffer2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)$this$filterTo$iv$iv, (Throwable)throwable);
                }
                Buffer requestMessage = buffer;
                Buffer envelopedMessage = Envelope.Companion.pack(requestMessage, requestCompressionPool, GRPCInterceptor.access$getClientConfig$p(this.this$0).getCompressionMinBytes());
                return new HTTPRequest(request.getUrl(), Intrinsics.stringPlus((String)"application/grpc+", (Object)GRPCInterceptor.access$getSerializationStrategy$p(this.this$0).serializationName()), GRPCInterceptor.access$withGRPCRequestHeaders(this.this$0, requestHeaders), envelopedMessage.readByteArray());
            }
        }), (Function1<? super HTTPResponse, HTTPResponse>)((Function1)new Function1<HTTPResponse, HTTPResponse>(this){
            final /* synthetic */ GRPCInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final HTTPResponse invoke(@NotNull HTTPResponse response) {
                HTTPResponse hTTPResponse;
                GRPCCompletion completion;
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (response.getCode() != Code.OK) {
                    return response;
                }
                Map<String, List<String>> trailers = response.getTrailers();
                GRPCCompletion gRPCCompletion = completion = GRPCInterceptor.access$getCompletionParser$p(this.this$0).parse$library(trailers);
                Code code = gRPCCompletion == null ? null : gRPCCompletion.getCode();
                if (code == null) {
                    code = Code.UNKNOWN;
                }
                Code code2 = code;
                Map responseHeaders = MapsKt.toMutableMap(response.getHeaders());
                List list = (List)responseHeaders.get("grpc-encoding");
                CompressionPool compressionPool = GRPCInterceptor.access$getClientConfig$p(this.this$0).compressionPool(list == null ? null : (String)CollectionsKt.first((List)list));
                if (code2 == Code.OK) {
                    Buffer message = (Buffer)Envelope.Companion.unpackWithHeaderByte(response.getMessage().getBuffer(), compressionPool).component2();
                    hTTPResponse = new HTTPResponse(code2, responseHeaders, (BufferedSource)message, trailers, response.getError());
                } else {
                    String string;
                    Buffer result = new Buffer();
                    if (completion != null) {
                        ByteString errorMessage = completion.getMessage();
                        result.write(errorMessage);
                    }
                    BufferedSource bufferedSource = (BufferedSource)result;
                    ErrorDetailParser errorDetailParser = GRPCInterceptor.access$getSerializationStrategy$p(this.this$0).errorDetailParser();
                    GRPCCompletion gRPCCompletion2 = completion;
                    if (gRPCCompletion2 == null) {
                        string = null;
                    } else {
                        ByteString byteString = gRPCCompletion2.getMessage();
                        string = byteString == null ? null : byteString.utf8();
                    }
                    GRPCCompletion gRPCCompletion3 = completion;
                    List<E> list2 = gRPCCompletion3 == null ? null : gRPCCompletion3.getErrorDetails();
                    if (list2 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    hTTPResponse = new HTTPResponse(code2, responseHeaders, bufferedSource, trailers, new ConnectError(code2, errorDetailParser, string, null, list2, null, 40, null));
                }
                return hTTPResponse;
            }
        }));
    }

    @Override
    @NotNull
    public StreamFunction streamFunction() {
        return new StreamFunction((Function1<? super HTTPRequest, HTTPRequest>)((Function1)new Function1<HTTPRequest, HTTPRequest>(this){
            final /* synthetic */ GRPCInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final HTTPRequest invoke(@NotNull HTTPRequest request) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                return new HTTPRequest(request.getUrl(), Intrinsics.stringPlus((String)"application/grpc+", (Object)GRPCInterceptor.access$getSerializationStrategy$p(this.this$0).serializationName()), GRPCInterceptor.access$withGRPCRequestHeaders(this.this$0, request.getHeaders()), request.getMessage());
            }
        }), (Function1<? super Buffer, Buffer>)((Function1)new Function1<Buffer, Buffer>(this){
            final /* synthetic */ GRPCInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Buffer invoke(@NotNull Buffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                CompressionPool compressionPool = GRPCInterceptor.access$getClientConfig$p(this.this$0).compressionPool(GRPCInterceptor.access$getClientConfig$p(this.this$0).getRequestCompressionName());
                return Envelope.Companion.pack(buffer, compressionPool, GRPCInterceptor.access$getClientConfig$p(this.this$0).getCompressionMinBytes());
            }
        }), (Function1<? super StreamResult<Buffer>, ? extends StreamResult<Buffer>>)((Function1)new Function1<StreamResult<Buffer>, StreamResult<Buffer>>(this){
            final /* synthetic */ GRPCInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final StreamResult<Buffer> invoke(@NotNull StreamResult<Buffer> res) {
                Intrinsics.checkNotNullParameter(res, (String)"res");
                StreamResult streamResult2 = (StreamResult)res.fold((Function1)new Function1<StreamResult.Headers<Buffer>, StreamResult<Buffer>>(this.this$0){
                    final /* synthetic */ GRPCInterceptor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final StreamResult<Buffer> invoke(@NotNull StreamResult.Headers<Buffer> result) {
                        void $this$filterTo$iv$iv;
                        Intrinsics.checkNotNullParameter(result, (String)"result");
                        Map<String, List<String>> $this$filter$iv = result.getHeaders();
                        boolean $i$f$filter = false;
                        Map<String, List<String>> map = $this$filter$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>();
                        boolean $i$f$filterTo = false;
                        Iterator<Map.Entry<K, V>> iterator = $this$filterTo$iv$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<K, V> element$iv$iv;
                            Map.Entry<K, V> entry = element$iv$iv = iterator.next();
                            boolean bl = false;
                            if (!(!StringsKt.startsWith$default((String)((String)entry.getKey()), (String)"trailer", (boolean)false, (int)2, null))) continue;
                            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                        }
                        Map responseHeaders = MapsKt.toMutableMap((Map)destination$iv$iv);
                        List list = (List)responseHeaders.get("grpc-encoding");
                        GRPCInterceptor.access$setResponseCompressionPool$p(this.this$0, GRPCInterceptor.access$getClientConfig$p(this.this$0).compressionPool(list == null ? null : (String)CollectionsKt.first((List)list)));
                        return new StreamResult.Headers<Output>(responseHeaders);
                    }
                }, (Function1)new Function1<StreamResult.Message<Buffer>, StreamResult<Buffer>>(this.this$0){
                    final /* synthetic */ GRPCInterceptor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final StreamResult<Buffer> invoke(@NotNull StreamResult.Message<Buffer> result) {
                        Intrinsics.checkNotNullParameter(result, (String)"result");
                        Buffer unpackedMessage = (Buffer)Envelope.Companion.unpackWithHeaderByte(result.getMessage(), GRPCInterceptor.access$getResponseCompressionPool$p(this.this$0)).component2();
                        return new StreamResult.Message<Buffer>(unpackedMessage);
                    }
                }, (Function1)new Function1<StreamResult.Complete<Buffer>, StreamResult<Buffer>>(this.this$0){
                    final /* synthetic */ GRPCInterceptor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final StreamResult<Buffer> invoke(@NotNull StreamResult.Complete<Buffer> result) {
                        ConnectError connectError;
                        ConnectError connectError2;
                        List details;
                        GRPCCompletion completion;
                        Intrinsics.checkNotNullParameter(result, (String)"result");
                        Map<String, List<String>> streamTrailers = result.getTrailers();
                        GRPCCompletion gRPCCompletion = completion = GRPCInterceptor.access$getCompletionParser$p(this.this$0).parse$library(streamTrailers);
                        Code code = gRPCCompletion == null ? null : gRPCCompletion.getCode();
                        if (code == null) {
                            code = Code.UNKNOWN;
                        }
                        Code code2 = code;
                        GRPCCompletion gRPCCompletion2 = completion;
                        ByteString message = gRPCCompletion2 == null ? null : gRPCCompletion2.getMessage();
                        GRPCCompletion gRPCCompletion3 = completion;
                        List<E> list = details = gRPCCompletion3 == null ? null : gRPCCompletion3.getErrorDetails();
                        if (result.connectError() != null) {
                            connectError2 = result.connectError();
                        } else if (result.getError() != null || code2 != Code.OK) {
                            ErrorDetailParser errorDetailParser = GRPCInterceptor.access$getSerializationStrategy$p(this.this$0).errorDetailParser();
                            ByteString byteString = message;
                            String string = byteString == null ? null : byteString.utf8();
                            Throwable throwable = result.getError();
                            List list2 = details;
                            if (list2 == null) {
                                list2 = CollectionsKt.emptyList();
                            }
                            connectError2 = new ConnectError(code2, errorDetailParser, string, throwable, list2, streamTrailers);
                        } else {
                            connectError2 = null;
                        }
                        ConnectError connectError3 = connectError = connectError2;
                        Code code3 = connectError3 == null ? null : connectError3.getCode();
                        if (code3 == null) {
                            code3 = Code.OK;
                        }
                        return new StreamResult.Complete<Output>(code3, connectError, streamTrailers);
                    }
                });
                return streamResult2;
            }
        }));
    }

    private final Map<String, List<String>> withGRPCRequestHeaders(Map<String, ? extends List<String>> $this$withGRPCRequestHeaders) {
        Map headers = MapsKt.toMutableMap($this$withGRPCRequestHeaders);
        headers.put("x-user-agent", CollectionsKt.listOf((Object)"@bufbuild/connect-kotlin"));
        headers.put("te", CollectionsKt.listOf((Object)"trailers"));
        if (!Intrinsics.areEqual((Object)this.clientConfig.getRequestCompressionName(), (Object)IdentityCompressionPool.INSTANCE.name())) {
            headers.put("grpc-encoding", CollectionsKt.listOf((Object)this.clientConfig.getRequestCompressionName()));
        }
        return headers;
    }

    public static final /* synthetic */ ProtocolClientConfig access$getClientConfig$p(GRPCInterceptor $this) {
        return $this.clientConfig;
    }

    public static final /* synthetic */ SerializationStrategy access$getSerializationStrategy$p(GRPCInterceptor $this) {
        return $this.serializationStrategy;
    }

    public static final /* synthetic */ Map access$withGRPCRequestHeaders(GRPCInterceptor $this, Map $receiver) {
        return $this.withGRPCRequestHeaders($receiver);
    }

    public static final /* synthetic */ GRPCCompletionParser access$getCompletionParser$p(GRPCInterceptor $this) {
        return $this.completionParser;
    }

    public static final /* synthetic */ void access$setResponseCompressionPool$p(GRPCInterceptor $this, CompressionPool compressionPool) {
        $this.responseCompressionPool = compressionPool;
    }

    public static final /* synthetic */ CompressionPool access$getResponseCompressionPool$p(GRPCInterceptor $this) {
        return $this.responseCompressionPool;
    }
}

