// Copyright 2022-2023 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package build.buf.connect.protocolclientoptions

import build.buf.connect.ProtocolClientConfig
import build.buf.connect.protocols.ConnectInterceptor
/**
 * Enables the client to speak using the Connect protocol:
 * https://connect.build/docs
 *
 * Should not be specified alongside other options like `GRPCWebClientOption`, as only one protocol
 * should be used per `ProtocolClient`.
 */
class ConnectClientOption : ProtocolClientOption {
    override fun apply(config: ProtocolClientConfig): ProtocolClientConfig {
        val interceptors = config.interceptors.toMutableList()
        interceptors.add(0) { protocolClientParameters -> ConnectInterceptor(protocolClientParameters) }
        return config.clone(
            interceptors = interceptors
        )
    }
}
