// Copyright 2022-2023 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by Wire protocol buffer compiler, do not edit.
// Source: build.buf.connect.generated.v1.Status in status.proto
package build.buf.connect.generated.v1

import com.squareup.wire.AnyMessage
import com.squareup.wire.FieldEncoding
import com.squareup.wire.Message
import com.squareup.wire.ProtoAdapter
import com.squareup.wire.ProtoReader
import com.squareup.wire.ProtoWriter
import com.squareup.wire.ReverseProtoWriter
import com.squareup.wire.Syntax.PROTO_3
import com.squareup.wire.WireField
import com.squareup.wire.`internal`.immutableCopyOf
import com.squareup.wire.`internal`.redactElements
import com.squareup.wire.`internal`.sanitize
import kotlin.Any
import kotlin.AssertionError
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.DeprecationLevel
import kotlin.Int
import kotlin.Long
import kotlin.Nothing
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmField
import okio.ByteString

/**
 *  The `Status` type defines a logical error model that is suitable for
 *  different programming environments, including REST APIs and RPC APIs. It is
 *  used by \[gRPC\](https://github.com/grpc). Each `Status` message contains
 *  three pieces of data: error code, error message, and error details.
 *
 *  You can find out more about this error model and how to work with it in the
 *  \[API Design Guide\](https://cloud.google.com/apis/design/errors).
 */
public class Status(
  /**
   *  The status code, which should be an enum value of
   *  \[google.rpc.Code\]\[google.rpc.Code\].
   */
  @field:WireField(
    tag = 1,
    adapter = "com.squareup.wire.ProtoAdapter#INT32",
  )
  public val code: Int? = null,
  /**
   *  A developer-facing error message, which should be in English. Any
   *  user-facing error message should be localized and sent in the
   *  \[google.rpc.Status.details\]\[google.rpc.Status.details\] field, or localized
   *  by the client.
   */
  @field:WireField(
    tag = 2,
    adapter = "com.squareup.wire.ProtoAdapter#STRING",
  )
  public val message: String? = null,
  details: List<AnyMessage> = emptyList(),
  unknownFields: ByteString = ByteString.EMPTY,
) : Message<Status, Nothing>(ADAPTER, unknownFields) {
  /**
   *  A list of messages that carry the error details.  There is a common set of
   *  message types for APIs to use.
   */
  @field:WireField(
    tag = 3,
    adapter = "com.squareup.wire.AnyMessage#ADAPTER",
    label = WireField.Label.REPEATED,
  )
  public val details: List<AnyMessage> = immutableCopyOf("details", details)

  @Deprecated(
    message = "Shouldn't be used in Kotlin",
    level = DeprecationLevel.HIDDEN,
  )
  public override fun newBuilder(): Nothing = throw
      AssertionError("Builders are deprecated and only available in a javaInterop build; see https://square.github.io/wire/wire_compiler/#kotlin")

  public override fun equals(other: Any?): Boolean {
    if (other === this) return true
    if (other !is Status) return false
    if (unknownFields != other.unknownFields) return false
    if (code != other.code) return false
    if (message != other.message) return false
    if (details != other.details) return false
    return true
  }

  public override fun hashCode(): Int {
    var result = super.hashCode
    if (result == 0) {
      result = unknownFields.hashCode()
      result = result * 37 + (code?.hashCode() ?: 0)
      result = result * 37 + (message?.hashCode() ?: 0)
      result = result * 37 + details.hashCode()
      super.hashCode = result
    }
    return result
  }

  public override fun toString(): String {
    val result = mutableListOf<String>()
    if (code != null) result += """code=$code"""
    if (message != null) result += """message=${sanitize(message)}"""
    if (details.isNotEmpty()) result += """details=$details"""
    return result.joinToString(prefix = "Status{", separator = ", ", postfix = "}")
  }

  public fun copy(
    code: Int? = this.code,
    message: String? = this.message,
    details: List<AnyMessage> = this.details,
    unknownFields: ByteString = this.unknownFields,
  ): Status = Status(code, message, details, unknownFields)

  public companion object {
    @JvmField
    public val ADAPTER: ProtoAdapter<Status> = object : ProtoAdapter<Status>(
      FieldEncoding.LENGTH_DELIMITED, 
      Status::class,
      "type.googleapis.com/build.buf.connect.generated.v1.Status",
      PROTO_3, 
      null, 
      "status.proto"
    ) {
      public override fun encodedSize(`value`: Status): Int {
        var size = value.unknownFields.size
        size += ProtoAdapter.INT32.encodedSizeWithTag(1, value.code)
        size += ProtoAdapter.STRING.encodedSizeWithTag(2, value.message)
        size += AnyMessage.ADAPTER.asRepeated().encodedSizeWithTag(3, value.details)
        return size
      }

      public override fun encode(writer: ProtoWriter, `value`: Status): Unit {
        ProtoAdapter.INT32.encodeWithTag(writer, 1, value.code)
        ProtoAdapter.STRING.encodeWithTag(writer, 2, value.message)
        AnyMessage.ADAPTER.asRepeated().encodeWithTag(writer, 3, value.details)
        writer.writeBytes(value.unknownFields)
      }

      public override fun encode(writer: ReverseProtoWriter, `value`: Status): Unit {
        writer.writeBytes(value.unknownFields)
        AnyMessage.ADAPTER.asRepeated().encodeWithTag(writer, 3, value.details)
        ProtoAdapter.STRING.encodeWithTag(writer, 2, value.message)
        ProtoAdapter.INT32.encodeWithTag(writer, 1, value.code)
      }

      public override fun decode(reader: ProtoReader): Status {
        var code: Int? = null
        var message: String? = null
        val details = mutableListOf<AnyMessage>()
        val unknownFields = reader.forEachTag { tag ->
          when (tag) {
            1 -> code = ProtoAdapter.INT32.decode(reader)
            2 -> message = ProtoAdapter.STRING.decode(reader)
            3 -> details.add(AnyMessage.ADAPTER.decode(reader))
            else -> reader.readUnknownField(tag)
          }
        }
        return Status(
          code = code,
          message = message,
          details = details,
          unknownFields = unknownFields
        )
      }

      public override fun redact(`value`: Status): Status = value.copy(
        details = value.details.redactElements(AnyMessage.ADAPTER),
        unknownFields = ByteString.EMPTY
      )
    }

    private const val serialVersionUID: Long = 0L
  }
}
