/*
 * Decompiled with CFR 0.152.
 */
package bleep.packaging;

import bleep.logging.Formatter$;
import bleep.logging.LoggerFn;
import bleep.logging.LoggerFn$;
import bleep.logging.TypedLogger;
import bleep.model.BleepVersion$;
import bloop.config.Config;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import scala.util.Using$;
import sourcecode.Enclosing$;
import sourcecode.File$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public final class PackagePlugin$
implements Serializable {
    private static final FileTime epochTime;
    public static final PackagePlugin$ MODULE$;

    private PackagePlugin$() {
    }

    static {
        MODULE$ = new PackagePlugin$();
        epochTime = FileTime.fromMillis(0L);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PackagePlugin$.class);
    }

    public List<Path> apply(TypedLogger<BoxedUnit> logger, List<Config.Project> projects) {
        return projects.map((Function1 & Serializable)project -> {
            Path writtenJar = this.jar(logger, (Config.Project)project);
            LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)logger.withContext(Text$.MODULE$.apply((Object)writtenJar, "writtenJar"), Formatter$.MODULE$.PathFormatter())), this::apply$$anonfun$1$$anonfun$1, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(19), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-tasks/src/scala/bleep/packaging/PackagePlugin.scala"), Enclosing$.MODULE$.apply("bleep.packaging.PackagePlugin.apply"));
            return writtenJar;
        });
    }

    public Manifest buildManifest(String projectName, Option<String> mainClass) {
        Manifest manifest = new Manifest();
        Attributes attrs = manifest.getMainAttributes();
        attrs.put(Attributes.Name.IMPLEMENTATION_TITLE, projectName);
        attrs.put(new Attributes.Name("Created-By"), new StringBuilder(6).append("Bleep/").append(BleepVersion$.MODULE$.current()).toString());
        mainClass.foreach((Function1 & Serializable)cls -> attrs.put(Attributes.Name.MAIN_CLASS, cls));
        return manifest;
    }

    public Path jar(TypedLogger<BoxedUnit> logger, Config.Project project) {
        List dirs = ((List)project.resources().getOrElse(this::$anonfun$1)).$colon$colon((Object)project.classesDir());
        Path jarFile = project.out().resolve(new StringBuilder(4).append(project.name()).append(".jar").toString());
        if (Files.deleteIfExists(jarFile)) {
            LoggerFn.Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)logger.withContext(Text$.MODULE$.apply((Object)jarFile, "jarFile"), Formatter$.MODULE$.PathFormatter())), this::jar$$anonfun$1, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(36), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-tasks/src/scala/bleep/packaging/PackagePlugin.scala"), Enclosing$.MODULE$.apply("bleep.packaging.PackagePlugin.jar"));
        }
        Manifest manifest = this.buildManifest(project.name(), (Option<String>)project.platform().flatMap((Function1 & Serializable)_$1 -> _$1.mainClass()));
        Using$.MODULE$.resource((Object)new JarOutputStream(Files.newOutputStream(jarFile, StandardOpenOption.CREATE_NEW), manifest), (Function1)(JProcedure1 & Serializable)os -> dirs.filter((Function1 & Serializable)_$2 -> Files.exists(_$2, new LinkOption[0])).foreach((Function1)(JProcedure1 & Serializable)resourceDir -> this.addFilesToJar((Path)resourceDir, (JarOutputStream)os)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        return jarFile;
    }

    private void addFilesToJar(Path root, JarOutputStream os) {
        Files.walk(root, new FileVisitOption[0]).forEachOrdered(file -> {
            String name;
            String string = name = root.relativize((Path)file).toString();
            String string2 = "bloop-internal-classes";
            if ((string == null ? string2 != null : !string.equals(string2)) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(name))) {
                this.addJarEntry(os, (Path)file, name, Files.isDirectory(file, LinkOption.NOFOLLOW_LINKS));
                return;
            }
        });
    }

    private void addJarEntry(JarOutputStream os, Path file, String name, boolean directory) {
        ZipEntry entry = new ZipEntry(directory ? new StringBuilder(1).append(name).append("/").toString() : name);
        os.putNextEntry(entry);
        entry.setCreationTime(epochTime);
        entry.setLastModifiedTime(epochTime);
        entry.setLastAccessTime(epochTime);
        if (!directory) {
            entry.setMethod(8);
            entry.setSize(Files.size(file));
            Using$.MODULE$.resource((Object)Files.newInputStream(file, new OpenOption[0]), (Function1 & Serializable)is -> is.transferTo(os), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        }
    }

    private final Text apply$$anonfun$1$$anonfun$1() {
        return Text$.MODULE$.apply((Object)"built jar file", "\"built jar file\"");
    }

    private final Nil$ $anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private final Text jar$$anonfun$1() {
        return Text$.MODULE$.apply((Object)"Deleted existing file", "\"Deleted existing file\"");
    }
}

