/*
 * Decompiled with CFR 0.152.
 */
package nosbt.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Properties;
import nosbt.Using;
import nosbt.Using$;
import nosbt.io.TranslatedException;
import nosbt.io.TranslatedIOException;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.control.Exception$;

public final class IO$
implements Serializable {
    public static final IO$ MODULE$ = new IO$();

    private IO$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IO$.class);
    }

    public void createDirectory(File dir) {
        for (int tryCount = 0; !dir.exists() && !dir.mkdirs() && tryCount < 100; ++tryCount) {
        }
        if (!dir.isDirectory()) {
            throw dir.exists() ? package$.MODULE$.error(new StringBuilder(37).append(this.failBase$1(dir)).append(": file exists and is not a directory.").toString()) : package$.MODULE$.error(this.failBase$1(dir));
        }
    }

    public <T> T translate(Function0<String> msg, Function0<T> f) {
        Object object;
        try {
            object = f.apply();
        }
        catch (IOException e) {
            throw new TranslatedIOException(new StringBuilder(0).append((String)msg.apply()).append(e.toString()).toString(), e);
        }
        catch (Exception e) {
            throw new TranslatedException(new StringBuilder(0).append((String)msg.apply()).append(e.toString()).toString(), e);
        }
        return (T)object;
    }

    public void delete(Iterable<File> files) {
        files.foreach((Function1)(JProcedure1 & Serializable)file -> this.delete((File)file));
    }

    public void delete(File file) {
        this.translate((Function0<String>)((Function0 & Serializable)() -> this.delete$$anonfun$2(file)), (Function0)((JFunction0.mcV.sp & Serializable)() -> this.delete$$anonfun$3(file)));
    }

    public File[] listFiles(FileFilter filter, File dir) {
        return this.wrapNull(dir.listFiles(filter));
    }

    public File[] listFiles(File dir, FileFilter filter) {
        return this.wrapNull(dir.listFiles(filter));
    }

    public File[] listFiles(File dir) {
        return this.wrapNull(dir.listFiles());
    }

    public File[] wrapNull(File[] a) {
        return a == null ? new File[]{} : a;
    }

    public Option<String> relativize(File base, File file) {
        None$ none$;
        Path basePath = (base.isAbsolute() ? base : base.getCanonicalFile()).toPath();
        Path filePath = (file.isAbsolute() ? file : file.getCanonicalFile()).toPath();
        if (filePath.startsWith(basePath) || filePath.normalize().startsWith(basePath.normalize())) {
            Option relativePath = Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{IllegalArgumentException.class})).opt(() -> this.$anonfun$1(basePath, filePath));
            none$ = relativePath.map((Function1 & Serializable)_$1 -> _$1.toString());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void load(Properties properties, File from) {
        if (from.exists()) {
            ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(from, (JProcedure1 & Serializable)input -> properties.load((InputStream)input));
        }
    }

    private final String failBase$1(File dir$1) {
        return new StringBuilder(27).append("Could not create directory ").append(dir$1).toString();
    }

    private final String delete$$anonfun$2(File file$1) {
        return new StringBuilder(22).append("Error deleting file ").append(file$1).append(": ").toString();
    }

    private final void delete$$anonfun$3(File file$2) {
        boolean deleted = file$2.delete();
        if (!deleted && file$2.isDirectory()) {
            this.delete((Iterable<File>)Predef$.MODULE$.wrapRefArray((Object[])this.listFiles(file$2)));
            file$2.delete();
        }
    }

    private final Path $anonfun$1(Path basePath$1, Path filePath$1) {
        return basePath$1.relativize(filePath$1);
    }
}

