/*
 * Decompiled with CFR 0.152.
 */
package bleep.packaging;

import bleep.internal.FileUtils$;
import bleep.logging.Formatter$;
import bleep.logging.LoggerFn;
import bleep.logging.LoggerFn$;
import bleep.logging.TypedLogger;
import bleep.packaging.DistPlugin;
import bleep.packaging.DistPlugin$Program$;
import bleep.packaging.PackagePlugin$;
import bloop.config.Config;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import sourcecode.Enclosing$;
import sourcecode.File$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public final class DistPlugin$
implements Serializable {
    private static final Set<PosixFilePermission> standardPermissions;
    public static final DistPlugin$Program$ Program;
    public static final DistPlugin$ MODULE$;

    private DistPlugin$() {
    }

    static {
        MODULE$ = new DistPlugin$();
        standardPermissions = PosixFilePermissions.fromString("rwxrwxr-x");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DistPlugin$.class);
    }

    public void dist(TypedLogger<BoxedUnit> logger, List<Config.Project> projects, String project2, List<DistPlugin.Program> programs, Option<Path> distPath) {
        Map dependencyLookup = projects.map((Function1 & Serializable)p -> {
            Path path = (Path)Predef$.MODULE$.ArrowAssoc((Object)p.classesDir());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)path, p);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        projects.find((Function1 & Serializable)_$1 -> {
            String string = _$1.name();
            String string2 = project2;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).foreach((Function1)(JProcedure1 & Serializable)project -> {
            Path distDir = (Path)distPath.map((Function1 & Serializable)_$2 -> _$2.resolve(project.name())).getOrElse(() -> this.$anonfun$3(project));
            Files.createDirectories(distDir, new FileAttribute[0]);
            Path lib = distDir.resolve("lib");
            FileUtils$.MODULE$.deleteDirectory(lib);
            Files.createDirectories(lib, new FileAttribute[0]);
            List jarFiles = (List)this.dependenciesFor(logger, (Config.Project)project, (Map<Path, Config.Project>)dependencyLookup).distinct();
            jarFiles.foreach((Function1 & Serializable)src -> Files.copy(src, lib.resolve(src.getFileName()), StandardCopyOption.COPY_ATTRIBUTES));
            if (programs.nonEmpty()) {
                Path bin = distDir.resolve("bin");
                FileUtils$.MODULE$.deleteDirectory(bin);
                Files.createDirectories(bin, new FileAttribute[0]);
                this.writeScripts(bin, "", programs);
            }
            LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)logger.withContext(Text$.MODULE$.apply((Object)distDir, "distDir"), Formatter$.MODULE$.PathFormatter())), this::dist$$anonfun$2$$anonfun$2, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(38), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-tasks/src/main/scala/bleep/packaging/DistPlugin.scala"), Enclosing$.MODULE$.apply("bleep.packaging.DistPlugin.dist"));
        });
    }

    public List<Path> dependenciesFor(TypedLogger<BoxedUnit> logger, Config.Project project, Map<Path, Config.Project> lookup) {
        Tuple2 tuple2 = project.classpath().partition((Function1 & Serializable)_$3 -> Files.isDirectory(_$3, new LinkOption[0]));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List dirs = (List)tuple2._1();
        List jars = (List)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)dirs, (Object)jars);
        List dirs2 = (List)tuple22._1();
        List jars2 = (List)tuple22._2();
        Path jar = PackagePlugin$.MODULE$.jar(logger, project);
        return dirs2.flatMap((Function1 & Serializable)dir -> lookup.get(dir).toList()).flatMap((Function1 & Serializable)dependantProject -> this.dependenciesFor(logger, (Config.Project)dependantProject, lookup)).$colon$colon$colon(jars2).$colon$colon((Object)jar);
    }

    public void writeScripts(Path to, String jvmOptions, List<DistPlugin.Program> programs) {
        programs.foreach((Function1 & Serializable)program -> {
            Path bashFile = to.resolve(program.name());
            Files.writeString(bashFile, (CharSequence)this.distShScript(jvmOptions, program.mainClass()), StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);
            Files.setPosixFilePermissions(bashFile, standardPermissions);
            return Files.writeString(to.resolve(new StringBuilder(4).append(program.name()).append(".bat").toString()), (CharSequence)this.distBatScript(jvmOptions, program.mainClass()), StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);
        });
    }

    private String distShScript(String jvmOptions, String mainClass) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|#!/bin/sh\n       |\n       |PRG=\"$0\"\n       |\n       |# need this for relative symlinks\n       |while [ -h \"$PRG\" ] ; do\n       |  ls=`ls -ld \"$PRG\"`\n       |  link=`expr \"$ls\" : '.*-> \\(.*\\)$'`\n       |  if expr \"$link\" : '/.*' > /dev/null; then\n       |    PRG=\"$link\"\n       |  else\n       |    PRG=\"`dirname \"$PRG\"`/$link\"\n       |  fi\n       |done\n       |\n       |APP_BASE=`dirname \"$PRG\"`/..\n       |\n       |# make it fully qualified\n       |APP_BASE=`cd \"$APP_BASE\" && pwd`\n       |\n       |if [ \"Z${APP_HOME}\" = \"Z\" ]; then\n       |  APP_HOME=$APP_BASE\n       |fi\n       |\n       |APP_CLASSPATH=\"$APP_BASE/lib/*\"\n       |JAVA_OPTS=\"$JAVA_OPTS @@jvmOptions@@\"\n       |\n       |exec java $JAVA_OPTS -cp \"$APP_CLASSPATH\" -Dapp.base=\"$APP_BASE\" -Dapp.home=\"$APP_HOME\" @@mainClass@@ $@\n       |")).replace("@@jvmOptions@@", jvmOptions).replace("@@mainClass@@", mainClass);
    }

    private String distBatScript(String jvmOptions, String mainClass) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|@echo off\n       |set APP_HOME=%%~dp0..\n       |set APP_CLASSPATH=%%APP_HOME%%\\lib\\*\n       |set JAVA_OPTS=%%JAVA_OPTS%% @@jvmOptions@@\n       |set CMD_LINE_ARGS=\n       |:setArgs\n       |if %1\"==\"\" goto doneSetArgs\n       |  set CMD_LINE_ARGS=\"%%CMD_LINE_ARGS%% %1\"\n       |  shift\n       |  goto setArgs\n       |:doneSetArgs\n       |\n       |java %%JAVA_OPTS%% -cp \"%%APP_CLASSPATH%%\" -Dapp.base=\"%%APP_HOME%%\" -Dapp.home=\"%%APP_HOME%%\"  @@mainClass@@ \"%%CMD_LINE_ARGS%%\"\n       |")).replace("@@jvmOptions@@", jvmOptions).replace("@@mainClass@@", mainClass);
    }

    private final Path $anonfun$3(Config.Project project$3) {
        return project$3.out().resolve("dist");
    }

    private final Text dist$$anonfun$2$$anonfun$2() {
        return Text$.MODULE$.apply((Object)"dist complete", "\"dist complete\"");
    }
}

