/*
 * Decompiled with CFR 0.152.
 */
package nosbt.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Properties;
import nosbt.Using;
import nosbt.Using$;
import nosbt.io.TranslatedException;
import nosbt.io.TranslatedIOException;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.control.Exception$;

public final class IO$ {
    public static final IO$ MODULE$ = new IO$();

    public void createDirectory(File dir) {
        for (int tryCount = 0; !dir.exists() && !dir.mkdirs() && tryCount < 100; ++tryCount) {
        }
        if (!dir.isDirectory()) {
            if (dir.exists()) {
                throw package$.MODULE$.error(new StringBuilder(37).append(IO$.failBase$1(dir)).append(": file exists and is not a directory.").toString());
            }
            throw package$.MODULE$.error(IO$.failBase$1(dir));
        }
    }

    public <T> T translate(Function0<String> msg, Function0<T> f) {
        Object object;
        try {
            object = f.apply();
        }
        catch (IOException e) {
            throw new TranslatedIOException(new StringBuilder(0).append((String)msg.apply()).append(e.toString()).toString(), e);
        }
        catch (Exception e) {
            throw new TranslatedException(new StringBuilder(0).append((String)msg.apply()).append(e.toString()).toString(), e);
        }
        return (T)object;
    }

    public void delete(Iterable<File> files) {
        files.foreach((Function1 & Serializable)file -> {
            IO$.MODULE$.delete(file);
            return BoxedUnit.UNIT;
        });
    }

    public void delete(File file) {
        this.translate((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Error deleting file ").append(file).append(": ").toString(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            block0: {
                boolean deleted = file.delete();
                if (deleted || !file.isDirectory()) break block0;
                MODULE$.delete((Iterable<File>)Predef$.MODULE$.wrapRefArray((Object[])MODULE$.listFiles(file)));
                file.delete();
            }
        });
    }

    public File[] listFiles(FileFilter filter, File dir) {
        return this.wrapNull(dir.listFiles(filter));
    }

    public File[] listFiles(File dir, FileFilter filter) {
        return this.wrapNull(dir.listFiles(filter));
    }

    public File[] listFiles(File dir) {
        return this.wrapNull(dir.listFiles());
    }

    public File[] wrapNull(File[] a) {
        return a == null ? new File[]{} : a;
    }

    public Option<String> relativize(File base, File file) {
        None$ none$;
        Path basePath = (base.isAbsolute() ? base : base.getCanonicalFile()).toPath();
        Path filePath = (file.isAbsolute() ? file : file.getCanonicalFile()).toPath();
        if (filePath.startsWith(basePath) || filePath.normalize().startsWith(basePath.normalize())) {
            Option relativePath = Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{IllegalArgumentException.class})).opt((Function0 & Serializable)() -> basePath.relativize(filePath));
            none$ = relativePath.map((Function1 & Serializable)x$1 -> ((Object)x$1).toString());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void load(Properties properties, File from) {
        block0: {
            if (!from.exists()) break block0;
            ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(from, (Function1 & Serializable)input -> {
                properties.load(input);
                return BoxedUnit.UNIT;
            });
        }
    }

    private static final String failBase$1(File dir$1) {
        return new StringBuilder(27).append("Could not create directory ").append(dir$1).toString();
    }

    private IO$() {
    }
}

