/*
 * Decompiled with CFR 0.152.
 */
package bleep.packaging;

import bleep.internal.FileUtils$;
import bleep.logging.Formatter$;
import bleep.logging.LoggerFn;
import bleep.logging.LoggerFn$;
import bleep.logging.TypedLogger;
import bleep.packaging.DistPlugin;
import bleep.packaging.PackagePlugin$;
import bloop.config.Config;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sourcecode.Enclosing;
import sourcecode.File;
import sourcecode.Line;
import sourcecode.Text;

public final class DistPlugin$ {
    public static DistPlugin$ MODULE$;
    private final Set<PosixFilePermission> standardPermissions;
    private volatile byte bitmap$init$0;

    static {
        new DistPlugin$();
    }

    private Set<PosixFilePermission> standardPermissions() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/bleep/bleep/bleep-tasks/src/main/scala/bleep/packaging/DistPlugin.scala: 12");
        }
        return this.standardPermissions;
    }

    public void dist(TypedLogger<BoxedUnit> logger, List<Config.Project> projects, String project2, List<DistPlugin.Program> programs, Option<Path> distPath) {
        Map dependencyLookup = ((TraversableOnce)projects.map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.classesDir()), p), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        projects.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DistPlugin$.$anonfun$dist$2(project2, x$1))).foreach((Function1 & Serializable & scala.Serializable)project -> {
            DistPlugin$.$anonfun$dist$3(distPath, logger, dependencyLookup, programs, project);
            return BoxedUnit.UNIT;
        });
    }

    public List<Path> dependenciesFor(TypedLogger<BoxedUnit> logger, Config.Project project, Map<Path, Config.Project> lookup) {
        Path jar;
        Tuple2 tuple2 = project.classpath().partition((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DistPlugin$.$anonfun$dependenciesFor$1(x$3)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List dirs = (List)tuple2._1();
        List jars = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)dirs, (Object)jars);
        Tuple2 tuple23 = tuple22;
        List dirs2 = (List)tuple23._1();
        List jars2 = (List)tuple23._2();
        Path path = jar = PackagePlugin$.MODULE$.jar(logger, project);
        List list = jars2;
        return ((List)((List)dirs2.flatMap((Function1 & Serializable & scala.Serializable)dir -> lookup.get(dir).toList(), List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)dependantProject -> MODULE$.dependenciesFor(logger, (Config.Project)dependantProject, lookup), List$.MODULE$.canBuildFrom())).$colon$colon$colon(list).$colon$colon((Object)path);
    }

    public void writeScripts(Path to, String jvmOptions, List<DistPlugin.Program> programs) {
        programs.foreach((Function1 & Serializable & scala.Serializable)program -> {
            Path bashFile = to.resolve(program.name());
            Files.writeString(bashFile, (CharSequence)MODULE$.distShScript(jvmOptions, program.mainClass()), StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);
            Files.setPosixFilePermissions(bashFile, MODULE$.standardPermissions());
            return Files.writeString(to.resolve(new StringBuilder(4).append(program.name()).append(".bat").toString()), (CharSequence)MODULE$.distBatScript(jvmOptions, program.mainClass()), StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);
        });
    }

    private String distShScript(String jvmOptions, String mainClass) {
        return new StringOps(Predef$.MODULE$.augmentString("|#!/bin/sh\n       |\n       |PRG=\"$0\"\n       |\n       |# need this for relative symlinks\n       |while [ -h \"$PRG\" ] ; do\n       |  ls=`ls -ld \"$PRG\"`\n       |  link=`expr \"$ls\" : '.*-> \\(.*\\)$'`\n       |  if expr \"$link\" : '/.*' > /dev/null; then\n       |    PRG=\"$link\"\n       |  else\n       |    PRG=\"`dirname \"$PRG\"`/$link\"\n       |  fi\n       |done\n       |\n       |APP_BASE=`dirname \"$PRG\"`/..\n       |\n       |# make it fully qualified\n       |APP_BASE=`cd \"$APP_BASE\" && pwd`\n       |\n       |if [ \"Z${APP_HOME}\" = \"Z\" ]; then\n       |  APP_HOME=$APP_BASE\n       |fi\n       |\n       |APP_CLASSPATH=\"$APP_BASE/lib/*\"\n       |JAVA_OPTS=\"$JAVA_OPTS @@jvmOptions@@\"\n       |\n       |exec java $JAVA_OPTS -cp \"$APP_CLASSPATH\" -Dapp.base=\"$APP_BASE\" -Dapp.home=\"$APP_HOME\" @@mainClass@@ $@\n       |")).stripMargin().replace("@@jvmOptions@@", jvmOptions).replace("@@mainClass@@", mainClass);
    }

    private String distBatScript(String jvmOptions, String mainClass) {
        return new StringOps(Predef$.MODULE$.augmentString("|@echo off\n       |set APP_HOME=%%~dp0..\n       |set APP_CLASSPATH=%%APP_HOME%%\\lib\\*\n       |set JAVA_OPTS=%%JAVA_OPTS%% @@jvmOptions@@\n       |set CMD_LINE_ARGS=\n       |:setArgs\n       |if %1\"==\"\" goto doneSetArgs\n       |  set CMD_LINE_ARGS=\"%%CMD_LINE_ARGS%% %1\"\n       |  shift\n       |  goto setArgs\n       |:doneSetArgs\n       |\n       |java %%JAVA_OPTS%% -cp \"%%APP_CLASSPATH%%\" -Dapp.base=\"%%APP_HOME%%\" -Dapp.home=\"%%APP_HOME%%\"  @@mainClass@@ \"%%CMD_LINE_ARGS%%\"\n       |")).stripMargin().replace("@@jvmOptions@@", jvmOptions).replace("@@mainClass@@", mainClass);
    }

    public static final /* synthetic */ boolean $anonfun$dist$2(String project$1, Config.Project x$1) {
        String string = x$1.name();
        String string2 = project$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$dist$3(Option distPath$1, TypedLogger logger$1, Map dependencyLookup$1, List programs$1, Config.Project project) {
        Path distDir = (Path)distPath$1.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.resolve(project.name())).getOrElse((Function0 & Serializable & scala.Serializable)() -> project.out().resolve("dist"));
        Files.createDirectories(distDir, new FileAttribute[0]);
        Path lib = distDir.resolve("lib");
        FileUtils$.MODULE$.deleteDirectory(lib);
        Files.createDirectories(lib, new FileAttribute[0]);
        List jarFiles = (List)MODULE$.dependenciesFor((TypedLogger<BoxedUnit>)logger$1, project, (Map<Path, Config.Project>)dependencyLookup$1).distinct();
        jarFiles.foreach((Function1 & Serializable & scala.Serializable)src -> Files.copy(src, lib.resolve(src.getFileName()), StandardCopyOption.COPY_ATTRIBUTES));
        if (programs$1.nonEmpty()) {
            Path bin = distDir.resolve("bin");
            FileUtils$.MODULE$.deleteDirectory(bin);
            Files.createDirectories(bin, new FileAttribute[0]);
            MODULE$.writeScripts(bin, "", (List<DistPlugin.Program>)programs$1);
        }
        LoggerFn.Syntax$.MODULE$.info$extension0(LoggerFn$.MODULE$.Syntax((LoggerFn)logger$1.withContext(new Text((Object)distDir, "distDir"), Formatter$.MODULE$.PathFormatter())), (Function0 & Serializable & scala.Serializable)() -> new Text((Object)"dist complete", "\"dist complete\""), Formatter$.MODULE$.StringFormatter(), new Line(38), new File("/home/runner/work/bleep/bleep/bleep-tasks/src/main/scala/bleep/packaging/DistPlugin.scala"), new Enclosing("bleep.packaging.DistPlugin.dist"));
    }

    public static final /* synthetic */ boolean $anonfun$dependenciesFor$1(Path x$3) {
        return Files.isDirectory(x$3, new LinkOption[0]);
    }

    private DistPlugin$() {
        MODULE$ = this;
        this.standardPermissions = PosixFilePermissions.fromString("rwxrwxr-x");
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }
}

