/*
 * Decompiled with CFR 0.152.
 */
package com.jsuereth.pgp.cli;

import com.jsuereth.pgp.PublicKey;
import com.jsuereth.pgp.PublicKeyRing;
import com.jsuereth.pgp.Signature;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class Display$ {
    public static final Display$ MODULE$ = new Display$();

    public String printFileHeader(File f) {
        String path = f.getAbsolutePath();
        String line = package$.MODULE$.Stream().continually((Function0)(JFunction0.mcC.sp & Serializable)() -> '-').take(path.length()).mkString("");
        return new StringBuilder(2).append(path).append("\n").append(line).append("\n").toString();
    }

    public String printKey(PublicKey k) {
        String hexkey = StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)k.keyID())}))), 8);
        String strength = new StringBuilder(1).append(k.algorithmName()).append("@").append(Integer.toString(k.bitStrength())).toString();
        String head = k.nested().isMasterKey() ? "pub" : "sub";
        String date = new SimpleDateFormat("yyyy-MM-dd").format(k.nested().getCreationTime());
        String userStrings = k.userIDs().isEmpty() ? "" : k.userIDs().map((Function1 & Serializable)x$1 -> new StringBuilder(21).append("uid\t                \t").append((String)x$1).toString()).mkString("", "\n", "\n");
        return new StringBuilder(4).append(head).append("\t").append(strength).append("/").append(hexkey).append("\t").append(date).append("\n").append(userStrings).toString();
    }

    public String printSignature(Signature s) {
        String hexKey = StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)s.keyID())}))), 8);
        String notationsString = s.notations().isEmpty() ? "" : s.notations().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String l = (String)tuple2._1();
            String r = (String)tuple2._2();
            String string = new StringBuilder(9).append("note\t\t\t\t").append(l).append("=").append(r).toString();
            return string;
        }).mkString("\n", "\n", "");
        String header = "sig";
        String user = (String)s.signerUserID().getOrElse((Function0 & Serializable)() -> "");
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s\t%s@%s\t%s%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{header, hexKey, s.signatureTypeString(), user, notationsString}));
    }

    public String printSignatures(PublicKey k) {
        return k.signatures().map((Function1 & Serializable)s -> MODULE$.printSignature((Signature)s)).mkString("\n");
    }

    public String printKeyWithSignatures(PublicKey r) {
        return new StringBuilder(1).append(this.printKey(r)).append(this.printSignatures(r)).append("\n").toString();
    }

    public String printRingWithSignatures(PublicKeyRing r2) {
        return r2.publicKeys().map((Function1 & Serializable)r -> MODULE$.printKeyWithSignatures((PublicKey)r)).mkString("\n");
    }

    public String printRing(PublicKeyRing r) {
        return r.publicKeys().map((Function1 & Serializable)k -> MODULE$.printKey((PublicKey)k)).mkString("\n");
    }

    private Display$() {
    }
}

