/*
 * Decompiled with CFR 0.152.
 */
package com.rallyhealth.sbt.versioning;

import bleep.logging.Formatter$;
import bleep.logging.LoggerFn;
import bleep.logging.LoggerFn$;
import bleep.logging.TypedLogger;
import com.rallyhealth.sbt.versioning.BufferingProcessLogger;
import com.rallyhealth.sbt.versioning.GitFetcher;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.process.Process;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import sourcecode.Enclosing;
import sourcecode.File;
import sourcecode.Line;
import sourcecode.Text;

public final class GitFetcher$ {
    public static final GitFetcher$ MODULE$ = new GitFetcher$();
    private static final Regex tagResultRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(" \\* \\[new tag\\][ ]+([\\S]+).*"));

    private Regex tagResultRegex() {
        return tagResultRegex;
    }

    public Seq<GitFetcher.FetchResult> fetchRemotes(Duration timeout, TypedLogger<BoxedUnit> logger) {
        Seq seq;
        int processResult;
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int n = processResult = Process$.MODULE$.apply("git remote").$bang((ProcessLogger)outputLogger);
        switch (n) {
            case 0: {
                LoggerFn.Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(logger), (Function0 & Serializable)() -> new Text((Object)"Fetching remote sources...", "\"Fetching remote sources...\""), Formatter$.MODULE$.StringFormatter(), new Line(30), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("com.rallyhealth.sbt.versioning.GitFetcher.fetchRemotes"));
                Buffer<String> remotes = outputLogger.stdout();
                Buffer tagsToFetch = (Buffer)remotes.filter((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)remotes.contains(elem)));
                if (tagsToFetch.nonEmpty()) {
                    LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(logger), (Function0 & Serializable)() -> new Text((Object)new StringBuilder(20).append("Fetching tags from: ").append(tagsToFetch.mkString(", ")).toString(), "\"Fetching tags from: \" + tagsToFetch.mkString(\", \")"), Formatter$.MODULE$.StringFormatter(), new Line(35), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("com.rallyhealth.sbt.versioning.GitFetcher.fetchRemotes"));
                    seq = (Seq)tagsToFetch.toSeq().flatMap((Function1 & Serializable)remote -> MODULE$.fetchTagsFromRemote((String)remote, timeout, logger));
                    break;
                }
                LoggerFn.Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(logger), (Function0 & Serializable)() -> new Text((Object)"No tags to fetch", "\"No tags to fetch\""), Formatter$.MODULE$.StringFormatter(), new Line(38), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("com.rallyhealth.sbt.versioning.GitFetcher.fetchRemotes"));
                seq = (Seq)package$.MODULE$.Seq().empty();
                break;
            }
            default: {
                LoggerFn.Syntax$.MODULE$.error$extension(LoggerFn$.MODULE$.Syntax(logger), (Function0 & Serializable)() -> new Text((Object)new StringBuilder(59).append("Fetching remotes failed enumerating remotes [git exitCode=").append(n).append("]").toString(), "s\"Fetching remotes failed enumerating remotes [git exitCode=$exitCode]\""), Formatter$.MODULE$.StringFormatter(), new Line(43), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("com.rallyhealth.sbt.versioning.GitFetcher.fetchRemotes"));
                seq = (Seq)package$.MODULE$.Seq().empty();
                break;
            }
        }
        return seq;
    }

    private Seq<GitFetcher.FetchResult> fetchTagsFromRemote(String remote, Duration timeout, TypedLogger<BoxedUnit> logger) {
        Seq seq;
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        Process process = Process$.MODULE$.apply(new StringBuilder(17).append("git fetch ").append(remote).append(" --tags").toString()).run((ProcessLogger)outputLogger);
        Future resultFuture = Future$.MODULE$.apply((Function0 & Serializable)() -> {
            Seq seq;
            if (process.exitValue() == 0) {
                seq = (Seq)((IterableOps)outputLogger.stderr().toSeq().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("[new tag]")))).flatMap((Function1 & Serializable)x0$1 -> {
                    None$ none$;
                    Option option;
                    String string = x0$1;
                    if (string != null && !(option = MODULE$.tagResultRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                        String tag = (String)((LinearSeqOps)option.get()).apply(0);
                        LoggerFn.Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)logger), (Function0 & Serializable)() -> new Text((Object)new StringBuilder(25).append("Fetched from remote=").append(remote).append(" tag=").append(tag).toString(), "s\"Fetched from remote=$remote tag=$tag\""), Formatter$.MODULE$.StringFormatter(), new Line(56), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("com.rallyhealth.sbt.versioning.GitFetcher.fetchTagsFromRemote resultFuture"));
                        none$ = new Some((Object)new GitFetcher.FetchResult(remote, tag));
                    } else {
                        LoggerFn.Syntax$.MODULE$.warn$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)logger), (Function0 & Serializable)() -> new Text((Object)new StringBuilder(37).append("Unable to parse git result=").append(string).append(", skipping").toString(), "s\"Unable to parse git result=$line, skipping\""), Formatter$.MODULE$.StringFormatter(), new Line(59), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("com.rallyhealth.sbt.versioning.GitFetcher.fetchTagsFromRemote resultFuture"));
                        none$ = None$.MODULE$;
                    }
                    return none$;
                });
            } else {
                LoggerFn.Syntax$.MODULE$.error$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)logger), (Function0 & Serializable)() -> new Text((Object)new StringBuilder(39).append("Fetching remote=").append(remote).append(" failed [git exitCode=").append(process.exitValue()).append("]").toString(), "s\"Fetching remote=$remote failed [git exitCode=${process.exitValue()}]\""), Formatter$.MODULE$.StringFormatter(), new Line(63), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("com.rallyhealth.sbt.versioning.GitFetcher.fetchTagsFromRemote resultFuture"));
                seq = (Seq)package$.MODULE$.Seq().empty();
            }
            return seq;
        }, ExecutionContext.Implicits$.MODULE$.global());
        try {
            Seq result = (Seq)Await$.MODULE$.result((Awaitable)resultFuture, timeout);
            LoggerFn.Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(logger), (Function0 & Serializable)() -> new Text((Object)new StringBuilder(21).append("Successfully fetched ").append(remote).toString(), "s\"Successfully fetched $remote\""), Formatter$.MODULE$.StringFormatter(), new Line(70), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("com.rallyhealth.sbt.versioning.GitFetcher.fetchTagsFromRemote"));
            seq = result;
        }
        catch (Throwable throwable) {
            Option option;
            Seq seq2;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof TimeoutException) {
                process.destroy();
                LoggerFn.Syntax$.MODULE$.error$extension(LoggerFn$.MODULE$.Syntax(logger), (Function0 & Serializable)() -> new Text((Object)new StringBuilder(42).append("Fetching remote=").append(remote).append(" timed out [git exitCode=").append(process.exitValue()).append("]").toString(), "s\"Fetching remote=$remote timed out [git exitCode=${process.exitValue()}]\""), Formatter$.MODULE$.StringFormatter(), new Line(75), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("com.rallyhealth.sbt.versioning.GitFetcher.fetchTagsFromRemote"));
                seq2 = (Seq)package$.MODULE$.Seq().empty();
            } else if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable exc = (Throwable)option.get();
                LoggerFn.Syntax$.MODULE$.error$extension(LoggerFn$.MODULE$.Syntax(logger), (Function0 & Serializable)() -> new Text((Object)new StringBuilder(39).append("Fetching remote=").append(remote).append(" failed [git exitCode=").append(process.exitValue()).append("]").toString(), "s\"Fetching remote=$remote failed [git exitCode=${process.exitValue()}]\""), exc, Formatter$.MODULE$.StringFormatter(), new Line(78), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("com.rallyhealth.sbt.versioning.GitFetcher.fetchTagsFromRemote"));
                seq2 = (Seq)package$.MODULE$.Seq().empty();
            } else {
                throw throwable;
            }
            seq = seq2;
        }
        return seq;
    }

    private GitFetcher$() {
    }
}

