/*
 * Decompiled with CFR 0.152.
 */
package com.jsuereth.sbtpgp;

import bleep.logging.TypedLogger;
import com.jsuereth.pgp.cli.PgpCommandContext;
import com.jsuereth.sbtpgp.PgpSigner;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005m3A\u0001C\u0005\u0001!!A1\u0004\u0001B\u0001B\u0003%A\u0004\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0011\u0015\u0019\u0004\u0001\"\u00015\u0011\u001dA\u0004A1A\u0005\u0002eBa!\u0010\u0001!\u0002\u0013Q\u0004\"\u0002 \u0001\t\u0003y\u0004\u0002C-\u0001\u0011\u000b\u0007I\u0011\t.\u0003+\t{WO\\2z\u0007\u0006\u001cH\u000f\\3QOB\u001c\u0016n\u001a8fe*\u0011!bC\u0001\u0007g\n$\bo\u001a9\u000b\u00051i\u0011\u0001\u00036tk\u0016\u0014X\r\u001e5\u000b\u00039\t1aY8n\u0007\u0001\u00192\u0001A\t\u0018!\t\u0011R#D\u0001\u0014\u0015\u0005!\u0012!B:dC2\f\u0017B\u0001\f\u0014\u0005\u0019\te.\u001f*fMB\u0011\u0001$G\u0007\u0002\u0013%\u0011!$\u0003\u0002\n!\u001e\u00048+[4oKJ\f1a\u0019;y!\ti\"%D\u0001\u001f\u0015\ty\u0002%A\u0002dY&T!!I\u0006\u0002\u0007A<\u0007/\u0003\u0002$=\t\t\u0002k\u001a9D_6l\u0017M\u001c3D_:$X\r\u001f;\u0002\r=\u0004HoS3z!\r\u0011b\u0005K\u0005\u0003OM\u0011aa\u00149uS>t\u0007CA\u00151\u001d\tQc\u0006\u0005\u0002,'5\tAF\u0003\u0002.\u001f\u00051AH]8pizJ!aL\n\u0002\rA\u0013X\rZ3g\u0013\t\t$G\u0001\u0004TiJLgn\u001a\u0006\u0003_M\ta\u0001P5oSRtDcA\u001b7oA\u0011\u0001\u0004\u0001\u0005\u00067\r\u0001\r\u0001\b\u0005\u0006I\r\u0001\r!J\u0001\u0006W\u0016L\u0018\nZ\u000b\u0002uA\u0011!cO\u0005\u0003yM\u0011A\u0001T8oO\u000611.Z=JI\u0002\nAa]5h]R\u0019\u0001I\u0012%\u0011\u0007I\t5)\u0003\u0002C'\t)\u0011I\u001d:bsB\u0011!\u0003R\u0005\u0003\u000bN\u0011AAQ=uK\")qI\u0002a\u0001\u0001\u000691m\u001c8uK:$\b\"B%\u0007\u0001\u0004Q\u0015A\u00027pO\u001e,'\u000f\u0005\u0002L-:\u0011Aj\u0015\b\u0003\u001bBs!a\u000b(\n\u0003=\u000bQA\u00197fKBL!!\u0015*\u0002\u000f1|wmZ5oO*\tq*\u0003\u0002U+\u00069\u0001/Y2lC\u001e,'BA)S\u0013\t9\u0006L\u0001\u0004M_\u001e<WM\u001d\u0006\u0003)V\u000b\u0001\u0002^8TiJLgnZ\u000b\u0002Q\u0001")
public class BouncyCastlePgpSigner
implements PgpSigner {
    private String toString;
    private final PgpCommandContext ctx;
    private final long keyId;
    private volatile boolean bitmap$0;

    public long keyId() {
        return this.keyId;
    }

    @Override
    public byte[] sign(byte[] content, TypedLogger<BoxedUnit> logger) {
        return (byte[])this.ctx.withPassphrase(this.keyId(), (Function1 & Serializable)pw -> $this.ctx.secretKeyRing().apply(this.keyId()).sign(content, (char[])pw));
    }

    private String toString$lzycompute() {
        BouncyCastlePgpSigner bouncyCastlePgpSigner = this;
        synchronized (bouncyCastlePgpSigner) {
            if (!this.bitmap$0) {
                this.toString = new StringBuilder(8).append("BC-PGP(").append(this.ctx.secretKeyRing()).append(")").toString();
                this.bitmap$0 = true;
            }
        }
        return this.toString;
    }

    public String toString() {
        return !this.bitmap$0 ? this.toString$lzycompute() : this.toString;
    }

    public BouncyCastlePgpSigner(PgpCommandContext ctx, Option<String> optKey) {
        long l;
        this.ctx = ctx;
        Option<String> option = optKey;
        if (option instanceof Some) {
            Some some = (Some)option;
            String x = (String)some.value();
            l = new BigInteger(x, 16).longValue();
        } else {
            l = ctx.secretKeyRing().secretKey().keyID();
        }
        this.keyId = l;
    }
}

