/*
 * Decompiled with CFR 0.152.
 */
package com.jsuereth.pgp;

import com.jsuereth.pgp.KeyNotFoundException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.Security;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005M4qAC\u0006\u0011\u0002\u0007\u0005!\u0003C\u0003\u001a\u0001\u0011\u0005!\u0004C\u0003\u001f\u0001\u0019\u0005q\u0004C\u00033\u0001\u0011\u00151\u0007C\u0003:\u0001\u0011\u0015!\bC\u0003H\u0001\u0019\u0005\u0001\nC\u0003N\u0001\u0011\u0015a\nC\u0003S\u0001\u0011\u00151\u000bC\u0003W\u0001\u0011Eq\u000bC\u0003n\u0001\u0011EaNA\u0007Qk\nd\u0017nY&fs2K7.\u001a\u0006\u0003\u00195\t1\u0001]4q\u0015\tqq\"\u0001\u0005kgV,'/\u001a;i\u0015\u0005\u0001\u0012aA2p[\u000e\u00011C\u0001\u0001\u0014!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fM\u00061A%\u001b8ji\u0012\"\u0012a\u0007\t\u0003)qI!!H\u000b\u0003\tUs\u0017\u000e^\u0001\u0014m\u0016\u0014\u0018NZ=NKN\u001c\u0018mZ3TiJ,\u0017-\u001c\u000b\u0004A\rj\u0003C\u0001\u000b\"\u0013\t\u0011SCA\u0004C_>dW-\u00198\t\u000b\u0011\u0012\u0001\u0019A\u0013\u0002\u000b%t\u0007/\u001e;\u0011\u0005\u0019ZS\"A\u0014\u000b\u0005!J\u0013AA5p\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0006]\t\u0001\raL\u0001\u0007_V$\b/\u001e;\u0011\u0005\u0019\u0002\u0014BA\u0019(\u00051yU\u000f\u001e9viN#(/Z1n\u0003E1XM]5gs6+7o]1hK\u001aKG.\u001a\u000b\u0004AQB\u0004\"\u0002\u0013\u0004\u0001\u0004)\u0004C\u0001\u00147\u0013\t9tE\u0001\u0003GS2,\u0007\"\u0002\u0018\u0004\u0001\u0004)\u0014a\u0005<fe&4\u00170T3tg\u0006<Wm\u0015;sS:<GCA\u001eG!\ta4I\u0004\u0002>\u0003B\u0011a(F\u0007\u0002\u007f)\u0011\u0001)E\u0001\u0007yI|w\u000e\u001e \n\u0005\t+\u0012A\u0002)sK\u0012,g-\u0003\u0002E\u000b\n11\u000b\u001e:j]\u001eT!AQ\u000b\t\u000b\u0011\"\u0001\u0019A\u001e\u0002-Y,'/\u001b4z'&<g.\u0019;ve\u0016\u001cFO]3b[N$2\u0001I%L\u0011\u0015QU\u00011\u0001&\u0003\ri7o\u001a\u0005\u0006\u0019\u0016\u0001\r!J\u0001\ng&<g.\u0019;ve\u0016\f1C^3sS\u001aL8+[4oCR,(/\u001a$jY\u0016$2\u0001I(R\u0011\u0015\u0001f\u00011\u00016\u0003\r\u0011\u0018m\u001e\u0005\u0006\u0019\u001a\u0001\r!N\u0001\u0016m\u0016\u0014\u0018NZ=TS\u001et\u0017\r^;sKN#(/\u001b8h)\r\u0001C+\u0016\u0005\u0006\u0015\u001e\u0001\ra\u000f\u0005\u0006\u0019\u001e\u0001\raO\u0001\u001am\u0016\u0014\u0018NZ=NKN\u001c\u0018mZ3TiJ,\u0017-\u001c%fYB,'\u000fF\u0002YW2$\"\u0001I-\t\u000biC\u0001\u0019A.\u0002\r\u001d,GoS3z!\u0011!BLX1\n\u0005u+\"!\u0003$v]\u000e$\u0018n\u001c82!\t!r,\u0003\u0002a+\t!Aj\u001c8h!\t\u0011\u0017.D\u0001d\u0015\t!W-A\u0004pa\u0016t\u0007o\u001a9\u000b\u0005\u0019<\u0017\u0001\u00042pk:\u001c\u0017pY1ti2,'\"\u00015\u0002\u0007=\u0014x-\u0003\u0002kG\na\u0001k\u0012)Qk\nd\u0017nY&fs\")A\u0005\u0003a\u0001K!)a\u0006\u0003a\u0001_\u0005ab/\u001a:jMf\u001c\u0016n\u001a8biV\u0014Xm\u0015;sK\u0006l7\u000fS3ma\u0016\u0014HcA8reR\u0011\u0001\u0005\u001d\u0005\u00065&\u0001\ra\u0017\u0005\u0006\u0015&\u0001\r!\n\u0005\u0006\u0019&\u0001\r!\n")
public interface PublicKeyLike {
    public boolean verifyMessageStream(InputStream var1, OutputStream var2);

    public static /* synthetic */ boolean verifyMessageFile$(PublicKeyLike $this, File input, File output) {
        return $this.verifyMessageFile(input, output);
    }

    default public boolean verifyMessageFile(File input, File output) {
        boolean bl;
        FileInputStream in = new FileInputStream(input);
        FileOutputStream out = new FileOutputStream(output);
        try {
            bl = this.verifyMessageStream(in, out);
        }
        finally {
            in.close();
            out.close();
        }
        return bl;
    }

    public static /* synthetic */ String verifyMessageString$(PublicKeyLike $this, String input) {
        return $this.verifyMessageString(input);
    }

    default public String verifyMessageString(String input) {
        ByteArrayInputStream in = new ByteArrayInputStream(input.getBytes());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Predef$.MODULE$.assert(this.verifyMessageStream(in, out));
        return out.toString(Charset.defaultCharset().name());
    }

    public boolean verifySignatureStreams(InputStream var1, InputStream var2);

    public static /* synthetic */ boolean verifySignatureFile$(PublicKeyLike $this, File raw, File signature) {
        return $this.verifySignatureFile(raw, signature);
    }

    default public boolean verifySignatureFile(File raw, File signature) {
        boolean bl;
        FileInputStream in = new FileInputStream(raw);
        FileInputStream in2 = new FileInputStream(signature);
        try {
            bl = this.verifySignatureStreams(in, in2);
        }
        finally {
            in.close();
            in2.close();
        }
        return bl;
    }

    public static /* synthetic */ boolean verifySignatureString$(PublicKeyLike $this, String msg, String signature) {
        return $this.verifySignatureString(msg, signature);
    }

    default public boolean verifySignatureString(String msg, String signature) {
        boolean bl;
        ByteArrayInputStream in = new ByteArrayInputStream(msg.getBytes());
        ByteArrayInputStream in2 = new ByteArrayInputStream(signature.getBytes());
        try {
            bl = this.verifySignatureStreams(in, in2);
        }
        finally {
            in.close();
            in2.close();
        }
        return bl;
    }

    public static /* synthetic */ boolean verifyMessageStreamHelper$(PublicKeyLike $this, InputStream input, OutputStream output, Function1 getKey) {
        return $this.verifyMessageStreamHelper(input, output, (Function1<Object, PGPPublicKey>)getKey);
    }

    default public boolean verifyMessageStreamHelper(InputStream input, OutputStream output, Function1<Object, PGPPublicKey> getKey) {
        InputStream in = PGPUtil.getDecoderStream((InputStream)input);
        JcaPGPObjectFactory tmp = new JcaPGPObjectFactory(in);
        PGPCompressedData c1 = (PGPCompressedData)tmp.nextObject();
        JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(c1.getDataStream());
        PGPOnePassSignatureList sigList = (PGPOnePassSignatureList)pgpFact.nextObject();
        PGPOnePassSignature ops = sigList.get(0);
        PGPLiteralData p2 = (PGPLiteralData)pgpFact.nextObject();
        InputStream dIn = p2.getInputStream();
        PGPPublicKey key = (PGPPublicKey)getKey.apply((Object)BoxesRunTime.boxToLong((long)ops.getKeyID()));
        ops.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider(Security.getProvider("BC")), key);
        int ch = dIn.read();
        while (ch >= 0) {
            ops.update((byte)ch);
            output.write(ch);
            ch = dIn.read();
        }
        PGPSignatureList p3 = (PGPSignatureList)pgpFact.nextObject();
        return ops.verify(p3.get(0));
    }

    public static /* synthetic */ boolean verifySignatureStreamsHelper$(PublicKeyLike $this, InputStream msg, InputStream signature, Function1 getKey) {
        return $this.verifySignatureStreamsHelper(msg, signature, (Function1<Object, PGPPublicKey>)getKey);
    }

    default public boolean verifySignatureStreamsHelper(InputStream msg, InputStream signature, Function1<Object, PGPPublicKey> getKey) {
        Tuple2 tuple2;
        InputStream in = PGPUtil.getDecoderStream((InputStream)signature);
        JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(in);
        Object o = pgpFact.nextObject();
        Object object = o;
        if (object instanceof PGPCompressedData) {
            PGPCompressedData pGPCompressedData = (PGPCompressedData)object;
            tuple2 = new Tuple2((Object)((PGPSignatureList)pgpFact.nextObject()), (Object)new JcaPGPObjectFactory(pGPCompressedData.getDataStream()));
        } else if (object instanceof PGPSignatureList) {
            PGPSignatureList pGPSignatureList = (PGPSignatureList)object;
            tuple2 = new Tuple2((Object)pGPSignatureList, (Object)pgpFact);
        } else {
            throw package$.MODULE$.error(new StringBuilder(13).append("Unexepected: ").append(object).toString());
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        PGPSignatureList sigList = (PGPSignatureList)tuple22._1();
        JcaPGPObjectFactory pgpFact2 = (JcaPGPObjectFactory)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)sigList, (Object)pgpFact2);
        Tuple2 tuple24 = tuple23;
        PGPSignatureList sigList2 = (PGPSignatureList)tuple24._1();
        JcaPGPObjectFactory pgpFact3 = (JcaPGPObjectFactory)tuple24._2();
        BufferedInputStream dIn = new BufferedInputStream(msg);
        PGPSignature sig = sigList2.get(0);
        PGPPublicKey pGPPublicKey = (PGPPublicKey)getKey.apply((Object)BoxesRunTime.boxToLong((long)sig.getKeyID()));
        if (pGPPublicKey == null) {
            throw new KeyNotFoundException(sig.getKeyID());
        }
        sig.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider(Security.getProvider("BC")), pGPPublicKey);
        int ch = dIn.read();
        while (ch >= 0) {
            sig.update((byte)ch);
            ch = dIn.read();
        }
        dIn.close();
        boolean bl = sig.verify();
        return bl;
    }

    public static void $init$(PublicKeyLike $this) {
    }
}

