/*
 * Decompiled with CFR 0.152.
 */
package com.rallyhealth.sbt.versioning;

import com.rallyhealth.sbt.versioning.BufferingProcessLogger;
import com.rallyhealth.sbt.versioning.GitBranchState;
import com.rallyhealth.sbt.versioning.GitBranchStateNoCommits$;
import com.rallyhealth.sbt.versioning.GitBranchStateNoReleases;
import com.rallyhealth.sbt.versioning.GitBranchStateOneReleaseHead;
import com.rallyhealth.sbt.versioning.GitBranchStateOneReleaseNotHead;
import com.rallyhealth.sbt.versioning.GitBranchStateTwoReleases;
import com.rallyhealth.sbt.versioning.GitCommit;
import com.rallyhealth.sbt.versioning.GitCommit$;
import com.rallyhealth.sbt.versioning.GitCommitWithCount;
import com.rallyhealth.sbt.versioning.GitDriver;
import com.rallyhealth.sbt.versioning.GitWorkingState;
import com.rallyhealth.sbt.versioning.ReleaseVersion;
import com.rallyhealth.sbt.versioning.ReleaseVersion$;
import com.rallyhealth.sbt.versioning.SemanticVersion;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\n\u0015\u0001uA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\u0006c\u0001!\tA\r\u0004\u0005k\u0001!a\u0007\u0003\u0005D\u0007\t\u0005\t\u0015!\u0003E\u0011\u0015\t4\u0001\"\u0001M\u0011\u0015\u0001\u0006\u0001\"\u0005R\u0011\u0015)\u0006\u0001\"\u0003W\u0011\u001dA\u0006A1A\u0005BeCa!\u0018\u0001!\u0002\u0013Q\u0006\"\u00020\u0001\t\u0003z\u0006\"B2\u0001\t\u0003\"\u0007\"B7\u0001\t\u0013q\u0007\"B8\u0001\t\u0013\u0001\b\"B<\u0001\t\u0013A\b\"B>\u0001\t\u0013a\b\"B?\u0001\t\u0013q\bBB@\u0001\t\u0013\t\t\u0001C\u0005\u0002\u0014\u0001\t\n\u0011\"\u0003\u0002\u0016\tiq)\u001b;Ee&4XM]%na2T!!\u0006\f\u0002\u0015Y,'o]5p]&twM\u0003\u0002\u00181\u0005\u00191O\u0019;\u000b\u0005eQ\u0012a\u0003:bY2L\b.Z1mi\"T\u0011aG\u0001\u0004G>l7\u0001A\n\u0004\u0001y!\u0003CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g\r\u0005\u0002&M5\tA#\u0003\u0002()\tIq)\u001b;Ee&4XM]\u0001\u0004I&\u0014\bC\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\tIwNC\u0001/\u0003\u0011Q\u0017M^1\n\u0005AZ#\u0001\u0002$jY\u0016\fa\u0001P5oSRtDCA\u001a5!\t)\u0003\u0001C\u0003)\u0005\u0001\u0007\u0011F\u0001\u0007HSR,\u0005pY3qi&|gn\u0005\u0002\u0004oA\u0011\u0001\b\u0011\b\u0003syr!AO\u001f\u000e\u0003mR!\u0001\u0010\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0013BA !\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0011\"\u0003\u0013\u0015C8-\u001a9uS>t'BA !\u0003\ri7o\u001a\t\u0003\u000b&s!AR$\u0011\u0005i\u0002\u0013B\u0001%!\u0003\u0019\u0001&/\u001a3fM&\u0011!j\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!\u0003CCA'P!\tq5!D\u0001\u0001\u0011\u0015\u0019U\u00011\u0001E\u0003=I7oR5u\u0007>l\u0007/\u0019;jE2,W#\u0001*\u0011\u0005}\u0019\u0016B\u0001+!\u0005\u001d\u0011un\u001c7fC:\f\u0011\"[:HSR\u0014V\r]8\u0015\u0005I;\u0006\"\u0002\u0015\b\u0001\u0004I\u0013a\u00032sC:\u001c\u0007n\u0015;bi\u0016,\u0012A\u0017\t\u0003KmK!\u0001\u0018\u000b\u0003\u001d\u001dKGO\u0011:b]\u000eD7\u000b^1uK\u0006a!M]1oG\"\u001cF/\u0019;fA\u0005aqo\u001c:lS:<7\u000b^1uKV\t\u0001\r\u0005\u0002&C&\u0011!\r\u0006\u0002\u0010\u000f&$xk\u001c:lS:<7\u000b^1uK\u0006qq-\u001a;D_6l\u0017\u000e^\"pk:$HCA3i!\tyb-\u0003\u0002hA\t\u0019\u0011J\u001c;\t\u000b%\\\u0001\u0019\u00016\u0002\t!\f7\u000f\u001b\t\u0004?-$\u0015B\u00017!\u0005\u0019y\u0005\u000f^5p]\u0006Iq-\u001b;Ce\u0006t7\r[\u000b\u0002\t\u0006iq-\u001b;G_J,\u0015m\u00195SK\u001a,\u0012!\u001d\t\u0004qI$\u0018BA:C\u0005\r\u0019V-\u001d\t\u0003KUL!A\u001e\u000b\u0003\u0013\u001dKGoQ8n[&$\u0018AB4ji2{w\r\u0006\u0002rs\")!P\u0004a\u0001\t\u0006I\u0011M]4v[\u0016tGo]\u0001\u000bG\",7m[\"mK\u0006tG#\u0001*\u00023\u0019Lg\u000eZ!cEJ,g/[1uK\u0012D\u0015m\u001d5MK:<G\u000f\u001b\u000b\u0002K\u0006Q!/\u001e8D_6l\u0017M\u001c3\u0015\r\u0005\r\u00111BA\b!\u0019y\u0012QA3\u0002\n%\u0019\u0011q\u0001\u0011\u0003\rQ+\b\u000f\\33!\rA$\u000f\u0012\u0005\u0007\u0003\u001b\t\u0002\u0019\u0001#\u0002\u0007\rlG\r\u0003\u0005\u0002\u0012E\u0001\n\u00111\u0001S\u00039!\bN]8x\u0013\u001atuN\u001c.fe>\fAC];o\u0007>lW.\u00198eI\u0011,g-Y;mi\u0012\u0012TCAA\fU\r\u0011\u0016\u0011D\u0016\u0003\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0005\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002*\u0005}!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class GitDriverImpl
implements GitDriver {
    private final File dir;
    private final GitBranchState branchState;
    private volatile boolean bitmap$init$0;

    @Override
    public SemanticVersion calcCurrentVersion(boolean ignoreDirty) {
        return GitDriver.calcCurrentVersion$(this, ignoreDirty);
    }

    public boolean isGitCompatible() {
        boolean bl;
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int exitCode = Process$.MODULE$.apply("git --version", this.dir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang((ProcessLogger)outputLogger);
        Regex gitSemver = new StringOps(Predef$.MODULE$.augmentString("git version (\\d+)\\.(\\d+)\\.(\\d+).*")).r();
        int n = exitCode;
        switch (n) {
            case 0: {
                String gitVersion;
                String string = gitVersion = outputLogger.stdout().mkString("").trim().toLowerCase();
                Option option = gitSemver.unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
                    String major = (String)((LinearSeqOptimized)option.get()).apply(0);
                    bl = new StringOps(Predef$.MODULE$.augmentString(major)).toInt() > 1;
                    break;
                }
                throw new GitException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(84).append("Version output was not of the form 'git version x.y.z'\n              |version was '").append(gitVersion).append("'").toString())).stripMargin());
            }
            default: {
                throw new GitException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("Unexpected git exit status: ").append(n).append("\n             |stderr:\n             |").append(outputLogger.stderr().mkString("\n")).append("\n             |stdout:\n             |").append(outputLogger.stdout().mkString("\n")).toString())).stripMargin());
            }
        }
        return bl;
    }

    private boolean isGitRepo(File dir) {
        boolean bl;
        int exitCode;
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int n = exitCode = Process$.MODULE$.apply("git rev-parse --is-inside-work-tree", dir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang((ProcessLogger)outputLogger);
        switch (n) {
            case 0: {
                String string = outputLogger.stdout().mkString("").trim().toLowerCase();
                String string2 = "true";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 128: {
                bl = false;
                break;
            }
            default: {
                throw new GitException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("Unexpected git exit status: ").append(n).append("\n             |stderr:\n             |").append(outputLogger.stderr().mkString("\n")).append("\n             |stdout:\n             |").append(outputLogger.stdout().mkString("\n")).toString())).stripMargin());
            }
        }
        return bl;
    }

    @Override
    public GitBranchState branchState() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitDriver.scala: 124");
        }
        return this.branchState;
    }

    @Override
    public GitWorkingState workingState() {
        return new GitWorkingState(!this.checkClean());
    }

    @Override
    public int getCommitCount(Option<String> hash) {
        Seq output;
        String limitStr = (String)hash.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append("^").append((String)x$1).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(new StringBuilder(41).append("git rev-list --first-parent --count HEAD ").append(limitStr).toString().trim(), this.runCommand$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq seq = output = (Seq)tuple2._2();
        Seq output2 = seq;
        return new StringOps(Predef$.MODULE$.augmentString(output2.mkString("").trim())).toInt();
    }

    private String gitBranch() {
        Seq res;
        String cmd = "git rev-parse --abbrev-ref HEAD";
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(cmd, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = tuple2._1$mcI$sp();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        Tuple2 tuple23 = tuple22;
        int exitCode2 = tuple23._1$mcI$sp();
        Seq output2 = (Seq)tuple23._2();
        int n = exitCode2;
        switch (n) {
            case 0: {
                res = (Seq)output2.map((Function1 & Serializable & scala.Serializable)line -> line, Seq$.MODULE$.canBuildFrom());
                break;
            }
            case 128: {
                throw new IllegalStateException("Error 128: a git cmd was run in a dir that is not under git vcs or git rev-parse failed to run.");
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return (String)res.head();
    }

    private Seq<GitCommit> gitForEachRef() {
        int abbreviatedHashLength;
        Predef$.MODULE$.require(this.isGitRepo(this.dir), (Function0 & Serializable & scala.Serializable)() -> "Must be in a git repository");
        Predef$.MODULE$.require(this.isGitCompatible(), (Function0 & Serializable & scala.Serializable)() -> "Must be git version 2.X.X or greater");
        String cmd = new StringBuilder(54).append("git for-each-ref --sort=-v:refname refs/tags --merged=").append(this.gitBranch()).toString();
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(cmd, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = tuple2._1$mcI$sp();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        Tuple2 tuple23 = tuple22;
        int exitCode2 = tuple23._1$mcI$sp();
        Seq output2 = (Seq)tuple23._2();
        int n = exitCode2;
        switch (n) {
            case 0: 
            case 128: {
                abbreviatedHashLength = this.findAbbreviatedHashLength();
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(41).append("Non-zero exit code when running git log: ").append(n).toString());
            }
        }
        return (Seq)output2.map((Function1 & Serializable & scala.Serializable)line -> GitCommit$.MODULE$.fromGitRef((String)line, abbreviatedHashLength), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<GitCommit> gitLog(String arguments) {
        int abbreviatedHashLength;
        Predef$.MODULE$.require(this.isGitRepo(this.dir), (Function0 & Serializable & scala.Serializable)() -> "Must be in a git repository");
        Predef$.MODULE$.require(this.isGitCompatible(), (Function0 & Serializable & scala.Serializable)() -> "Must be git version 2.X.X or greater");
        String cmd = new StringBuilder(79).append("git log --oneline --decorate=short --simplify-by-decoration --no-abbrev-commit ").append(arguments).toString();
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(cmd, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = tuple2._1$mcI$sp();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        Tuple2 tuple23 = tuple22;
        int exitCode2 = tuple23._1$mcI$sp();
        Seq output2 = (Seq)tuple23._2();
        int n = exitCode2;
        switch (n) {
            case 0: 
            case 128: {
                abbreviatedHashLength = this.findAbbreviatedHashLength();
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(41).append("Non-zero exit code when running git log: ").append(n).toString());
            }
        }
        return (Seq)output2.map((Function1 & Serializable & scala.Serializable)line -> GitCommit$.MODULE$.fromGitLog((String)line, abbreviatedHashLength), Seq$.MODULE$.canBuildFrom());
    }

    private boolean checkClean() {
        Seq output;
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand("git status --porcelain --untracked-files=no", this.runCommand$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq seq = output = (Seq)tuple2._2();
        Seq output2 = seq;
        return output2.mkString("").isEmpty();
    }

    private int findAbbreviatedHashLength() {
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand("git rev-parse --short HEAD", false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = tuple2._1$mcI$sp();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        Tuple2 tuple23 = tuple22;
        int exitCode2 = tuple23._1$mcI$sp();
        Seq output2 = (Seq)tuple23._2();
        int n = exitCode2;
        switch (n) {
            case 0: 
            case 128: {
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(47).append("Non-zero exit code when running git rev-parse: ").append(n).toString());
            }
        }
        return package$.MODULE$.max(output2.mkString("").trim().length(), 7);
    }

    private Tuple2<Object, Seq<String>> runCommand(String cmd, boolean throwIfNonZero) {
        Predef$.MODULE$.require(this.isGitRepo(this.dir), (Function0 & Serializable & scala.Serializable)() -> "Must be in a git repository");
        Predef$.MODULE$.require(this.isGitCompatible(), (Function0 & Serializable & scala.Serializable)() -> "Must be git version 2.X.X or greater");
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int exitCode = Process$.MODULE$.apply(cmd, this.dir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang((ProcessLogger)outputLogger);
        Tuple2 result = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)outputLogger.stdout().toSeq());
        if (throwIfNonZero && exitCode != 0) {
            throw new IllegalStateException(new StringBuilder(36).append("Non-zero exit code when running '").append(cmd).append("': ").append(exitCode).toString());
        }
        return result;
    }

    private boolean runCommand$default$2() {
        return true;
    }

    public static final /* synthetic */ String $anonfun$new$1() {
        return "Must be in a git repository";
    }

    public static final /* synthetic */ String $anonfun$new$2() {
        return "Must be git version 2.X.X or greater";
    }

    public static final /* synthetic */ Tuple2 $anonfun$branchState$1(GitDriverImpl $this, Tuple2 tp) {
        return new Tuple2($this.gitLog(new StringBuilder(14).append(((GitCommit)tp._1()).fullHash()).append(" --max-count=1").toString()).head(), tp._2());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public GitDriverImpl(File dir) {
        block15: {
            block12: {
                block14: {
                    block13: {
                        this.dir = dir;
                        super();
                        GitDriver.$init$(this);
                        Predef$.MODULE$.require(this.isGitRepo(dir), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$new$1(), ()Ljava/lang/String;)());
                        Predef$.MODULE$.require(this.isGitCompatible(), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$new$2(), ()Ljava/lang/String;)());
                        var4_2 = this.gitLog("--max-count=1").headOption();
                        if (!(var4_2 instanceof Some)) break block12;
                        var5_3 = (Some)var4_2;
                        headCommit = (GitCommit)var5_3.value();
                        releaseRefs = (Seq)this.gitForEachRef().collect((PartialFunction)new scala.Serializable(null){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends GitCommit, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x1;
                                Option<ReleaseVersion> option = ReleaseVersion$.MODULE$.unapply(A1);
                                if (!option.isEmpty()) {
                                    ReleaseVersion rv = (ReleaseVersion)option.get();
                                    object = new Tuple2(A1, (Object)rv);
                                } else {
                                    object = function1.apply(x1);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(GitCommit x1) {
                                GitCommit gitCommit = x1;
                                Option<ReleaseVersion> option = ReleaseVersion$.MODULE$.unapply(gitCommit);
                                boolean bl = !option.isEmpty();
                                return bl;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        releases = (Seq)((TraversableLike)releaseRefs.take(2)).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$branchState$1(com.rallyhealth.sbt.versioning.GitDriverImpl scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)((GitDriverImpl)this), Seq$.MODULE$.canBuildFrom());
                        maybeCurrRelease = releases.headOption();
                        var11_9 = new Tuple2((Object)maybeCurrRelease, (Object)(maybePrevRelease = ((TraversableLike)releases.drop(1)).headOption()));
                        if (var11_9 != null) {
                            var12_10 = (Option)var11_9._1();
                            var13_11 = (Option)var11_9._2();
                            if (var12_10 instanceof Some && (var15_13 = (Tuple2)(var14_12 = (Some)var12_10).value()) != null) {
                                currCommit = (GitCommit)var15_13._1();
                                if (var13_11 instanceof Some && (var18_16 = (Tuple2)(var17_15 = (Some)var13_11).value()) != null) {
                                    prevCommit = (GitCommit)var18_16._1();
                                    v0 = currCommit;
                                    var20_18 = prevCommit;
                                    if (!(v0 != null ? v0.equals(var20_18) == false : var20_18 != null)) {
                                        throw new IllegalStateException(new StringBuilder(36).append("currCommit=").append(currCommit).append(" cannot equal prevCommit=").append(prevCommit).toString());
                                    }
                                }
                            }
                        }
                        if (var11_9 == null) break block13;
                        var21_19 = (Option)var11_9._1();
                        var22_20 = (Option)var11_9._2();
                        if (!(var21_19 instanceof Some) || (var24_22 = (Tuple2)(var23_21 = (Some)var21_19).value()) == null) break block13;
                        currCommit = (GitCommit)var24_22._1();
                        currVersion = (ReleaseVersion)var24_22._2();
                        if (!(var22_20 instanceof Some) || (var28_26 = (Tuple2)(var27_25 = (Some)var22_20).value()) == null) break block13;
                        prevCommit = (GitCommit)var28_26._1();
                        prevVersion = (ReleaseVersion)var28_26._2();
                        v1 = currCommit;
                        var31_29 = headCommit;
                        if (v1 != null ? v1.equals(var31_29) == false : var31_29 != null) break block13;
                        var3_30 /* !! */  = new GitBranchStateTwoReleases(currCommit, currVersion, prevCommit, prevVersion);
                        break block14;
                    }
                    if (var11_9 == null) ** GOTO lbl-1000
                    var32_31 = (Option)var11_9._1();
                    var33_32 = (Option)var11_9._2();
                    if (!(var32_31 instanceof Some) || (var35_34 = (Tuple2)(var34_33 = (Some)var32_31).value()) == null) ** GOTO lbl-1000
                    currCommit = (GitCommit)var35_34._1();
                    currVersion = (ReleaseVersion)var35_34._2();
                    if (!None$.MODULE$.equals(var33_32)) ** GOTO lbl-1000
                    v2 = currCommit;
                    var38_37 = headCommit;
                    if (!(v2 != null ? v2.equals(var38_37) == false : var38_37 != null)) {
                        var3_30 /* !! */  = new GitBranchStateOneReleaseHead(currCommit, currVersion);
                    } else if (var11_9 != null && (var39_38 = (Option)var11_9._1()) instanceof Some && (var41_40 = (Tuple2)(var40_39 = (Some)var39_38).value()) != null) {
                        currCommit = (GitCommit)var41_40._1();
                        currVersion = (ReleaseVersion)var41_40._2();
                        headCommitWithCount = new GitCommitWithCount(headCommit, this.getCommitCount((Option<String>)new Some((Object)currCommit.fullHash())));
                        var3_30 /* !! */  = new GitBranchStateOneReleaseNotHead(headCommitWithCount, currCommit, currVersion);
                    } else if (var11_9 != null && None$.MODULE$.equals(var45_44 = (Option)var11_9._1())) {
                        var3_30 /* !! */  = new GitBranchStateNoReleases(new GitCommitWithCount(headCommit, this.getCommitCount((Option<String>)None$.MODULE$)));
                    } else {
                        throw new MatchError((Object)var11_9);
                    }
                }
                var2_45 /* !! */  = var3_30 /* !! */ ;
                break block15;
            }
            if (None$.MODULE$.equals(var4_2)) {
                var2_45 /* !! */  = GitBranchStateNoCommits$.MODULE$;
            } else {
                throw new MatchError((Object)var4_2);
            }
        }
        this.branchState = var2_45 /* !! */ ;
        this.bitmap$init$0 = true;
    }

    private class GitException
    extends Exception {
        public /* synthetic */ GitDriverImpl com$rallyhealth$sbt$versioning$GitDriverImpl$GitException$$$outer() {
            return GitDriverImpl.this;
        }

        public GitException(String msg) {
            if (GitDriverImpl.this == null) {
                throw null;
            }
            super(msg);
        }
    }
}

