/*
 * Decompiled with CFR 0.152.
 */
package com.jsuereth.pgp;

import com.jsuereth.pgp.PublicKey$;
import com.jsuereth.pgp.PublicKeyLike;
import com.jsuereth.pgp.Signature;
import com.jsuereth.pgp.Signature$;
import com.jsuereth.pgp.StreamingSaveable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u000f\u001f\u0001\u0015B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005k!)\u0001\t\u0001C\u0001\u0003\")A\t\u0001C\u0001\u000b\")\u0011\n\u0001C\u0001\u0015\")a\n\u0001C\u0001\u001f\")\u0001\f\u0001C\u00013\")\u0001\r\u0001C\u0001C\")Q\r\u0001C\u0001\u0015\")a\r\u0001C\u0001O\"9a\u000e\u0001b\u0001\n\u0003y\u0007bBA\u0004\u0001\u0001\u0006I\u0001\u001d\u0005\n\u0003\u0013\u0001!\u0019!C\u0001\u0003\u0017A\u0001\"!\u0006\u0001A\u0003%\u0011Q\u0002\u0005\b\u0003/\u0001A\u0011AA\r\u0011\u001d\tI\u0003\u0001C\u0001\u0003\u0017Aq!a\u000b\u0001\t\u0003\ti\u0003C\u0004\u0002J\u0001!\t!a\u0013\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0004bBA8\u0001\u0011\u0005\u0011\u0011\u000f\u0005\n\u0003\u000b\u0003\u0011\u0013!C\u0001\u0003\u000fCq!!(\u0001\t\u0003\ty\n\u0003\u0006\u0002$\u0002A)\u0019!C!\u0003K;q!a*\u001f\u0011\u0003\tIK\u0002\u0004\u001e=!\u0005\u00111\u0016\u0005\u0007\u0001j!\t!!,\t\u000f\u0005=&\u0004\"\u0001\u00022\nI\u0001+\u001e2mS\u000e\\U-\u001f\u0006\u0003?\u0001\n1\u0001]4q\u0015\t\t#%\u0001\u0005kgV,'/\u001a;i\u0015\u0005\u0019\u0013aA2p[\u000e\u00011\u0003\u0002\u0001'YA\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0007CA\u0017/\u001b\u0005q\u0012BA\u0018\u001f\u00055\u0001VO\u00197jG.+\u0017\u0010T5lKB\u0011Q&M\u0005\u0003ey\u0011\u0011c\u0015;sK\u0006l\u0017N\\4TCZ,\u0017M\u00197f\u0003\u0019qWm\u001d;fIV\tQ\u0007\u0005\u00027{5\tqG\u0003\u00029s\u00059q\u000e]3oa\u001e\u0004(B\u0001\u001e<\u00031\u0011w.\u001e8ds\u000e\f7\u000f\u001e7f\u0015\u0005a\u0014aA8sO&\u0011ah\u000e\u0002\r!\u001e\u0003\u0006+\u001e2mS\u000e\\U-_\u0001\b]\u0016\u001cH/\u001a3!\u0003\u0019a\u0014N\\5u}Q\u0011!i\u0011\t\u0003[\u0001AQaM\u0002A\u0002U\nQa[3z\u0013\u0012+\u0012A\u0012\t\u0003O\u001dK!\u0001\u0013\u0015\u0003\t1{gnZ\u0001\fE&$8\u000b\u001e:f]\u001e$\b.F\u0001L!\t9C*\u0003\u0002NQ\t\u0019\u0011J\u001c;\u0002\u0019\r\u0014X-\u0019;j_:$\u0016.\\3\u0016\u0003A\u0003\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\tU$\u0018\u000e\u001c\u0006\u0002+\u0006!!.\u0019<b\u0013\t9&K\u0001\u0003ECR,\u0017a\u00034j]\u001e,'\u000f\u001d:j]R,\u0012A\u0017\t\u0004Omk\u0016B\u0001/)\u0005\u0015\t%O]1z!\t9c,\u0003\u0002`Q\t!!)\u001f;f\u0003%I7OU3w_.,G-F\u0001c!\t93-\u0003\u0002eQ\t9!i\\8mK\u0006t\u0017!C1mO>\u0014\u0018\u000e\u001e5n\u00035\tGnZ8sSRDWNT1nKV\t\u0001\u000e\u0005\u0002jY6\t!N\u0003\u0002l)\u0006!A.\u00198h\u0013\ti'N\u0001\u0004TiJLgnZ\u0001\bkN,'/\u0013#t+\u0005\u0001\bcA9zy:\u0011!o\u001e\b\u0003gZl\u0011\u0001\u001e\u0006\u0003k\u0012\na\u0001\u0010:p_Rt\u0014\"A\u0015\n\u0005aD\u0013a\u00029bG.\fw-Z\u0005\u0003un\u0014A\u0001T5ti*\u0011\u0001\u0010\u000b\t\u0004{\u0006\raB\u0001@\u0000!\t\u0019\b&C\u0002\u0002\u0002!\na\u0001\u0015:fI\u00164\u0017bA7\u0002\u0006)\u0019\u0011\u0011\u0001\u0015\u0002\u0011U\u001cXM]%Eg\u0002\n!b]5h]\u0006$XO]3t+\t\ti\u0001\u0005\u0003rs\u0006=\u0001cA\u0017\u0002\u0012%\u0019\u00111\u0003\u0010\u0003\u0013MKwM\\1ukJ,\u0017aC:jO:\fG/\u001e:fg\u0002\nqb]5h]\u0006$XO]3t\r>\u0014\u0018\n\u001a\u000b\u0005\u00037\t)\u0003E\u0003\u0002\u001ee\fyB\u0004\u0002(oB\u0019a'!\t\n\u0007\u0005\rrG\u0001\u0007Q\u000fB\u001b\u0016n\u001a8biV\u0014X\r\u0003\u0004\u0002(=\u0001\r\u0001`\u0001\u0003S\u0012\f1\u0003Z5sK\u000e$8*Z=TS\u001et\u0017\r^;sKN\f1C^3sS\u001aLX*Z:tC\u001e,7\u000b\u001e:fC6$RAYA\u0018\u0003\u007fAq!!\r\u0012\u0001\u0004\t\u0019$A\u0003j]B,H\u000f\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\r\tI\u0004V\u0001\u0003S>LA!!\u0010\u00028\tY\u0011J\u001c9viN#(/Z1n\u0011\u001d\t\t%\u0005a\u0001\u0003\u0007\naa\\;uaV$\b\u0003BA\u001b\u0003\u000bJA!a\u0012\u00028\taq*\u001e;qkR\u001cFO]3b[\u00061b/\u001a:jMf\u001c\u0016n\u001a8biV\u0014Xm\u0015;sK\u0006l7\u000fF\u0003c\u0003\u001b\n\t\u0006C\u0004\u0002PI\u0001\r!a\r\u0002\u00075\u001cx\rC\u0004\u0002TI\u0001\r!a\r\u0002\u0013MLwM\\1ukJ,\u0017aC3oGJL\b\u000f\u001e$jY\u0016$b!!\u0017\u0002`\u0005\u001d\u0004cA\u0014\u0002\\%\u0019\u0011Q\f\u0015\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003c\u0019\u0002\u0019AA1!\u0011\t)$a\u0019\n\t\u0005\u0015\u0014q\u0007\u0002\u0005\r&dW\rC\u0004\u0002BM\u0001\r!!\u0019\u0002\u001b\u0015t7M]=qiN#(/\u001b8h)\ra\u0018Q\u000e\u0005\u0007\u0003c!\u0002\u0019\u0001?\u0002\u000f\u0015t7M]=qiRa\u0011\u0011LA:\u0003o\nI(! \u0002\u0002\"9\u0011QO\u000bA\u0002\u0005M\u0012\u0001\u00023bi\u0006Dq!!\u0011\u0016\u0001\u0004\t\u0019\u0005\u0003\u0004\u0002|U\u0001\r\u0001`\u0001\tM&dWMT1nK\"1\u0011qP\u000bA\u0002\u0019\u000bAa]5{K\"A\u00111Q\u000b\u0011\u0002\u0003\u0007\u0001+A\u0004mCN$Xj\u001c3\u0002#\u0015t7M]=qi\u0012\"WMZ1vYR$S'\u0006\u0002\u0002\n*\u001a\u0001+a#,\u0005\u00055\u0005\u0003BAH\u00033k!!!%\u000b\t\u0005M\u0015QS\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a&)\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\u000b\tJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\faa]1wKR{G\u0003BA-\u0003CCq!!\u0011\u0018\u0001\u0004\t\u0019%\u0001\u0005u_N#(/\u001b8h+\u0005a\u0018!\u0003)vE2L7mS3z!\ti#d\u0005\u0002\u001bMQ\u0011\u0011\u0011V\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u0005\u0006M\u0006\"B\u001a\u001d\u0001\u0004)\u0004")
public class PublicKey
implements PublicKeyLike,
StreamingSaveable {
    private String toString;
    private final PGPPublicKey nested;
    private final List<String> userIDs;
    private final List<Signature> signatures;
    private volatile boolean bitmap$0;

    public static PublicKey apply(PGPPublicKey pGPPublicKey) {
        return PublicKey$.MODULE$.apply(pGPPublicKey);
    }

    @Override
    public void saveToFile(File file) {
        StreamingSaveable.saveToFile$(this, file);
    }

    @Override
    public String saveToString() {
        return StreamingSaveable.saveToString$(this);
    }

    @Override
    public final boolean verifyMessageFile(File input, File output) {
        return PublicKeyLike.verifyMessageFile$(this, input, output);
    }

    @Override
    public final String verifyMessageString(String input) {
        return PublicKeyLike.verifyMessageString$(this, input);
    }

    @Override
    public final boolean verifySignatureFile(File raw, File signature) {
        return PublicKeyLike.verifySignatureFile$(this, raw, signature);
    }

    @Override
    public final boolean verifySignatureString(String msg, String signature) {
        return PublicKeyLike.verifySignatureString$(this, msg, signature);
    }

    @Override
    public boolean verifyMessageStreamHelper(InputStream input, OutputStream output, Function1<Object, PGPPublicKey> getKey) {
        return PublicKeyLike.verifyMessageStreamHelper$(this, input, output, getKey);
    }

    @Override
    public boolean verifySignatureStreamsHelper(InputStream msg, InputStream signature, Function1<Object, PGPPublicKey> getKey) {
        return PublicKeyLike.verifySignatureStreamsHelper$(this, msg, signature, getKey);
    }

    public PGPPublicKey nested() {
        return this.nested;
    }

    public long keyID() {
        return this.nested().getKeyID();
    }

    public int bitStrength() {
        return this.nested().getBitStrength();
    }

    public Date creationTime() {
        return this.nested().getCreationTime();
    }

    public byte[] fingerprint() {
        return this.nested().getFingerprint();
    }

    public boolean isRevoked() {
        return this.nested().isRevoked();
    }

    public int algorithm() {
        return this.nested().getAlgorithm();
    }

    public String algorithmName() {
        String string;
        int n = this.nested().getAlgorithm();
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                string = "RSA";
                break;
            }
            case 17: {
                string = "DSA";
                break;
            }
            case 18: {
                string = "EC";
                break;
            }
            case 16: 
            case 20: {
                string = "ElGamal";
                break;
            }
            case 19: {
                string = "ECDSA";
                break;
            }
            default: {
                string = "Unknown";
                break;
            }
        }
        return string;
    }

    public List<String> userIDs() {
        return this.userIDs;
    }

    public List<Signature> signatures() {
        return this.signatures;
    }

    public List<PGPSignature> signaturesForId(String id) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(this.nested().getSignaturesForID(id)).asScala()).toList();
    }

    public List<Signature> directKeySignatures() {
        return (List)this.signatures().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PublicKey.$anonfun$directKeySignatures$1(x$1)));
    }

    @Override
    public boolean verifyMessageStream(InputStream input, OutputStream output) {
        return this.verifyMessageStreamHelper(input, output, (Function1<Object, PGPPublicKey>)(Function1 & Serializable & scala.Serializable)id -> PublicKey.$anonfun$verifyMessageStream$1(this, BoxesRunTime.unboxToLong((Object)id)));
    }

    @Override
    public boolean verifySignatureStreams(InputStream msg, InputStream signature) {
        return this.verifySignatureStreamsHelper(msg, signature, (Function1<Object, PGPPublicKey>)(Function1 & Serializable & scala.Serializable)id -> PublicKey.$anonfun$verifySignatureStreams$1(this, BoxesRunTime.unboxToLong((Object)id)));
    }

    public void encryptFile(File input, File output) {
        FileInputStream in = new FileInputStream(input);
        FileOutputStream out = new FileOutputStream(output);
        try {
            this.encrypt(in, out, input.getName(), input.length(), new Date(input.lastModified()));
        }
        finally {
            in.close();
            out.close();
        }
    }

    public String encryptString(String input) {
        byte[] bytes = input.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.encrypt(in, out, "", bytes.length, new Date());
        }
        finally {
            in.close();
            out.close();
        }
        return out.toString(Charset.defaultCharset().name());
    }

    public void encrypt(InputStream data, OutputStream output, String fileName, long size, Date lastMod) {
        ArmoredOutputStream aout = new ArmoredOutputStream(output);
        SecureRandom rand = new SecureRandom();
        Provider provider = Security.getProvider("BC");
        int encAlgorithm = 3;
        boolean withIntegrityPacket = true;
        JcePGPDataEncryptorBuilder encryptorBuilder = new JcePGPDataEncryptorBuilder(encAlgorithm).setWithIntegrityPacket(withIntegrityPacket).setSecureRandom(rand).setProvider(provider);
        PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)encryptorBuilder);
        encGen.addMethod((PGPKeyEncryptionMethodGenerator)new JcePublicKeyKeyEncryptionMethodGenerator(this.nested()).setProvider(provider).setSecureRandom(rand));
        OutputStream cOut = encGen.open((OutputStream)aout, new byte[1024]);
        PGPLiteralDataGenerator lit = new PGPLiteralDataGenerator();
        OutputStream lOut = lit.open(cOut, 'b', fileName, size, lastMod);
        byte[] buffer = new byte[1024];
        this.read$1(data, buffer, lOut);
        lit.close();
        cOut.close();
        aout.close();
        data.close();
    }

    public Date encrypt$default$5() {
        return new Date();
    }

    @Override
    public void saveTo(OutputStream output) {
        ArmoredOutputStream armoredOut = new ArmoredOutputStream(output);
        this.nested().encode((OutputStream)armoredOut);
        armoredOut.close();
    }

    private String toString$lzycompute() {
        PublicKey publicKey = this;
        synchronized (publicKey) {
            if (!this.bitmap$0) {
                this.toString = new StringOps(Predef$.MODULE$.augmentString("PublicKey(%x, %s, %s@%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.keyID()), this.userIDs().mkString(","), this.algorithmName(), BoxesRunTime.boxToInteger((int)this.bitStrength())}));
                this.bitmap$0 = true;
            }
        }
        return this.toString;
    }

    public String toString() {
        return !this.bitmap$0 ? this.toString$lzycompute() : this.toString;
    }

    public static final /* synthetic */ boolean $anonfun$directKeySignatures$1(Signature x$1) {
        return x$1.signatureType() == 31;
    }

    public static final /* synthetic */ PGPPublicKey $anonfun$verifyMessageStream$1(PublicKey $this, long id) {
        Predef$.MODULE$.assert(id == $this.keyID());
        return $this.nested();
    }

    public static final /* synthetic */ PGPPublicKey $anonfun$verifySignatureStreams$1(PublicKey $this, long id) {
        if ($this.keyID() != id) {
            throw package$.MODULE$.error(new StringOps(Predef$.MODULE$.augmentString("Signature is not for this key.  %x != %x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)id), BoxesRunTime.boxToLong((long)$this.keyID())})));
        }
        return $this.nested();
    }

    private final void read$1(InputStream data$1, byte[] buffer$1, OutputStream lOut$1) {
        while (true) {
            int n = data$1.read(buffer$1);
            switch (n) {
                default: 
            }
            if (n <= 0) break;
            lOut$1.write(buffer$1, 0, n);
        }
    }

    public PublicKey(PGPPublicKey nested) {
        this.nested = nested;
        PublicKeyLike.$init$(this);
        StreamingSaveable.$init$(this);
        this.userIDs = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(nested.getUserIDs()).asScala()).toList();
        this.signatures = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(nested.getSignatures()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)sig -> Signature$.MODULE$.apply((PGPSignature)sig), List$.MODULE$.canBuildFrom());
    }
}

