/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.pgp;

import bleep.plugin.pgp.Signature$;
import bleep.plugin.pgp.StreamingSaveable;
import java.io.OutputStream;
import java.io.Serializable;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPSignature;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class Signature
implements StreamingSaveable {
    private final PGPSignature nested;
    private final List notations;

    public static Signature apply(PGPSignature pGPSignature) {
        return Signature$.MODULE$.apply(pGPSignature);
    }

    public Signature(PGPSignature nested) {
        this.nested = nested;
        Object object = Predef$.MODULE$.refArrayOps((Object[])nested.getHashedSubPackets().getNotationDataOccurrences());
        this.notations = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)data -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)data.getNotationName());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)data.getNotationValue());
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toList();
    }

    public PGPSignature nested() {
        return this.nested;
    }

    public List<Tuple2<String, String>> notations() {
        return this.notations;
    }

    public long keyID() {
        return this.nested().getKeyID();
    }

    public long issuerKeyID() {
        return this.nested().getHashedSubPackets().getIssuerKeyID();
    }

    public long keyExpirationTime() {
        return this.nested().getHashedSubPackets().getKeyExpirationTime();
    }

    public Option<String> signerUserID() {
        return Option$.MODULE$.apply((Object)this.nested().getHashedSubPackets().getSignerUserID());
    }

    public int signatureType() {
        return this.nested().getSignatureType();
    }

    public String signatureTypeString() {
        int n = this.signatureType();
        switch (n) {
            case 31: {
                return "DirectKey";
            }
            case 0: {
                return "Binary Document";
            }
            case 1: {
                return "Canonical Text Doc";
            }
            case 2: {
                return "Stand-alone";
            }
            case 16: {
                return "Default Cert.";
            }
            case 17: {
                return "No Cert.";
            }
            case 19: {
                return "Positive Cert.";
            }
            case 24: {
                return "Subkey Binding";
            }
            case 25: {
                return "Primary Key Binding";
            }
            case 32: {
                return "Key Revocation";
            }
            case 40: {
                return "Subkey Revocation";
            }
            case 48: {
                return "Cert. Revocation";
            }
            case 64: {
                return "Timestamp";
            }
        }
        return "Not enumerated";
    }

    @Override
    public void saveTo(OutputStream output) {
        this.nested().encode((OutputStream)new ArmoredOutputStream(output));
    }

    public String toString() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Signature(key=%x,user=%s,notations=%s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.keyID()), this.signerUserID(), this.notations().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(4).append(k).append(" -> ").append(v).toString();
            }
            throw new MatchError((Object)tuple2);
        }).mkString(",")}));
    }
}

