/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.pgp;

import bleep.logging.LoggerFn;
import bleep.logging.LoggerFn$;
import bleep.logging.TypedLogger;
import bleep.plugin.pgp.PgpSigner;
import bleep.plugin.pgp.PgpSigner$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.sys.process.Process$;
import scala.util.matching.Regex;
import sourcecode.Enclosing$;
import sourcecode.File$;
import sourcecode.Line$;

public class CommandLineGpgSigner
implements PgpSigner {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(CommandLineGpgSigner.class.getDeclaredField("gpgVersionNumber$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CommandLineGpgSigner.class.getDeclaredField("gpgVersion$lzy1"));
    private final String command;
    private final boolean agent;
    private final Option<File> optRing;
    private final Option<String> optKey;
    private final Option<char[]> optPassphrase;
    private volatile Object gpgVersion$lzy1;
    private final Regex TaggedVersion;
    private volatile Object gpgVersionNumber$lzy1;
    private final String toString;

    public CommandLineGpgSigner(String command, boolean agent, Option<File> optRing, Option<String> optKey, Option<char[]> optPassphrase) {
        this.command = command;
        this.agent = agent;
        this.optRing = optRing;
        this.optKey = optKey;
        this.optPassphrase = optPassphrase;
        this.TaggedVersion = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\d{1,14})([\\.\\d{1,14}]*)((?:-\\w+)*)((?:\\+.+)*)"));
        this.toString = new StringBuilder(13).append("GPG-Command(").append(command).append(")").toString();
    }

    public String gpgVersion() {
        Object object = this.gpgVersion$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.gpgVersion$lzyINIT1();
    }

    private Object gpgVersion$lzyINIT1() {
        Object object;
        block9: {
            while (true) {
                if ((object = this.gpgVersion$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        String string2;
                        List lines = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(Process$.MODULE$.apply(this.command, (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--version"}))).$bang$bang())).toList();
                        Option option = lines.headOption();
                        if (option instanceof Some) {
                            String head = (String)((Some)option).value();
                            Object object3 = Predef$.MODULE$.refArrayOps((Object[])head.split(" "));
                            string2 = (String)ArrayOps$.MODULE$.last$extension(object3);
                        } else {
                            string2 = string = "0.0.0";
                        }
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.gpgVersion$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.gpgVersion$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block9;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Tuple2<Object, Object> gpgVersionNumber() {
        Object object = this.gpgVersionNumber$lzy1;
        if (object instanceof Tuple2) {
            return (Tuple2)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Tuple2)this.gpgVersionNumber$lzyINIT1();
    }

    private Object gpgVersionNumber$lzyINIT1() {
        Object object;
        block10: {
            while (true) {
                if ((object = this.gpgVersionNumber$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Tuple2.mcJJ.sp sp2 = null;
                    try {
                        Tuple2.mcJJ.sp sp3;
                        List list;
                        Option option;
                        String string = this.gpgVersion();
                        if (string != null && !(option = this.TaggedVersion.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(4) == 0) {
                            String string2 = (String)list.apply(0);
                            String string3 = (String)list.apply(1);
                            String string4 = (String)list.apply(2);
                            String string5 = (String)list.apply(3);
                            String m = string2;
                            String ns = string3;
                            String ts = string4;
                            String es = string5;
                            sp3 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(m))), CommandLineGpgSigner.splitDot$1(ns).headOption().getOrElse(CommandLineGpgSigner::gpgVersionNumber$lzyINIT1$$anonfun$1));
                        } else {
                            sp3 = sp2 = new Tuple2.mcJJ.sp(0L, 0L);
                        }
                        object2 = sp2 == null ? LazyVals.NullValue$.MODULE$ : sp2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.gpgVersionNumber$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return sp2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block10;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean isLegacyGpg() {
        return this.gpgVersionNumber()._1$mcJ$sp() < 2L;
    }

    @Override
    public byte[] sign(byte[] content, TypedLogger<BoxedUnit> logger) {
        byte[] byArray;
        Object object = PgpSigner$.MODULE$.lock();
        synchronized (object) {
            ByteArrayOutputStream ostream;
            block6: {
                Vector vector;
                scala.collection.immutable.Seq passargs = (scala.collection.immutable.Seq)this.optPassphrase.map((Function1 & Serializable)passArray -> Predef$.MODULE$.wrapCharArray(passArray).mkString("")).map((Function1 & Serializable)pass -> {
                    if (this.isLegacyGpg()) {
                        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--batch", "--passphrase", pass}));
                    }
                    return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--batch", "--pinentry-mode", "loopback", "--passphrase", pass}));
                }).getOrElse(CommandLineGpgSigner::$anonfun$3);
                Option<File> option = this.optRing;
                if (option instanceof Some) {
                    File ring = (File)((Some)option).value();
                    vector = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--no-default-keyring", "--keyring", ring.getPath()}));
                } else {
                    vector = package$.MODULE$.Vector().empty();
                }
                Vector ringargs = vector;
                scala.collection.immutable.Seq keyargs = (scala.collection.immutable.Seq)this.optKey.map((Function1 & Serializable)k -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--default-key", k}))).getOrElse(CommandLineGpgSigner::$anonfun$5);
                scala.collection.immutable.Seq args = (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((IterableOps)passargs.$plus$plus((IterableOnce)ringargs)).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--detach-sign", "--armor"})))).$plus$plus((IterableOnce)(this.agent ? package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--use-agent"})) : package$.MODULE$.Seq().empty()))).$plus$plus((IterableOnce)keyargs);
                scala.collection.immutable.Seq allArguments = (scala.collection.immutable.Seq)args.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--output", "-"})));
                ostream = new ByteArrayOutputStream(1024);
                ByteArrayInputStream istream = new ByteArrayInputStream(content);
                int n = Process$.MODULE$.apply(this.command, (Seq)allArguments).$hash$less(() -> CommandLineGpgSigner.sign$$anonfun$1(istream)).$hash$greater(() -> CommandLineGpgSigner.sign$$anonfun$2(ostream)).$bang(LoggerFn.Syntax$.MODULE$.processLogger$extension(LoggerFn$.MODULE$.Syntax(logger), "signer", Line$.MODULE$.apply(70), File$.MODULE$.apply("/home/runner/work/bleep/bleep/liberated/sbt-pgp/sbt-pgp/src/main/scala/com/jsuereth/sbtpgp/PgpSigner.scala"), Enclosing$.MODULE$.apply("bleep.plugin.pgp.CommandLineGpgSigner#sign")));
                if (0 == n) break block6;
                int n2 = n;
                throw scala.sys.package$.MODULE$.error(new StringBuilder(32).append("Failure running '").append(new StringBuilder(1).append(this.command).append(" ").append(allArguments.mkString(" ")).toString()).append("'.  Exit code: ").append(n2).toString());
            }
            byArray = ostream.toByteArray();
        }
        return byArray;
    }

    public String toString() {
        return this.toString;
    }

    private static final Vector splitOn$1(String s, char sep) {
        if (s == null) {
            return (Vector)package$.MODULE$.Vector().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        }
        Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(s), sep));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filterNot$extension(object, (Function1 & Serializable)_$1 -> {
            String string = _$1;
            String string2 = "";
            return !(string != null ? !string.equals(string2) : string2 != null);
        })).toVector();
    }

    private static final Vector splitDot$1(String s) {
        return (Vector)CommandLineGpgSigner.splitOn$1(s, '.').map((Function1 & Serializable)_$2 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(_$2)));
    }

    private static final long gpgVersionNumber$lzyINIT1$$anonfun$1() {
        return 0L;
    }

    private static final scala.collection.immutable.Seq $anonfun$3() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    private static final scala.collection.immutable.Seq $anonfun$5() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    private static final InputStream sign$$anonfun$1(ByteArrayInputStream istream$1) {
        return istream$1;
    }

    private static final OutputStream sign$$anonfun$2(ByteArrayOutputStream ostream$1) {
        return ostream$1;
    }
}

