/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.pgp;

import bleep.logging.TypedLogger;
import bleep.plugin.pgp.PgpSigner;
import bleep.plugin.pgp.cli.PgpCommandContext;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class BouncyCastlePgpSigner
implements PgpSigner {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(BouncyCastlePgpSigner.class.getDeclaredField("toString$lzy1"));
    private final PgpCommandContext ctx;
    private final long keyId;
    private volatile Object toString$lzy1;

    public BouncyCastlePgpSigner(PgpCommandContext ctx, Option<String> optKey) {
        long l;
        this.ctx = ctx;
        Option<String> option = optKey;
        if (option instanceof Some) {
            String x = (String)((Some)option).value();
            l = new BigInteger(x, 16).longValue();
        } else {
            l = ctx.secretKeyRing().secretKey().keyID();
        }
        this.keyId = l;
    }

    public long keyId() {
        return this.keyId;
    }

    @Override
    public byte[] sign(byte[] content, TypedLogger<BoxedUnit> logger) {
        return (byte[])this.ctx.withPassphrase(this.keyId(), (Function1 & Serializable)pw -> this.ctx.secretKeyRing().apply(this.keyId()).sign(content, (char[])pw));
    }

    public String toString() {
        Object object = this.toString$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.toString$lzyINIT1();
    }

    private Object toString$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.toString$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = new StringBuilder(8).append("BC-PGP(").append(this.ctx.secretKeyRing()).append(")").toString();
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.toString$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }
}

