/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.pgp;

import bleep.logging.TypedLogger;
import bleep.nosbt.InteractionService;
import bleep.plugin.pgp.IncorrectPassphraseException;
import bleep.plugin.pgp.PasswordCache$;
import bleep.plugin.pgp.SbtPgpCommandContext$;
import bleep.plugin.pgp.cli.DelegatingPgpStaticContext;
import bleep.plugin.pgp.cli.PgpCommandContext;
import bleep.plugin.pgp.cli.PgpStaticContext;
import java.io.PrintStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class SbtPgpCommandContext
implements PgpCommandContext,
DelegatingPgpStaticContext,
Product,
Serializable {
    private final PgpStaticContext ctx;
    private final InteractionService interaction;
    private final Option optPassphrase;
    private final TypedLogger logger;

    public static SbtPgpCommandContext apply(PgpStaticContext pgpStaticContext, InteractionService interactionService, Option<char[]> option, TypedLogger<BoxedUnit> typedLogger) {
        return SbtPgpCommandContext$.MODULE$.apply(pgpStaticContext, interactionService, option, typedLogger);
    }

    public static SbtPgpCommandContext fromProduct(Product product) {
        return SbtPgpCommandContext$.MODULE$.fromProduct(product);
    }

    public static SbtPgpCommandContext unapply(SbtPgpCommandContext sbtPgpCommandContext) {
        return SbtPgpCommandContext$.MODULE$.unapply(sbtPgpCommandContext);
    }

    public SbtPgpCommandContext(PgpStaticContext ctx, InteractionService interaction, Option<char[]> optPassphrase, TypedLogger<BoxedUnit> logger) {
        this.ctx = ctx;
        this.interaction = interaction;
        this.optPassphrase = optPassphrase;
        this.logger = logger;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof SbtPgpCommandContext)) return false;
        SbtPgpCommandContext sbtPgpCommandContext = (SbtPgpCommandContext)object;
        PgpStaticContext pgpStaticContext = this.ctx();
        PgpStaticContext pgpStaticContext2 = sbtPgpCommandContext.ctx();
        if (pgpStaticContext == null) {
            if (pgpStaticContext2 != null) {
                return false;
            }
        } else if (!pgpStaticContext.equals(pgpStaticContext2)) return false;
        InteractionService interactionService = this.interaction();
        InteractionService interactionService2 = sbtPgpCommandContext.interaction();
        if (interactionService == null) {
            if (interactionService2 != null) {
                return false;
            }
        } else if (!interactionService.equals(interactionService2)) return false;
        Option<char[]> option = this.optPassphrase();
        Option<char[]> option2 = sbtPgpCommandContext.optPassphrase();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        TypedLogger<BoxedUnit> typedLogger = this.logger();
        TypedLogger<BoxedUnit> typedLogger2 = sbtPgpCommandContext.logger();
        if (typedLogger == null) {
            if (typedLogger2 != null) {
                return false;
            }
        } else if (!typedLogger.equals(typedLogger2)) return false;
        if (!sbtPgpCommandContext.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof SbtPgpCommandContext;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "SbtPgpCommandContext";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "ctx";
            }
            case 1: {
                return "interaction";
            }
            case 2: {
                return "optPassphrase";
            }
            case 3: {
                return "logger";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public PgpStaticContext ctx() {
        return this.ctx;
    }

    public InteractionService interaction() {
        return this.interaction;
    }

    public Option<char[]> optPassphrase() {
        return this.optPassphrase;
    }

    public TypedLogger<BoxedUnit> logger() {
        return this.logger;
    }

    @Override
    public String readInput(String msg) {
        String string;
        PrintStream printStream = System.out;
        synchronized (printStream) {
            string = (String)this.interaction().readLine(msg, false).getOrElse(SbtPgpCommandContext::readInput$$anonfun$1);
        }
        return string;
    }

    @Override
    public String readHidden(String msg) {
        String string;
        PrintStream printStream = System.out;
        synchronized (printStream) {
            string = (String)this.interaction().readLine(msg, true).getOrElse(SbtPgpCommandContext::readHidden$$anonfun$1);
        }
        return string;
    }

    @Override
    public char[] inputPassphrase() {
        String s;
        String string = this.readHidden("Please enter PGP passphrase (or ENTER to abort): ");
        if (string != null && !(s = string).isEmpty()) {
            return s.toCharArray();
        }
        throw scala.sys.package$.MODULE$.error("Empty passphrase. aborting...");
    }

    @Override
    public <U> U withPassphrase(long key, Function1<char[], U> f) {
        Either either = this.retry(3, () -> this.withPassphrase$$anonfun$1(f), ClassTag$.MODULE$.apply(IncorrectPassphraseException.class));
        if (either instanceof Right) {
            Object u = ((Right)either).value();
            return (U)u;
        }
        if (either instanceof Left) {
            IncorrectPassphraseException e = (IncorrectPassphraseException)((Left)either).value();
            throw new IllegalArgumentException(new StringBuilder(44).append("Wrong passphrase for key ").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(key)).toUpperCase()).append(" in ").append(this.ctx().secretKeyRingFile().getAbsolutePath()).append(": ").append(e.getMessage()).append(". aborting...").toString(), e);
        }
        throw new MatchError(either);
    }

    private <A, E extends Exception> Either<E, A> retry(int n, Function0<A> body, ClassTag<E> desired) {
        Right right;
        while (true) {
            try {
                right = package$.MODULE$.Right().apply(body.apply());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof Exception) {
                    Exception e = (Exception)throwable2;
                    if (desired.runtimeClass().isAssignableFrom(e.getClass())) {
                        if (n <= 1) {
                            right = package$.MODULE$.Left().apply((Object)e);
                            break;
                        }
                        --n;
                        continue;
                    }
                }
                throw throwable;
            }
            break;
        }
        return right;
    }

    @Override
    public TypedLogger<BoxedUnit> log() {
        return this.logger();
    }

    @Override
    public <A> void output(Function0<A> msg) {
        Predef$.MODULE$.println(msg.apply());
    }

    public SbtPgpCommandContext copy(PgpStaticContext ctx, InteractionService interaction, Option<char[]> optPassphrase, TypedLogger<BoxedUnit> logger) {
        return new SbtPgpCommandContext(ctx, interaction, optPassphrase, logger);
    }

    public PgpStaticContext copy$default$1() {
        return this.ctx();
    }

    public InteractionService copy$default$2() {
        return this.interaction();
    }

    public Option<char[]> copy$default$3() {
        return this.optPassphrase();
    }

    public TypedLogger<BoxedUnit> copy$default$4() {
        return this.logger();
    }

    public PgpStaticContext _1() {
        return this.ctx();
    }

    public InteractionService _2() {
        return this.interaction();
    }

    public Option<char[]> _3() {
        return this.optPassphrase();
    }

    public TypedLogger<BoxedUnit> _4() {
        return this.logger();
    }

    private static final String readInput$$anonfun$1() {
        throw scala.sys.package$.MODULE$.error("Failed to grab input");
    }

    private static final String readHidden$$anonfun$1() {
        throw scala.sys.package$.MODULE$.error("Failed to grab input");
    }

    private final char[] withPassphrase$$anonfun$1$$anonfun$1$$anonfun$1() {
        return this.inputPassphrase();
    }

    private final char[] withPassphrase$$anonfun$1$$anonfun$1() {
        return (char[])this.optPassphrase().getOrElse(this::withPassphrase$$anonfun$1$$anonfun$1$$anonfun$1);
    }

    private final Object withPassphrase$$anonfun$1(Function1 f$1) {
        return PasswordCache$.MODULE$.withValue(this.ctx().secretKeyRingFile().getAbsolutePath(), this::withPassphrase$$anonfun$1$$anonfun$1, f$1);
    }
}

