/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.pgp;

import bleep.plugin.pgp.PublicKey;
import bleep.plugin.pgp.PublicKey$;
import bleep.plugin.pgp.PublicKeyLike;
import bleep.plugin.pgp.PublicKeyRing$;
import bleep.plugin.pgp.StreamingSaveable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.sys.package$;

public class PublicKeyRing
implements PublicKeyLike,
StreamingSaveable {
    private final PGPPublicKeyRing nested;

    public static PublicKeyRing from(PublicKey publicKey) {
        return PublicKeyRing$.MODULE$.from(publicKey);
    }

    public static PublicKeyRing load(InputStream inputStream) {
        return PublicKeyRing$.MODULE$.load(inputStream);
    }

    public static Object loadFromFile(File file) {
        return PublicKeyRing$.MODULE$.loadFromFile(file);
    }

    public static Object loadFromString(String string) {
        return PublicKeyRing$.MODULE$.loadFromString(string);
    }

    public PublicKeyRing(PGPPublicKeyRing nested) {
        this.nested = nested;
    }

    public PGPPublicKeyRing nested() {
        return this.nested;
    }

    public PublicKeyRing $plus$colon(PublicKey key) {
        return PublicKeyRing$.MODULE$.apply(PGPPublicKeyRing.insertPublicKey((PGPPublicKeyRing)this.nested(), (PGPPublicKey)key.nested()));
    }

    public PublicKeyRing $colon$plus(PublicKey key) {
        return this.$plus$colon(key);
    }

    public PublicKeyRing removeKey(PGPPublicKey key) {
        return PublicKeyRing$.MODULE$.apply(PGPPublicKeyRing.removePublicKey((PGPPublicKeyRing)this.nested(), (PGPPublicKey)key));
    }

    public Option<PublicKey> get(long id) {
        return this.publicKeys().find((Function1 & Serializable)_$1 -> _$1.keyID() == id);
    }

    public PublicKey apply(long id) {
        return (PublicKey)this.get(id).getOrElse(() -> PublicKeyRing.apply$$anonfun$1(id));
    }

    public List<PublicKey> publicKeys() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.nested().getPublicKeys()).asScala().map((Function1 & Serializable)nested -> PublicKey$.MODULE$.apply((PGPPublicKey)nested)).toList();
    }

    public Option<PublicKey> masterKey() {
        return this.publicKeys().find((Function1 & Serializable)_$2 -> _$2.nested().isMasterKey());
    }

    public Option<PublicKey> findPubKey(String value) {
        return this.publicKeys().find((Function1 & Serializable)k -> PublicKeyRing.isValidPubKey$1(value, k));
    }

    public List<PublicKey> encryptionKeys() {
        return this.publicKeys().filter((Function1 & Serializable)_$4 -> _$4.nested().isEncryptionKey());
    }

    public Option<PublicKey> findEncryptionKey(String value) {
        return this.encryptionKeys().find((Function1 & Serializable)k -> PublicKeyRing.isValidPubKey$2(value, k));
    }

    public PublicKey defaultEncryptionKey() {
        return (PublicKey)this.encryptionKeys().headOption().getOrElse(PublicKeyRing::defaultEncryptionKey$$anonfun$1);
    }

    @Override
    public boolean verifyMessageStream(InputStream input, OutputStream output) {
        return this.verifyMessageStreamHelper(input, output, (Function1 & Serializable)x$0 -> this.verifyMessageStream$$anonfun$1(BoxesRunTime.unboxToLong((Object)x$0)));
    }

    @Override
    public boolean verifySignatureStreams(InputStream msg, InputStream signature) {
        return this.verifySignatureStreamsHelper(msg, signature, (Function1 & Serializable)x$0 -> this.verifySignatureStreams$$anonfun$1(BoxesRunTime.unboxToLong((Object)x$0)));
    }

    @Override
    public void saveTo(OutputStream output) {
        ArmoredOutputStream armoredOut = new ArmoredOutputStream(output);
        this.nested().encode((OutputStream)armoredOut);
        armoredOut.close();
    }

    public String toString() {
        return new StringBuilder(15).append("PublicKeyRing(").append(this.publicKeys().mkString(",")).append(")").toString();
    }

    private static final PublicKey apply$$anonfun$1(long id$2) {
        throw package$.MODULE$.error(new StringBuilder(27).append("Could not find public key: ").append(id$2).toString());
    }

    private static final boolean hasKeyId$1(String value$1, PublicKey k) {
        return RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(k.keyID())).contains(value$1);
    }

    private static final boolean hasUserId$1(String value$2, PublicKey k) {
        return k.userIDs().exists((Function1 & Serializable)_$3 -> _$3.contains(value$2));
    }

    private static final boolean isValidPubKey$1(String value$7, PublicKey k) {
        return PublicKeyRing.hasKeyId$1(value$7, k) || PublicKeyRing.hasUserId$1(value$7, k);
    }

    private static final boolean hasKeyId$2(String value$4, PublicKey k) {
        return RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(k.keyID())).contains(value$4);
    }

    private static final boolean hasUserId$2(String value$5, PublicKey k) {
        return k.userIDs().exists((Function1 & Serializable)_$5 -> _$5.contains(value$5));
    }

    private static final boolean isValidPubKey$2(String value$9, PublicKey k) {
        return PublicKeyRing.hasKeyId$2(value$9, k) || PublicKeyRing.hasUserId$2(value$9, k);
    }

    private static final PublicKey defaultEncryptionKey$$anonfun$1() {
        throw package$.MODULE$.error("No encryption key found.");
    }

    private final /* synthetic */ PGPPublicKey verifyMessageStream$$anonfun$1(long x$0) {
        return this.nested().getPublicKey(x$0);
    }

    private final /* synthetic */ PGPPublicKey verifySignatureStreams$$anonfun$1(long x$0) {
        return this.nested().getPublicKey(x$0);
    }
}

