/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.pgp;

import bleep.RelPath;
import bleep.logging.TypedLogger;
import bleep.nosbt.InteractionService;
import bleep.nosbt.librarymanagement.ivy.DirectCredentials;
import bleep.nosbt.package;
import bleep.plugin.pgp.BouncyCastlePgpSigner;
import bleep.plugin.pgp.CommandLineGpgPinentrySigner;
import bleep.plugin.pgp.CommandLineGpgSigner;
import bleep.plugin.pgp.PgpSigner;
import bleep.plugin.pgp.SbtPgpCommandContext$;
import bleep.plugin.pgp.SbtPgpStaticContext;
import bleep.plugin.pgp.SbtPgpStaticContext$;
import bleep.plugin.pgp.cli.PgpCommandContext;
import bleep.plugin.pgp.cli.PgpStaticContext;
import bleep.plugin.pgp.package$;
import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Properties$;

public class PgpPlugin {
    public static final long OFFSET$8 = LazyVals$.MODULE$.getOffsetStatic(PgpPlugin.class.getDeclaredField("useGpgPinentry$lzy1"));
    public static final long OFFSET$7 = LazyVals$.MODULE$.getOffsetStatic(PgpPlugin.class.getDeclaredField("useGpgAgent$lzy1"));
    public static final long OFFSET$6 = LazyVals$.MODULE$.getOffsetStatic(PgpPlugin.class.getDeclaredField("useGpg$lzy1"));
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(PgpPlugin.class.getDeclaredField("gpgCommand$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(PgpPlugin.class.getDeclaredField("pgpStaticContext$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(PgpPlugin.class.getDeclaredField("pgpPassphrase$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(PgpPlugin.class.getDeclaredField("pgpPublicRing$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(PgpPlugin.class.getDeclaredField("pgpSecretRing$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PgpPlugin.class.getDeclaredField("pgpKeyRing$lzy1"));
    private final TypedLogger logger;
    private final Option maybeCredentials;
    private final InteractionService interactionService;
    private final File gnuPGHome;
    private volatile Object pgpKeyRing$lzy1;
    private volatile Object pgpSecretRing$lzy1;
    private volatile Object pgpPublicRing$lzy1;
    private volatile Object pgpPassphrase$lzy1;
    private volatile Object pgpStaticContext$lzy1;
    private volatile Object gpgCommand$lzy1;
    private volatile Object useGpg$lzy1;
    private volatile Object useGpgAgent$lzy1;
    private volatile Object useGpgPinentry$lzy1;

    public PgpPlugin(TypedLogger<BoxedUnit> logger, Option<DirectCredentials> maybeCredentials, InteractionService interactionService) {
        File file;
        this.logger = logger;
        this.maybeCredentials = maybeCredentials;
        this.interactionService = interactionService;
        Option option = Properties$.MODULE$.envOrNone("GNUPGHOME");
        if (option instanceof Some) {
            String dir = (String)((Some)option).value();
            file = new File(dir);
        } else if (None$.MODULE$.equals(option)) {
            file = package.FileOps$.MODULE$.$div$extension(bleep.nosbt.package$.MODULE$.FileOps(new File(System.getProperty("user.home"))), ".gnupg");
        } else {
            throw new MatchError((Object)option);
        }
        this.gnuPGHome = file;
    }

    public TypedLogger<BoxedUnit> logger() {
        return this.logger;
    }

    public Option<DirectCredentials> maybeCredentials() {
        return this.maybeCredentials;
    }

    public InteractionService interactionService() {
        return this.interactionService;
    }

    public File gnuPGHome() {
        return this.gnuPGHome;
    }

    public File fallbackFiles(Seq<File> fs) {
        Predef$.MODULE$.require(fs.nonEmpty());
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(fs.head(), fs.tail());
        File h = (File)tuple2._1();
        Seq t = (Seq)tuple2._2();
        if (t.isEmpty()) {
            return h;
        }
        if (h.exists()) {
            return h;
        }
        return this.fallbackFiles((Seq<File>)t);
    }

    public Option<File> pgpKeyRing() {
        Object object = this.pgpKeyRing$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.pgpKeyRing$lzyINIT1();
    }

    private Object pgpKeyRing$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.pgpKeyRing$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    None$ none$ = null;
                    try {
                        none$ = None$.MODULE$;
                        object2 = none$ == null ? LazyVals.NullValue$.MODULE$ : none$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.pgpKeyRing$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return none$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public File pgpSecretRing() {
        Object object = this.pgpSecretRing$lzy1;
        if (object instanceof File) {
            return (File)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (File)this.pgpSecretRing$lzyINIT1();
    }

    private Object pgpSecretRing$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.pgpSecretRing$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    File file = null;
                    try {
                        file = this.fallbackFiles((Seq<File>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{package.FileOps$.MODULE$.$div$extension(bleep.nosbt.package$.MODULE$.FileOps(this.gnuPGHome()), "secring.gpg"), package.FileOps$.MODULE$.$div$extension(bleep.nosbt.package$.MODULE$.FileOps(package.FileOps$.MODULE$.$div$extension(bleep.nosbt.package$.MODULE$.FileOps(package.FileOps$.MODULE$.$div$extension(bleep.nosbt.package$.MODULE$.FileOps(new File(System.getProperty("user.home"))), ".sbt")), "gpg")), "secring.asc")}));
                        object2 = file == null ? LazyVals.NullValue$.MODULE$ : file;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.pgpSecretRing$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.pgpSecretRing$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return file;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public File pgpPublicRing() {
        Object object = this.pgpPublicRing$lzy1;
        if (object instanceof File) {
            return (File)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (File)this.pgpPublicRing$lzyINIT1();
    }

    private Object pgpPublicRing$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.pgpPublicRing$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    File file = null;
                    try {
                        file = this.fallbackFiles((Seq<File>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{package.FileOps$.MODULE$.$div$extension(bleep.nosbt.package$.MODULE$.FileOps(this.gnuPGHome()), "pubring.gpg"), package.FileOps$.MODULE$.$div$extension(bleep.nosbt.package$.MODULE$.FileOps(package.FileOps$.MODULE$.$div$extension(bleep.nosbt.package$.MODULE$.FileOps(package.FileOps$.MODULE$.$div$extension(bleep.nosbt.package$.MODULE$.FileOps(new File(System.getProperty("user.home"))), ".sbt")), "gpg")), "pubring.asc")}));
                        object2 = file == null ? LazyVals.NullValue$.MODULE$ : file;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.pgpPublicRing$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.pgpPublicRing$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return file;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<char[]> pgpPassphrase() {
        Object object = this.pgpPassphrase$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.pgpPassphrase$lzyINIT1();
    }

    private Object pgpPassphrase$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.pgpPassphrase$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    None$ none$ = null;
                    try {
                        none$ = None$.MODULE$;
                        object2 = none$ == null ? LazyVals.NullValue$.MODULE$ : none$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.pgpPassphrase$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return none$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public PgpStaticContext pgpStaticContext() {
        Object object = this.pgpStaticContext$lzy1;
        if (object instanceof PgpStaticContext) {
            return (PgpStaticContext)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (PgpStaticContext)this.pgpStaticContext$lzyINIT1();
    }

    private Object pgpStaticContext$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.pgpStaticContext$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    SbtPgpStaticContext sbtPgpStaticContext = null;
                    try {
                        sbtPgpStaticContext = SbtPgpStaticContext$.MODULE$.apply(this.pgpPublicRing(), this.pgpSecretRing());
                        object2 = sbtPgpStaticContext == null ? LazyVals.NullValue$.MODULE$ : sbtPgpStaticContext;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.pgpStaticContext$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return sbtPgpStaticContext;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String gpgCommand() {
        Object object = this.gpgCommand$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.gpgCommand$lzyINIT1();
    }

    private Object gpgCommand$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.gpgCommand$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        String string2 = string = package$.MODULE$.isWindows() ? "gpg.exe" : "gpg";
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.gpgCommand$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean useGpg() {
        Object object = this.useGpg$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.useGpg$lzyINIT1());
    }

    private Object useGpg$lzyINIT1() {
        Object object;
        block12: {
            while (true) {
                if ((object = this.useGpg$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        boolean bl2;
                        Option option = scala.sys.package$.MODULE$.props().get("SBT_PGP_USE_GPG");
                        if (option instanceof Some) {
                            bl2 = Boolean.getBoolean("SBT_PGP_USE_GPG");
                        } else if (None$.MODULE$.equals(option)) {
                            bl2 = true;
                        } else {
                            throw new MatchError((Object)option);
                        }
                        bl = BoxesRunTime.boxToBoolean((boolean)bl2);
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.useGpg$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block12;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean useGpgAgent() {
        Object object = this.useGpgAgent$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.useGpgAgent$lzyINIT1());
    }

    private Object useGpgAgent$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.useGpgAgent$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)true);
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.useGpgAgent$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean useGpgPinentry() {
        Object object = this.useGpgPinentry$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.useGpgPinentry$lzyINIT1());
    }

    private Object useGpgPinentry$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.useGpgPinentry$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)false);
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.useGpgPinentry$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public PgpSigner pgpSigner() {
        if (this.useGpg()) {
            if (this.useGpgPinentry()) {
                return new CommandLineGpgPinentrySigner(this.gpgCommand(), this.useGpgAgent(), this.pgpKeyRing(), this.pgpSigningKey(), this.pgpSelectPassphrase());
            }
            return new CommandLineGpgSigner(this.gpgCommand(), this.useGpgAgent(), this.pgpKeyRing(), this.pgpSigningKey(), this.pgpSelectPassphrase());
        }
        return new BouncyCastlePgpSigner(this.pgpCmdContext(), this.pgpSigningKey());
    }

    public Option<char[]> pgpSelectPassphrase() {
        return this.pgpPassphrase().orElse(this::pgpSelectPassphrase$$anonfun$1).orElse(PgpPlugin::pgpSelectPassphrase$$anonfun$2);
    }

    public Option<String> pgpSigningKey() {
        return this.maybeCredentials().map((Function1 & Serializable)_$3 -> _$3.userName());
    }

    public PgpCommandContext pgpCmdContext() {
        return SbtPgpCommandContext$.MODULE$.apply(this.pgpStaticContext(), this.interactionService(), this.pgpSelectPassphrase(), this.logger());
    }

    public Map<RelPath, byte[]> signedArtifacts(Map<RelPath, byte[]> files) {
        PgpSigner signer = this.pgpSigner();
        return (Map)files.flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                RelPath relPath = (RelPath)tuple2._1();
                byte[] content = (byte[])tuple2._2();
                Tuple2 in = tuple2;
                RelPath signedArtifact = relPath.withLast((Function1 & Serializable)_$4 -> new StringBuilder(0).append((String)_$4).append(package$.MODULE$.gpgExtension()).toString());
                byte[] signedContent = signer.sign(content, this.logger());
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{in, Tuple2$.MODULE$.apply((Object)signedArtifact, (Object)signedContent)}));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final Option pgpSelectPassphrase$$anonfun$1() {
        return this.maybeCredentials().map((Function1 & Serializable)_$1 -> _$1.passwd().toCharArray());
    }

    private static final Option pgpSelectPassphrase$$anonfun$2() {
        return Properties$.MODULE$.envOrNone("PGP_PASSPHRASE").map((Function1 & Serializable)_$2 -> _$2.toCharArray());
    }
}

