/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.pgp.cli;

import bleep.logging.Formatter$;
import bleep.logging.LoggerFn;
import bleep.logging.LoggerFn$;
import bleep.plugin.nosbt.io.IO$;
import bleep.plugin.pgp.PGP$;
import bleep.plugin.pgp.cli.GeneratePgpKey$;
import bleep.plugin.pgp.cli.PgpCommand;
import bleep.plugin.pgp.cli.PgpCommandContext;
import java.io.File;
import java.io.Serializable;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import sourcecode.Enclosing$;
import sourcecode.File$;
import sourcecode.Line$;

public class GeneratePgpKey
implements PgpCommand,
Product,
Serializable {
    public static GeneratePgpKey apply() {
        return GeneratePgpKey$.MODULE$.apply();
    }

    public static GeneratePgpKey fromProduct(Product product) {
        return GeneratePgpKey$.MODULE$.fromProduct(product);
    }

    public static boolean unapply(GeneratePgpKey generatePgpKey) {
        return GeneratePgpKey$.MODULE$.unapply(generatePgpKey);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof GeneratePgpKey)) return false;
        GeneratePgpKey generatePgpKey = (GeneratePgpKey)object;
        boolean bl = generatePgpKey.canEqual(this);
        if (!bl) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof GeneratePgpKey;
    }

    public int productArity() {
        return 0;
    }

    public String productPrefix() {
        return "GeneratePgpKey";
    }

    public Object productElement(int n) {
        int n2 = n;
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public void run(PgpCommandContext ctx) {
        if (ctx.publicKeyRingFile().exists()) {
            throw package$.MODULE$.error(new StringBuilder(34).append("Public key ring (").append(ctx.publicKeyRingFile().getAbsolutePath()).append(") already exists!").toString());
        }
        if (ctx.secretKeyRingFile().exists()) {
            throw package$.MODULE$.error(new StringBuilder(34).append("Secret key ring (").append(ctx.secretKeyRingFile().getAbsolutePath()).append(") already exists!").toString());
        }
        File pparent = ctx.publicKeyRingFile().getCanonicalFile().getParentFile();
        File sparent = ctx.secretKeyRingFile().getCanonicalFile().getParentFile();
        if (!pparent.exists()) {
            IO$.MODULE$.createDirectory(pparent);
        }
        if (!sparent.exists()) {
            IO$.MODULE$.createDirectory(sparent);
        }
        String name = ctx.readInput("Please enter the name associated with the key: ");
        String email = ctx.readInput("Please enter the email associated with the key: ");
        String pw = ctx.readHidden("Please enter the passphrase for the key: ");
        String pw2 = ctx.readHidden("Please re-enter the passphrase for the key: ");
        String string = pw;
        String string2 = pw2;
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw package$.MODULE$.error("Passphrases do not match!");
        }
        String id = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s <%s>"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name, email}));
        LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(ctx.log()), GeneratePgpKey::run$$anonfun$1, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(22), File$.MODULE$.apply("/home/runner/work/bleep/bleep/liberated/sbt-pgp/sbt-pgp/src/main/scala/com/jsuereth/pgp/cli/GeneratePgpKey.scala"), Enclosing$.MODULE$.apply("bleep.plugin.pgp.cli.GeneratePgpKey#run"));
        PGP$.MODULE$.makeKeys(id, pw.toCharArray(), ctx.publicKeyRingFile(), ctx.secretKeyRingFile());
        LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(ctx.log()), () -> GeneratePgpKey.run$$anonfun$2(ctx), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(24), File$.MODULE$.apply("/home/runner/work/bleep/bleep/liberated/sbt-pgp/sbt-pgp/src/main/scala/com/jsuereth/pgp/cli/GeneratePgpKey.scala"), Enclosing$.MODULE$.apply("bleep.plugin.pgp.cli.GeneratePgpKey#run"));
        LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(ctx.log()), () -> GeneratePgpKey.run$$anonfun$3(ctx), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(25), File$.MODULE$.apply("/home/runner/work/bleep/bleep/liberated/sbt-pgp/sbt-pgp/src/main/scala/com/jsuereth/pgp/cli/GeneratePgpKey.scala"), Enclosing$.MODULE$.apply("bleep.plugin.pgp.cli.GeneratePgpKey#run"));
        LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(ctx.log()), GeneratePgpKey::run$$anonfun$4, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(26), File$.MODULE$.apply("/home/runner/work/bleep/bleep/liberated/sbt-pgp/sbt-pgp/src/main/scala/com/jsuereth/pgp/cli/GeneratePgpKey.scala"), Enclosing$.MODULE$.apply("bleep.plugin.pgp.cli.GeneratePgpKey#run"));
    }

    public GeneratePgpKey copy() {
        return new GeneratePgpKey();
    }

    private static final String run$$anonfun$1() {
        return "Creating a new PGP key, this could take a long time.";
    }

    private static final String run$$anonfun$2(PgpCommandContext ctx$1) {
        return new StringBuilder(14).append("Public key := ").append(ctx$1.publicKeyRingFile().getAbsolutePath()).toString();
    }

    private static final String run$$anonfun$3(PgpCommandContext ctx$2) {
        return new StringBuilder(14).append("Secret key := ").append(ctx$2.secretKeyRingFile().getAbsolutePath()).toString();
    }

    private static final String run$$anonfun$4() {
        return "Please do not share your secret key.   Your public key is free to share.";
    }
}

