/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.pgp;

import bleep.plugin.pgp.IncorrectPassphraseException;
import bleep.plugin.pgp.IntegrityException$;
import bleep.plugin.pgp.KeyNotFoundException$;
import bleep.plugin.pgp.NotEncryptedMessageException$;
import bleep.plugin.pgp.PublicKey;
import bleep.plugin.pgp.PublicKey$;
import bleep.plugin.pgp.SecretKey$;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SecretKey {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SecretKey.class.getDeclaredField("0bitmap$1"));
    public long 0bitmap$1;
    private final PGPSecretKey nested;
    public String toString$lzy1;

    public static SecretKey apply(PGPSecretKey pGPSecretKey) {
        return SecretKey$.MODULE$.apply(pGPSecretKey);
    }

    public SecretKey(PGPSecretKey nested) {
        this.nested = nested;
    }

    public PGPSecretKey nested() {
        return this.nested;
    }

    public long keyID() {
        return this.nested().getKeyID();
    }

    public boolean isSigningKey() {
        return this.nested().isSigningKey();
    }

    public boolean isMasterKey() {
        return this.nested().isMasterKey();
    }

    public PublicKey publicKey() {
        return PublicKey$.MODULE$.apply(this.nested().getPublicKey());
    }

    public void signStream(InputStream in, OutputStream signature, char[] pass) {
        PGPPrivateKey privateKey = this.extractPrivateKey(pass);
        int keyAlgorithm = this.nested().getPublicKey().getAlgorithm();
        Provider provider = Security.getProvider("BC");
        JcaPGPContentSignerBuilder contentSignerBuilder = new JcaPGPContentSignerBuilder(keyAlgorithm, 2).setProvider(provider).setDigestProvider(provider);
        PGPSignatureGenerator sGen = new PGPSignatureGenerator((PGPContentSignerBuilder)contentSignerBuilder);
        sGen.init(0, privateKey);
        BCPGOutputStream out = new BCPGOutputStream((OutputStream)new ArmoredOutputStream(signature));
        try {
            int ch = in.read();
            while (ch >= 0) {
                sGen.update((byte)ch);
                ch = in.read();
            }
            sGen.generate().encode((OutputStream)out);
        }
        finally {
            in.close();
            out.close();
        }
    }

    public byte[] sign(byte[] content, char[] pass) {
        ByteArrayOutputStream ostream = new ByteArrayOutputStream(1024);
        this.signStream(new ByteArrayInputStream(content), ostream, pass);
        return ostream.toByteArray();
    }

    public String signString(String msg, char[] pass) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.signStream(new ByteArrayInputStream(msg.getBytes()), out, pass);
        return out.toString(Charset.defaultCharset().name());
    }

    public void signMessageStream(InputStream input, String name2, long length, OutputStream output, char[] pass, Date lastMod) {
        ArmoredOutputStream armoredOut = new ArmoredOutputStream(output);
        PGPPrivateKey pgpPrivKey = this.extractPrivateKey(pass);
        int keyAlgorithm = this.nested().getPublicKey().getAlgorithm();
        Provider provider = Security.getProvider("BC");
        JcaPGPContentSignerBuilder contentSignerBuilder = new JcaPGPContentSignerBuilder(keyAlgorithm, 2).setProvider(provider).setDigestProvider(provider);
        PGPSignatureGenerator sGen = new PGPSignatureGenerator((PGPContentSignerBuilder)contentSignerBuilder);
        sGen.init(0, pgpPrivKey);
        this.publicKey().userIDs().foreach((Function1)(JProcedure1 & Serializable)name -> {
            PGPSignatureSubpacketGenerator spGen = new PGPSignatureSubpacketGenerator();
            spGen.addSignerUserID(false, name);
            sGen.setHashedSubpackets(spGen.generate());
        });
        PGPCompressedDataGenerator cGen = new PGPCompressedDataGenerator(2);
        BCPGOutputStream bOut = new BCPGOutputStream(cGen.open((OutputStream)armoredOut));
        sGen.generateOnePassVersion(false).encode((OutputStream)bOut);
        PGPLiteralDataGenerator lGen = new PGPLiteralDataGenerator();
        OutputStream lOut = lGen.open((OutputStream)bOut, 'b', name2, length, lastMod);
        BufferedInputStream in = new BufferedInputStream(input);
        int ch = in.read();
        while (ch >= 0) {
            lOut.write(ch);
            sGen.update((byte)ch);
            ch = in.read();
        }
        in.close();
        lGen.close();
        sGen.generate().encode((OutputStream)bOut);
        cGen.close();
        armoredOut.close();
    }

    public Date signMessageStream$default$6() {
        return new Date();
    }

    public String signMessageString(String input, String name, char[] pass) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] bytes = input.getBytes();
        this.signMessageStream(new ByteArrayInputStream(bytes), name, bytes.length, out, pass, this.signMessageStream$default$6());
        return out.toString(Charset.defaultCharset().name());
    }

    public void signMessageFile(File file, OutputStream out, char[] pass) {
        this.signMessageStream(new FileInputStream(file), file.getName(), file.length(), out, pass, this.signMessageStream$default$6());
    }

    public PublicKey signPublicKey(PublicKey key, Tuple2<String, String> notation, char[] pass) {
        SeqOps seqOps;
        ArmoredOutputStream out = new ArmoredOutputStream((OutputStream)new ByteArrayOutputStream());
        PGPPrivateKey pgpPrivKey = this.extractPrivateKey(pass);
        Provider provider = Security.getProvider("BC");
        JcaPGPContentSignerBuilder contentSignerBuilder = new JcaPGPContentSignerBuilder(this.nested().getPublicKey().getAlgorithm(), 2).setProvider(provider).setDigestProvider(provider);
        PGPSignatureGenerator sGen = new PGPSignatureGenerator((PGPContentSignerBuilder)contentSignerBuilder);
        sGen.init(31, pgpPrivKey);
        BCPGOutputStream bOut = new BCPGOutputStream((OutputStream)out);
        sGen.generateOnePassVersion(false).encode((OutputStream)bOut);
        PGPSignatureSubpacketGenerator spGen = new PGPSignatureSubpacketGenerator();
        boolean isHumanReadable = true;
        spGen.addNotationData(true, isHumanReadable, (String)notation._1(), (String)notation._2());
        this.userIDs().headOption().foreach((Function1)(JProcedure1 & Serializable)_$1 -> spGen.addSignerUserID(false, _$1));
        PGPSignatureSubpacketVector packetVector = spGen.generate();
        sGen.setHashedSubpackets(packetVector);
        bOut.flush();
        out.close();
        List list = (List)key.userIDs().toSeq();
        if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)list), 1) >= 0) {
            String string;
            String user = string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
            Seq seq = SeqFactory.UnapplySeqWrapper$.MODULE$.drop$extension(seqOps, 1);
            return PublicKey$.MODULE$.apply(PGPPublicKey.addCertification((PGPPublicKey)key.nested(), (String)user, (PGPSignature)sGen.generate()));
        }
        return PublicKey$.MODULE$.apply(PGPPublicKey.addCertification((PGPPublicKey)key.nested(), (PGPSignature)sGen.generate()));
    }

    public void decryptFile(File file, char[] passPhrase) {
        this.decryptHelper(new FileInputStream(file), passPhrase, (Function1)(JProcedure1 & Serializable)msg -> {
            InputStream unc = msg.getInputStream();
            File outfile = new File(file.getParentFile(), msg.getFileName());
            BufferedOutputStream fOut = new BufferedOutputStream(new FileOutputStream(outfile));
            byte[] buf = new byte[65536];
            SecretKey.read$1(unc, fOut, buf);
            fOut.close();
        });
    }

    public String decryptString(String input, char[] passPhrase) {
        ByteArrayInputStream bin = new ByteArrayInputStream(input.getBytes());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.decrypt(bin, bout, passPhrase);
        }
        finally {
            bin.close();
            bout.close();
        }
        return bout.toString(Charset.defaultCharset().name());
    }

    public void decrypt(InputStream input, OutputStream output, char[] passPhrase) {
        this.decryptHelper(input, passPhrase, (Function1)(JProcedure1 & Serializable)msg -> {
            InputStream unc = msg.getInputStream();
            BufferedOutputStream fOut = new BufferedOutputStream(output);
            byte[] buf = new byte[65536];
            SecretKey.read$2(unc, fOut, buf);
            fOut.close();
        });
    }

    private <U> U decryptHelper(InputStream input, char[] passPhrase, Function1<PGPLiteralData, U> handler) {
        PGPEncryptedDataList e;
        InputStream fixIn = PGPUtil.getDecoderStream((InputStream)input);
        JcaPGPObjectFactory objF = new JcaPGPObjectFactory(fixIn);
        Object object = objF.nextObject();
        PGPEncryptedDataList enc = object instanceof PGPEncryptedDataList ? (e = (PGPEncryptedDataList)object) : (PGPEncryptedDataList)objF.nextObject();
        PGPPublicKeyEncryptedData pbe = (PGPPublicKeyEncryptedData)CollectionConverters$.MODULE$.IteratorHasAsScala(enc.getEncryptedDataObjects()).asScala().collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(PGPEncryptedData x) {
                PGPEncryptedData pGPEncryptedData = x;
                if (pGPEncryptedData instanceof PGPPublicKeyEncryptedData) {
                    PGPPublicKeyEncryptedData x2 = (PGPPublicKeyEncryptedData)pGPEncryptedData;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(PGPEncryptedData x, Function1 function1) {
                PGPEncryptedData pGPEncryptedData = x;
                if (pGPEncryptedData instanceof PGPPublicKeyEncryptedData) {
                    PGPPublicKeyEncryptedData x2 = (PGPPublicKeyEncryptedData)pGPEncryptedData;
                    return x2;
                }
                return function1.apply((Object)x);
            }
        }).getOrElse(SecretKey::$anonfun$1);
        if (pbe.getKeyID() != this.keyID()) {
            throw KeyNotFoundException$.MODULE$.apply(pbe.getKeyID());
        }
        PGPPrivateKey privKey = this.extractPrivateKey(passPhrase);
        Provider provider = Security.getProvider("BC");
        PublicKeyDataDecryptorFactory dataDecryptorFactory = new JcePublicKeyDataDecryptorFactoryBuilder().setProvider(provider).setContentProvider(provider).build(privKey);
        InputStream clear = pbe.getDataStream(dataDecryptorFactory);
        JcaPGPObjectFactory plainFact = new JcaPGPObjectFactory(clear);
        PGPLiteralData msg = SecretKey.extractLiteral$1(plainFact.nextObject());
        Object result = handler.apply((Object)msg);
        if (pbe.isIntegrityProtected() && !pbe.verify()) {
            throw IntegrityException$.MODULE$.apply("Encrypted message failed integrity check.");
        }
        return (U)result;
    }

    private PGPPrivateKey extractPrivateKey(char[] passPhrase) {
        PGPPrivateKey pGPPrivateKey;
        try {
            Provider provider = Security.getProvider("BC");
            PBESecretKeyDecryptor decryptorFactory = new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider(provider).build()).setProvider(provider).build(passPhrase);
            pGPPrivateKey = this.nested().extractPrivateKey(decryptorFactory);
        }
        catch (Throwable throwable) {
            PGPException e;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof PGPException && (e = (PGPException)throwable2).getMessage().contains("checksum mismatch")) {
                throw new IncorrectPassphraseException("Incorrect passphrase", (Throwable)e);
            }
            throw throwable;
        }
        return pGPPrivateKey;
    }

    public List<String> userIDs() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.nested().getUserIDs()).asScala().toList();
    }

    public String toString() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    String string;
                    this.toString$lzy1 = string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("SecretKey(%x, %s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.nested().getKeyID()), this.userIDs().mkString(",")}));
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return string;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.toString$lzy1;
    }

    private static final void read$1(InputStream unc$1, BufferedOutputStream fOut$1, byte[] buf$1) {
        int n;
        int n2;
        while ((n2 = (n = unc$1.read(buf$1))) > 0) {
            fOut$1.write(buf$1, 0, n2);
        }
    }

    private static final void read$2(InputStream unc$2, BufferedOutputStream fOut$2, byte[] buf$2) {
        int n;
        int n2;
        while ((n2 = (n = unc$2.read(buf$2))) > 0) {
            fOut$2.write(buf$2, 0, n2);
        }
    }

    private static final PGPPublicKeyEncryptedData $anonfun$1() {
        throw new IllegalArgumentException("Secret key for message not found.");
    }

    private static final PGPLiteralData extractLiteral$1(Object x) {
        Object object;
        while (true) {
            if ((object = x) instanceof PGPLiteralData) {
                PGPLiteralData msg = (PGPLiteralData)object;
                return msg;
            }
            if (!(object instanceof PGPCompressedData)) break;
            PGPCompressedData cData = (PGPCompressedData)object;
            BufferedInputStream compressedStream = new BufferedInputStream(cData.getDataStream());
            JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory((InputStream)compressedStream);
            x = pgpFact.nextObject();
        }
        if (object instanceof PGPOnePassSignature) {
            throw NotEncryptedMessageException$.MODULE$.apply("Message is a signature");
        }
        throw NotEncryptedMessageException$.MODULE$.apply("Message is not a simple encrypted file");
    }
}

