/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.pgp.cli;

import bleep.logging.Formatter$;
import bleep.logging.LoggerFn;
import bleep.logging.LoggerFn$;
import bleep.plugin.pgp.PGP$;
import bleep.plugin.pgp.PublicKey;
import bleep.plugin.pgp.PublicKeyRing;
import bleep.plugin.pgp.PublicKeyRingCollection;
import bleep.plugin.pgp.SecretKey;
import bleep.plugin.pgp.cli.PgpCommand;
import bleep.plugin.pgp.cli.PgpCommandContext;
import bleep.plugin.pgp.cli.SignKey$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sourcecode.Enclosing$;
import sourcecode.File$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public class SignKey
implements PgpCommand,
Product,
Serializable {
    private final String pubKey;
    private final Tuple2 notation;

    public static SignKey apply(String string, Tuple2<String, String> tuple2) {
        return SignKey$.MODULE$.apply(string, tuple2);
    }

    public static SignKey fromProduct(Product product) {
        return SignKey$.MODULE$.fromProduct(product);
    }

    public static SignKey unapply(SignKey signKey) {
        return SignKey$.MODULE$.unapply(signKey);
    }

    public SignKey(String pubKey, Tuple2<String, String> notation) {
        this.pubKey = pubKey;
        this.notation = notation;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof SignKey)) return false;
        SignKey signKey = (SignKey)object;
        String string = this.pubKey();
        String string2 = signKey.pubKey();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Tuple2<String, String> tuple2 = this.notation();
        Tuple2<String, String> tuple22 = signKey.notation();
        if (tuple2 == null) {
            if (tuple22 != null) {
                return false;
            }
        } else if (!tuple2.equals(tuple22)) return false;
        if (!signKey.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof SignKey;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "SignKey";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "pubKey";
        }
        if (1 == n2) {
            return "notation";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String pubKey() {
        return this.pubKey;
    }

    public Tuple2<String, String> notation() {
        return this.notation;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void run(PgpCommandContext ctx) {
        List matches = ((List)ctx.publicKeyRing().keyRings().toSeq()).flatMap((Function1 & Serializable)ring -> (IterableOnce)ring.publicKeys().withFilter((Function1 & Serializable)key -> PGP$.MODULE$.isPublicKeyMatching(this.pubKey(), (PublicKey)key)).map((Function1 & Serializable)key -> {
            PublicKeyRing publicKeyRing = (PublicKeyRing)Predef$.MODULE$.ArrowAssoc(ring);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)publicKeyRing, key);
        }));
        List list = matches;
        if (list != null) {
            Tuple2 tuple2;
            SeqOps seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 1) >= 0 && (tuple2 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0)) != null) {
                PublicKeyRing ring2 = (PublicKeyRing)tuple2._1();
                PublicKey key = (PublicKey)tuple2._2();
                Seq seq = SeqFactory.UnapplySeqWrapper$.MODULE$.drop$extension(seqOps, 1);
                SecretKey signingKey = ctx.secretKeyRing().secretKey();
                PublicKey newkey = (PublicKey)ctx.withPassphrase(signingKey.keyID(), (Function1 & Serializable)pw -> {
                    PublicKey publicKey;
                    LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(ctx.log()), () -> SignKey.$anonfun$2$$anonfun$1(key), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(15), File$.MODULE$.apply("/home/runner/work/bleep/bleep/liberated/sbt-pgp/sbt-pgp/src/main/scala/com/jsuereth/pgp/cli/SignKey.scala"), Enclosing$.MODULE$.apply("bleep.plugin.pgp.cli.SignKey#run newpubringcol newkey"));
                    try {
                        publicKey = signingKey.signPublicKey(key, this.notation(), (char[])pw);
                    }
                    catch (Throwable t) {
                        LoggerFn.Syntax$.MODULE$.error$extension(LoggerFn$.MODULE$.Syntax(ctx.log()), SignKey::$anonfun$2$$anonfun$2, t, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(20), File$.MODULE$.apply("/home/runner/work/bleep/bleep/liberated/sbt-pgp/sbt-pgp/src/main/scala/com/jsuereth/pgp/cli/SignKey.scala"), Enclosing$.MODULE$.apply("bleep.plugin.pgp.cli.SignKey#run newpubringcol newkey"));
                        throw t;
                    }
                    return publicKey;
                });
                PublicKeyRing newpubring = ring2.$colon$plus(newkey);
                PublicKeyRingCollection newpubringcol = ctx.publicKeyRing().removeRing(ring2).$colon$plus(newpubring);
                newpubringcol.saveToFile(ctx.publicKeyRingFile());
                return;
            }
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 0) == 0) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(20).append("Could not find key: ").append(this.pubKey()).toString());
            }
        }
        List matches2 = list;
        throw scala.sys.package$.MODULE$.error(new StringBuilder(31).append("Found more than on public key: ").append(matches2.map((Function1 & Serializable)_$1 -> (PublicKey)_$1._2()).mkString(",")).toString());
    }

    public SignKey copy(String pubKey, Tuple2<String, String> notation) {
        return new SignKey(pubKey, notation);
    }

    public String copy$default$1() {
        return this.pubKey();
    }

    public Tuple2<String, String> copy$default$2() {
        return this.notation();
    }

    public String _1() {
        return this.pubKey();
    }

    public Tuple2<String, String> _2() {
        return this.notation();
    }

    private static final String v$proxy1$1(PublicKey key$3) {
        return new StringBuilder(13).append("Signing key: ").append(key$3).toString();
    }

    private static final Text $anonfun$2$$anonfun$1(PublicKey key$2) {
        return Text$.MODULE$.apply((Object)SignKey.v$proxy1$1(key$2), "\"Signing key: \" + key");
    }

    private static final Text $anonfun$2$$anonfun$2() {
        return Text$.MODULE$.apply((Object)"Error signing key!", "\"Error signing key!\"");
    }
}

