/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.pgp;

import bleep.logging.LoggerFn;
import bleep.logging.LoggerFn$;
import bleep.logging.TypedLogger;
import bleep.plugin.pgp.PgpSigner;
import bleep.plugin.pgp.PgpSigner$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.sys.process.Process$;
import sourcecode.Enclosing$;
import sourcecode.File$;
import sourcecode.Line$;

public class CommandLineGpgPinentrySigner
implements PgpSigner {
    private final String command;
    private final boolean agent;
    private final Option<File> optRing;
    private final Option<String> optKey;
    private final Option<char[]> optPassphrase;
    private final String toString;

    public CommandLineGpgPinentrySigner(String command, boolean agent, Option<File> optRing, Option<String> optKey, Option<char[]> optPassphrase) {
        this.command = command;
        this.agent = agent;
        this.optRing = optRing;
        this.optKey = optKey;
        this.optPassphrase = optPassphrase;
        this.toString = new StringBuilder(19).append("GPG-Agent-Command(").append(command).append(")").toString();
    }

    @Override
    public byte[] sign(byte[] content, TypedLogger<BoxedUnit> logger) {
        byte[] byArray;
        Object object = PgpSigner$.MODULE$.lock();
        synchronized (object) {
            ByteArrayOutputStream ostream;
            block6: {
                Vector vector;
                scala.collection.immutable.Seq pinentryargs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--pinentry-mode", "loopback"}));
                scala.collection.immutable.Seq passargs = (scala.collection.immutable.Seq)this.optPassphrase.map((Function1 & Serializable)passArray -> Predef$.MODULE$.wrapCharArray(passArray).mkString("")).map((Function1 & Serializable)pass -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--batch", "--passphrase", pass}))).getOrElse(CommandLineGpgPinentrySigner::$anonfun$8);
                Option<File> option = this.optRing;
                if (option instanceof Some) {
                    File ring = (File)((Some)option).value();
                    vector = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--no-default-keyring", "--keyring", ring.getPath()}));
                } else {
                    vector = package$.MODULE$.Vector().empty();
                }
                Vector ringargs = vector;
                scala.collection.immutable.Seq keyargs = (scala.collection.immutable.Seq)this.optKey.map((Function1 & Serializable)k -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--default-key", k}))).getOrElse(CommandLineGpgPinentrySigner::$anonfun$10);
                scala.collection.immutable.Seq args = (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((IterableOps)((IterableOps)passargs.$plus$plus((IterableOnce)ringargs)).$plus$plus((IterableOnce)pinentryargs)).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--detach-sign", "--armor"})))).$plus$plus((IterableOnce)(this.agent ? package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--use-agent"})) : package$.MODULE$.Seq().empty()))).$plus$plus((IterableOnce)keyargs);
                scala.collection.immutable.Seq allArguments = (scala.collection.immutable.Seq)args.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--output", "-"})));
                ostream = new ByteArrayOutputStream(1024);
                ByteArrayInputStream istream = new ByteArrayInputStream(content);
                int n = Process$.MODULE$.apply(this.command, (Seq)allArguments).$hash$less(() -> CommandLineGpgPinentrySigner.sign$$anonfun$3(istream)).$hash$greater(() -> CommandLineGpgPinentrySigner.sign$$anonfun$4(ostream)).$bang(LoggerFn.Syntax$.MODULE$.processLogger$extension(LoggerFn$.MODULE$.Syntax(logger), "signer", Line$.MODULE$.apply(112), File$.MODULE$.apply("/home/runner/work/bleep/bleep/liberated/sbt-pgp/sbt-pgp/src/main/scala/com/jsuereth/sbtpgp/PgpSigner.scala"), Enclosing$.MODULE$.apply("bleep.plugin.pgp.CommandLineGpgPinentrySigner#sign")));
                if (0 == n) break block6;
                int n2 = n;
                throw scala.sys.package$.MODULE$.error(new StringBuilder(32).append("Failure running '").append(new StringBuilder(1).append(this.command).append(" ").append(allArguments.mkString(" ")).toString()).append("'.  Exit code: ").append(n2).toString());
            }
            byArray = ostream.toByteArray();
        }
        return byArray;
    }

    public String toString() {
        return this.toString;
    }

    private static final scala.collection.immutable.Seq $anonfun$8() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    private static final scala.collection.immutable.Seq $anonfun$10() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    private static final ByteArrayInputStream sign$$anonfun$3(ByteArrayInputStream istream$2) {
        return istream$2;
    }

    private static final ByteArrayOutputStream sign$$anonfun$4(ByteArrayOutputStream ostream$2) {
        return ostream$2;
    }
}

