/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.pgp;

import bleep.plugin.pgp.KeyNotFoundException;
import bleep.plugin.pgp.PGP$;
import bleep.plugin.pgp.PublicKey;
import bleep.plugin.pgp.PublicKeyLike;
import bleep.plugin.pgp.PublicKeyRing;
import bleep.plugin.pgp.PublicKeyRing$;
import bleep.plugin.pgp.PublicKeyRingCollection$;
import bleep.plugin.pgp.StreamingSaveable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class PublicKeyRingCollection
implements PublicKeyLike,
StreamingSaveable {
    private final PGPPublicKeyRingCollection nested;
    private final List keyRings;

    public static PublicKeyRingCollection apply(PGPPublicKeyRingCollection pGPPublicKeyRingCollection) {
        return PublicKeyRingCollection$.MODULE$.apply(pGPPublicKeyRingCollection);
    }

    public static PublicKeyRingCollection load(InputStream inputStream) {
        return PublicKeyRingCollection$.MODULE$.load(inputStream);
    }

    public static Object loadFromFile(File file) {
        return PublicKeyRingCollection$.MODULE$.loadFromFile(file);
    }

    public static Object loadFromString(String string) {
        return PublicKeyRingCollection$.MODULE$.loadFromString(string);
    }

    public PublicKeyRingCollection(PGPPublicKeyRingCollection nested2) {
        this.nested = nested2;
        this.keyRings = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(nested2.getKeyRings()).asScala()).map((Function1 & Serializable)nested -> PublicKeyRing$.MODULE$.apply((PGPPublicKeyRing)nested)).toList();
    }

    public PGPPublicKeyRingCollection nested() {
        return this.nested;
    }

    public List<PublicKeyRing> keyRings() {
        return this.keyRings;
    }

    public List<PublicKey> publicKeys() {
        return this.keyRings().flatMap((Function1 & Serializable)_$1 -> _$1.publicKeys());
    }

    public Option<PublicKeyRing> findPubKeyRing(String value) {
        return this.keyRings().find((Function1 & Serializable)ring -> ring.publicKeys().exists((Function1 & Serializable)pubKey -> PGP$.MODULE$.isPublicKeyMatching(value, (PublicKey)pubKey)));
    }

    public Option<PublicKey> findPubKey(String value) {
        return this.publicKeys().find((Function1 & Serializable)k -> PGP$.MODULE$.isPublicKeyMatching(value, (PublicKey)k));
    }

    public Option<PublicKey> getKey(long id) {
        return this.publicKeys().find((Function1 & Serializable)_$2 -> _$2.keyID() == id);
    }

    public List<PublicKey> encryptionKeys() {
        return this.publicKeys().filter((Function1 & Serializable)_$3 -> _$3.nested().isEncryptionKey());
    }

    public Option<PublicKey> findEncryptionKey(String value) {
        return this.encryptionKeys().find((Function1 & Serializable)k -> PGP$.MODULE$.isPublicKeyMatching(value, (PublicKey)k));
    }

    public PublicKeyRingCollection $plus$colon(PublicKeyRing ring) {
        return PublicKeyRingCollection$.MODULE$.apply(PGPPublicKeyRingCollection.addPublicKeyRing((PGPPublicKeyRingCollection)this.nested(), (PGPPublicKeyRing)ring.nested()));
    }

    public PublicKeyRingCollection $colon$plus(PublicKeyRing ring) {
        return this.$plus$colon(ring);
    }

    public PublicKeyRingCollection removeRing(PublicKeyRing ring) {
        return PublicKeyRingCollection$.MODULE$.apply(PGPPublicKeyRingCollection.removePublicKeyRing((PGPPublicKeyRingCollection)this.nested(), (PGPPublicKeyRing)ring.nested()));
    }

    private PGPPublicKey pkeyLookup(long id) {
        return (PGPPublicKey)this.getKey(id).map((Function1 & Serializable)_$4 -> _$4.nested()).getOrElse(() -> PublicKeyRingCollection.pkeyLookup$$anonfun$2(id));
    }

    @Override
    public boolean verifyMessageStream(InputStream input, OutputStream output) {
        return this.verifyMessageStreamHelper(input, output, (Function1 & Serializable)id -> this.verifyMessageStream$$anonfun$1(BoxesRunTime.unboxToLong((Object)id)));
    }

    @Override
    public boolean verifySignatureStreams(InputStream msg, InputStream signature) {
        return this.verifySignatureStreamsHelper(msg, signature, (Function1 & Serializable)id -> this.verifySignatureStreams$$anonfun$1(BoxesRunTime.unboxToLong((Object)id)));
    }

    @Override
    public void saveTo(OutputStream output) {
        ArmoredOutputStream armoredOut = new ArmoredOutputStream(output);
        this.nested().encode((OutputStream)armoredOut);
        armoredOut.close();
    }

    public String toString() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("PublicKeyRingCollecton(\n\t%s\n)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.keyRings().mkString(",\n\t")}));
    }

    private static final PGPPublicKey pkeyLookup$$anonfun$2(long id$2) {
        throw new KeyNotFoundException(id$2);
    }

    private final /* synthetic */ PGPPublicKey verifyMessageStream$$anonfun$1(long id) {
        return this.pkeyLookup(id);
    }

    private final /* synthetic */ PGPPublicKey verifySignatureStreams$$anonfun$1(long id) {
        return this.pkeyLookup(id);
    }
}

