/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.pgp;

import bleep.plugin.pgp.KeyNotFoundException$;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.Security;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.sys.package$;

public interface PublicKeyLike {
    public boolean verifyMessageStream(InputStream var1, OutputStream var2);

    public static boolean verifyMessageFile$(PublicKeyLike $this, File input, File output) {
        return $this.verifyMessageFile(input, output);
    }

    default public boolean verifyMessageFile(File input, File output) {
        boolean bl;
        FileInputStream in = new FileInputStream(input);
        FileOutputStream out = new FileOutputStream(output);
        try {
            bl = this.verifyMessageStream(in, out);
        }
        finally {
            in.close();
            out.close();
        }
        return bl;
    }

    public static String verifyMessageString$(PublicKeyLike $this, String input) {
        return $this.verifyMessageString(input);
    }

    default public String verifyMessageString(String input) {
        ByteArrayOutputStream out;
        ByteArrayInputStream in = new ByteArrayInputStream(input.getBytes());
        if (!this.verifyMessageStream(in, out = new ByteArrayOutputStream())) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        return out.toString(Charset.defaultCharset().name());
    }

    public boolean verifySignatureStreams(InputStream var1, InputStream var2);

    public static boolean verifySignatureFile$(PublicKeyLike $this, File raw, File signature) {
        return $this.verifySignatureFile(raw, signature);
    }

    default public boolean verifySignatureFile(File raw, File signature) {
        boolean bl;
        FileInputStream in = new FileInputStream(raw);
        FileInputStream in2 = new FileInputStream(signature);
        try {
            bl = this.verifySignatureStreams(in, in2);
        }
        finally {
            in.close();
            in2.close();
        }
        return bl;
    }

    public static boolean verifySignatureString$(PublicKeyLike $this, String msg, String signature) {
        return $this.verifySignatureString(msg, signature);
    }

    default public boolean verifySignatureString(String msg, String signature) {
        boolean bl;
        ByteArrayInputStream in = new ByteArrayInputStream(msg.getBytes());
        ByteArrayInputStream in2 = new ByteArrayInputStream(signature.getBytes());
        try {
            bl = this.verifySignatureStreams(in, in2);
        }
        finally {
            in.close();
            in2.close();
        }
        return bl;
    }

    public static boolean verifyMessageStreamHelper$(PublicKeyLike $this, InputStream input, OutputStream output, Function1 getKey) {
        return $this.verifyMessageStreamHelper(input, output, (Function1<Object, PGPPublicKey>)getKey);
    }

    default public boolean verifyMessageStreamHelper(InputStream input, OutputStream output, Function1<Object, PGPPublicKey> getKey) {
        InputStream in = PGPUtil.getDecoderStream((InputStream)input);
        JcaPGPObjectFactory tmp = new JcaPGPObjectFactory(in);
        PGPCompressedData c1 = (PGPCompressedData)tmp.nextObject();
        JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(c1.getDataStream());
        PGPOnePassSignatureList sigList = (PGPOnePassSignatureList)pgpFact.nextObject();
        PGPOnePassSignature ops = sigList.get(0);
        PGPLiteralData p2 = (PGPLiteralData)pgpFact.nextObject();
        InputStream dIn = p2.getInputStream();
        PGPPublicKey key = (PGPPublicKey)getKey.apply((Object)BoxesRunTime.boxToLong((long)ops.getKeyID()));
        ops.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider(Security.getProvider("BC")), key);
        int ch = dIn.read();
        while (ch >= 0) {
            ops.update((byte)ch);
            output.write(ch);
            ch = dIn.read();
        }
        PGPSignatureList p3 = (PGPSignatureList)pgpFact.nextObject();
        return ops.verify(p3.get(0));
    }

    public static boolean verifySignatureStreamsHelper$(PublicKeyLike $this, InputStream msg, InputStream signature, Function1 getKey) {
        return $this.verifySignatureStreamsHelper(msg, signature, (Function1<Object, PGPPublicKey>)getKey);
    }

    default public boolean verifySignatureStreamsHelper(InputStream msg, InputStream signature, Function1<Object, PGPPublicKey> getKey) {
        Tuple2 tuple2;
        InputStream in = PGPUtil.getDecoderStream((InputStream)signature);
        JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(in);
        Object o = pgpFact.nextObject();
        Object object = o;
        if (object instanceof PGPCompressedData) {
            PGPCompressedData c1 = (PGPCompressedData)object;
            tuple2 = Tuple2$.MODULE$.apply((Object)((PGPSignatureList)pgpFact.nextObject()), (Object)new JcaPGPObjectFactory(c1.getDataStream()));
        } else if (object instanceof PGPSignatureList) {
            PGPSignatureList sigList = (PGPSignatureList)object;
            tuple2 = Tuple2$.MODULE$.apply((Object)sigList, (Object)pgpFact);
        } else {
            Object other = object;
            throw package$.MODULE$.error(new StringBuilder(13).append("Unexepected: ").append(other).toString());
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        PGPSignatureList sigList = (PGPSignatureList)tuple22._1();
        JcaPGPObjectFactory pgpFact2 = (JcaPGPObjectFactory)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)sigList, (Object)pgpFact2);
        PGPSignatureList sigList2 = (PGPSignatureList)tuple23._1();
        JcaPGPObjectFactory pgpFact3 = (JcaPGPObjectFactory)tuple23._2();
        BufferedInputStream dIn = new BufferedInputStream(msg);
        PGPSignature sig = sigList2.get(0);
        PGPPublicKey pGPPublicKey = (PGPPublicKey)getKey.apply((Object)BoxesRunTime.boxToLong((long)sig.getKeyID()));
        if (pGPPublicKey == null) {
            throw KeyNotFoundException$.MODULE$.apply(sig.getKeyID());
        }
        PGPPublicKey key = pGPPublicKey;
        sig.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider(Security.getProvider("BC")), key);
        int ch = dIn.read();
        while (ch >= 0) {
            sig.update((byte)ch);
            ch = dIn.read();
        }
        dIn.close();
        return sig.verify();
    }
}

