/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.pgp;

import bleep.plugin.pgp.PublicKey$;
import bleep.plugin.pgp.PublicKeyLike;
import bleep.plugin.pgp.Signature;
import bleep.plugin.pgp.Signature$;
import bleep.plugin.pgp.StreamingSaveable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PublicKey
implements PublicKeyLike,
StreamingSaveable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PublicKey.class.getDeclaredField("0bitmap$1"));
    public long 0bitmap$1;
    private final PGPPublicKey nested;
    private final List userIDs;
    private final List signatures;
    public String toString$lzy1;

    public static PublicKey apply(PGPPublicKey pGPPublicKey) {
        return PublicKey$.MODULE$.apply(pGPPublicKey);
    }

    public PublicKey(PGPPublicKey nested) {
        this.nested = nested;
        this.userIDs = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(nested.getUserIDs()).asScala()).toList();
        this.signatures = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(nested.getSignatures()).asScala()).toList().map((Function1 & Serializable)sig -> Signature$.MODULE$.apply((PGPSignature)sig));
    }

    public PGPPublicKey nested() {
        return this.nested;
    }

    public long keyID() {
        return this.nested().getKeyID();
    }

    public int bitStrength() {
        return this.nested().getBitStrength();
    }

    public Date creationTime() {
        return this.nested().getCreationTime();
    }

    public byte[] fingerprint() {
        return this.nested().getFingerprint();
    }

    public boolean isRevoked() {
        return this.nested().isRevoked();
    }

    public int algorithm() {
        return this.nested().getAlgorithm();
    }

    public String algorithmName() {
        int n = this.nested().getAlgorithm();
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return "RSA";
            }
            case 17: {
                return "DSA";
            }
            case 18: {
                return "EC";
            }
            case 16: 
            case 20: {
                return "ElGamal";
            }
            case 19: {
                return "ECDSA";
            }
        }
        return "Unknown";
    }

    public List<String> userIDs() {
        return this.userIDs;
    }

    public List<Signature> signatures() {
        return this.signatures;
    }

    public List<PGPSignature> signaturesForId(String id) {
        return ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(this.nested().getSignaturesForID(id)).asScala()).toList();
    }

    public List<Signature> directKeySignatures() {
        return this.signatures().filter((Function1 & Serializable)_$1 -> _$1.signatureType() == 31);
    }

    @Override
    public boolean verifyMessageStream(InputStream input, OutputStream output) {
        return this.verifyMessageStreamHelper(input, output, (Function1 & Serializable)id -> this.verifyMessageStream$$anonfun$1(BoxesRunTime.unboxToLong((Object)id)));
    }

    @Override
    public boolean verifySignatureStreams(InputStream msg, InputStream signature) {
        return this.verifySignatureStreamsHelper(msg, signature, (Function1 & Serializable)id -> this.verifySignatureStreams$$anonfun$1(BoxesRunTime.unboxToLong((Object)id)));
    }

    public void encryptFile(File input, File output) {
        FileInputStream in = new FileInputStream(input);
        FileOutputStream out = new FileOutputStream(output);
        try {
            this.encrypt(in, out, input.getName(), input.length(), new Date(input.lastModified()));
        }
        finally {
            in.close();
            out.close();
        }
    }

    public String encryptString(String input) {
        byte[] bytes = input.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.encrypt(in, out, "", bytes.length, new Date());
        }
        finally {
            in.close();
            out.close();
        }
        return out.toString(Charset.defaultCharset().name());
    }

    public void encrypt(InputStream data, OutputStream output, String fileName, long size, Date lastMod) {
        ArmoredOutputStream aout = new ArmoredOutputStream(output);
        SecureRandom rand = new SecureRandom();
        Provider provider = Security.getProvider("BC");
        int encAlgorithm = 3;
        boolean withIntegrityPacket = true;
        JcePGPDataEncryptorBuilder encryptorBuilder = new JcePGPDataEncryptorBuilder(encAlgorithm).setWithIntegrityPacket(withIntegrityPacket).setSecureRandom(rand).setProvider(provider);
        PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)encryptorBuilder);
        encGen.addMethod((PGPKeyEncryptionMethodGenerator)new JcePublicKeyKeyEncryptionMethodGenerator(this.nested()).setProvider(provider).setSecureRandom(rand));
        OutputStream cOut = encGen.open((OutputStream)aout, new byte[1024]);
        PGPLiteralDataGenerator lit = new PGPLiteralDataGenerator();
        OutputStream lOut = lit.open(cOut, 'b', fileName, size, lastMod);
        byte[] buffer = new byte[1024];
        PublicKey.read$1(data, lOut, buffer);
        lit.close();
        cOut.close();
        aout.close();
        data.close();
    }

    public Date encrypt$default$5() {
        return new Date();
    }

    @Override
    public void saveTo(OutputStream output) {
        ArmoredOutputStream armoredOut = new ArmoredOutputStream(output);
        this.nested().encode((OutputStream)armoredOut);
        armoredOut.close();
    }

    public String toString() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    String string;
                    this.toString$lzy1 = string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("PublicKey(%x, %s, %s@%d)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.keyID()), this.userIDs().mkString(","), this.algorithmName(), BoxesRunTime.boxToInteger((int)this.bitStrength())}));
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return string;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.toString$lzy1;
    }

    private final /* synthetic */ PGPPublicKey verifyMessageStream$$anonfun$1(long id) {
        if (id != this.keyID()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        return this.nested();
    }

    private final /* synthetic */ PGPPublicKey verifySignatureStreams$$anonfun$1(long id) {
        if (this.keyID() != id) {
            throw package$.MODULE$.error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Signature is not for this key.  %x != %x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)id), BoxesRunTime.boxToLong((long)this.keyID())})));
        }
        return this.nested();
    }

    private static final void read$1(InputStream data$1, OutputStream lOut$1, byte[] buffer$1) {
        int n;
        int n2;
        while ((n2 = (n = data$1.read(buffer$1))) > 0) {
            lOut$1.write(buffer$1, 0, n2);
        }
    }
}

