/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.pgp;

import bleep.plugin.pgp.PublicKey$;
import bleep.plugin.pgp.PublicKeyLike;
import bleep.plugin.pgp.Signature;
import bleep.plugin.pgp.Signature$;
import bleep.plugin.pgp.StreamingSaveable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005\u0005}f\u0001B\u000f\u001f\u0001\u0015B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005k!)\u0001\t\u0001C\u0001\u0003\")A\t\u0001C\u0001\u000b\")\u0011\n\u0001C\u0001\u0015\")a\n\u0001C\u0001\u001f\")\u0001\f\u0001C\u00013\")\u0001\r\u0001C\u0001C\")Q\r\u0001C\u0001\u0015\")a\r\u0001C\u0001O\"9a\u000e\u0001b\u0001\n\u0003y\u0007bBA\u0004\u0001\u0001\u0006I\u0001\u001d\u0005\n\u0003\u0013\u0001!\u0019!C\u0001\u0003\u0017A\u0001\"!\u0006\u0001A\u0003%\u0011Q\u0002\u0005\b\u0003/\u0001A\u0011AA\r\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003\u0017Aq!!\u000e\u0001\t\u0003\t9\u0004C\u0004\u0002T\u0001!\t!!\u0016\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0004bBA=\u0001\u0011\u0005\u00111\u0010\u0005\n\u0003\u001f\u0003\u0011\u0013!C\u0001\u0003#Cq!a*\u0001\t\u0003\tI\u000b\u0003\u0006\u0002.\u0002A)\u0019!C!\u0003_;q!!-\u001f\u0011\u0003\t\u0019L\u0002\u0004\u001e=!\u0005\u0011Q\u0017\u0005\u0007\u0001j!\t!a.\t\u000f\u0005e&\u0004\"\u0001\u0002<\nI\u0001+\u001e2mS\u000e\\U-\u001f\u0006\u0003?\u0001\n1\u0001]4q\u0015\t\t#%\u0001\u0004qYV<\u0017N\u001c\u0006\u0002G\u0005)!\r\\3fa\u000e\u00011\u0003\u0002\u0001'YA\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0007CA\u0017/\u001b\u0005q\u0012BA\u0018\u001f\u00055\u0001VO\u00197jG.+\u0017\u0010T5lKB\u0011Q&M\u0005\u0003ey\u0011\u0011c\u0015;sK\u0006l\u0017N\\4TCZ,\u0017M\u00197f\u0003\u0019qWm\u001d;fIV\tQ\u0007\u0005\u00027{5\tqG\u0003\u00029s\u00059q\u000e]3oa\u001e\u0004(B\u0001\u001e<\u00031\u0011w.\u001e8ds\u000e\f7\u000f\u001e7f\u0015\u0005a\u0014aA8sO&\u0011ah\u000e\u0002\r!\u001e\u0003\u0006+\u001e2mS\u000e\\U-_\u0001\b]\u0016\u001cH/\u001a3!\u0003\u0019a\u0014N\\5u}Q\u0011!i\u0011\t\u0003[\u0001AQaM\u0002A\u0002U\nQa[3z\u0013\u0012+\u0012A\u0012\t\u0003O\u001dK!\u0001\u0013\u0015\u0003\t1{gnZ\u0001\fE&$8\u000b\u001e:f]\u001e$\b.F\u0001L!\t9C*\u0003\u0002NQ\t\u0019\u0011J\u001c;\u0002\u0019\r\u0014X-\u0019;j_:$\u0016.\\3\u0016\u0003A\u0003\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\tU$\u0018\u000e\u001c\u0006\u0002+\u0006!!.\u0019<b\u0013\t9&K\u0001\u0003ECR,\u0017a\u00034j]\u001e,'\u000f\u001d:j]R,\u0012A\u0017\t\u0004Omk\u0016B\u0001/)\u0005\u0015\t%O]1z!\t9c,\u0003\u0002`Q\t!!)\u001f;f\u0003%I7OU3w_.,G-F\u0001c!\t93-\u0003\u0002eQ\t9!i\\8mK\u0006t\u0017!C1mO>\u0014\u0018\u000e\u001e5n\u00035\tGnZ8sSRDWNT1nKV\t\u0001\u000e\u0005\u0002jY6\t!N\u0003\u0002l)\u0006!A.\u00198h\u0013\ti'N\u0001\u0004TiJLgnZ\u0001\bkN,'/\u0013#t+\u0005\u0001\bcA9zy:\u0011!o\u001e\b\u0003gZl\u0011\u0001\u001e\u0006\u0003k\u0012\na\u0001\u0010:p_Rt\u0014\"A\u0015\n\u0005aD\u0013a\u00029bG.\fw-Z\u0005\u0003un\u0014A\u0001T5ti*\u0011\u0001\u0010\u000b\t\u0004{\u0006\raB\u0001@\u0000!\t\u0019\b&C\u0002\u0002\u0002!\na\u0001\u0015:fI\u00164\u0017bA7\u0002\u0006)\u0019\u0011\u0011\u0001\u0015\u0002\u0011U\u001cXM]%Eg\u0002\n!b]5h]\u0006$XO]3t+\t\ti\u0001\u0005\u0003rs\u0006=\u0001cA\u0017\u0002\u0012%\u0019\u00111\u0003\u0010\u0003\u0013MKwM\\1ukJ,\u0017aC:jO:\fG/\u001e:fg\u0002\nqb]5h]\u0006$XO]3t\r>\u0014\u0018\n\u001a\u000b\u0005\u00037\ty\u0003\u0005\u0004\u0002\u001e\u0005\u001d\u0012\u0011F\u0007\u0003\u0003?QA!!\t\u0002$\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003KA\u0013AC2pY2,7\r^5p]&\u0019!0a\b\u0011\u0007Y\nY#C\u0002\u0002.]\u0012A\u0002U$Q'&<g.\u0019;ve\u0016Da!!\r\u0010\u0001\u0004a\u0018AA5e\u0003M!\u0017N]3di.+\u0017pU5h]\u0006$XO]3t\u0003M1XM]5gs6+7o]1hKN#(/Z1n)\u0015\u0011\u0017\u0011HA%\u0011\u001d\tY$\u0005a\u0001\u0003{\tQ!\u001b8qkR\u0004B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007\"\u0016AA5p\u0013\u0011\t9%!\u0011\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003\u0017\n\u0002\u0019AA'\u0003\u0019yW\u000f\u001e9viB!\u0011qHA(\u0013\u0011\t\t&!\u0011\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002-Y,'/\u001b4z'&<g.\u0019;ve\u0016\u001cFO]3b[N$RAYA,\u00037Bq!!\u0017\u0013\u0001\u0004\ti$A\u0002ng\u001eDq!!\u0018\u0013\u0001\u0004\ti$A\u0005tS\u001et\u0017\r^;sK\u0006YQM\\2ssB$h)\u001b7f)\u0019\t\u0019'!\u001b\u0002rA\u0019q%!\u001a\n\u0007\u0005\u001d\u0004F\u0001\u0003V]&$\bbBA\u001e'\u0001\u0007\u00111\u000e\t\u0005\u0003\u007f\ti'\u0003\u0003\u0002p\u0005\u0005#\u0001\u0002$jY\u0016Dq!a\u0013\u0014\u0001\u0004\tY'A\u0007f]\u000e\u0014\u0018\u0010\u001d;TiJLgn\u001a\u000b\u0004y\u0006]\u0004BBA\u001e)\u0001\u0007A0A\u0004f]\u000e\u0014\u0018\u0010\u001d;\u0015\u0019\u0005\r\u0014QPAA\u0003\u0007\u000b9)a#\t\u000f\u0005}T\u00031\u0001\u0002>\u0005!A-\u0019;b\u0011\u001d\tY%\u0006a\u0001\u0003\u001bBa!!\"\u0016\u0001\u0004a\u0018\u0001\u00034jY\u0016t\u0015-\\3\t\r\u0005%U\u00031\u0001G\u0003\u0011\u0019\u0018N_3\t\u0011\u00055U\u0003%AA\u0002A\u000bq\u0001\\1ti6{G-A\tf]\u000e\u0014\u0018\u0010\u001d;%I\u00164\u0017-\u001e7uIU*\"!a%+\u0007A\u000b)j\u000b\u0002\u0002\u0018B!\u0011\u0011TAR\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006}\u0015!C;oG\",7m[3e\u0015\r\t\t\u000bK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAS\u00037\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0019\u0019\u0018M^3U_R!\u00111MAV\u0011\u001d\tYe\u0006a\u0001\u0003\u001b\n\u0001\u0002^8TiJLgnZ\u000b\u0002y\u0006I\u0001+\u001e2mS\u000e\\U-\u001f\t\u0003[i\u0019\"A\u0007\u0014\u0015\u0005\u0005M\u0016!B1qa2LHc\u0001\"\u0002>\")1\u0007\ba\u0001k\u0001")
public class PublicKey
implements PublicKeyLike,
StreamingSaveable {
    private String toString;
    private final PGPPublicKey nested;
    private final List<String> userIDs;
    private final List<Signature> signatures;
    private volatile boolean bitmap$0;

    public static PublicKey apply(PGPPublicKey nested) {
        return PublicKey$.MODULE$.apply(nested);
    }

    @Override
    public void saveToFile(File file) {
        StreamingSaveable.saveToFile$(this, file);
    }

    @Override
    public String saveToString() {
        return StreamingSaveable.saveToString$(this);
    }

    @Override
    public final boolean verifyMessageFile(File input, File output) {
        return PublicKeyLike.verifyMessageFile$(this, input, output);
    }

    @Override
    public final String verifyMessageString(String input) {
        return PublicKeyLike.verifyMessageString$(this, input);
    }

    @Override
    public final boolean verifySignatureFile(File raw, File signature) {
        return PublicKeyLike.verifySignatureFile$(this, raw, signature);
    }

    @Override
    public final boolean verifySignatureString(String msg, String signature) {
        return PublicKeyLike.verifySignatureString$(this, msg, signature);
    }

    @Override
    public boolean verifyMessageStreamHelper(InputStream input, OutputStream output, Function1<Object, PGPPublicKey> getKey) {
        return PublicKeyLike.verifyMessageStreamHelper$(this, input, output, getKey);
    }

    @Override
    public boolean verifySignatureStreamsHelper(InputStream msg, InputStream signature, Function1<Object, PGPPublicKey> getKey) {
        return PublicKeyLike.verifySignatureStreamsHelper$(this, msg, signature, getKey);
    }

    public PGPPublicKey nested() {
        return this.nested;
    }

    public long keyID() {
        return this.nested().getKeyID();
    }

    public int bitStrength() {
        return this.nested().getBitStrength();
    }

    public Date creationTime() {
        return this.nested().getCreationTime();
    }

    public byte[] fingerprint() {
        return this.nested().getFingerprint();
    }

    public boolean isRevoked() {
        return this.nested().isRevoked();
    }

    public int algorithm() {
        return this.nested().getAlgorithm();
    }

    public String algorithmName() {
        String string;
        int n = this.nested().getAlgorithm();
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                string = "RSA";
                break;
            }
            case 17: {
                string = "DSA";
                break;
            }
            case 18: {
                string = "EC";
                break;
            }
            case 16: 
            case 20: {
                string = "ElGamal";
                break;
            }
            case 19: {
                string = "ECDSA";
                break;
            }
            default: {
                string = "Unknown";
                break;
            }
        }
        return string;
    }

    public List<String> userIDs() {
        return this.userIDs;
    }

    public List<Signature> signatures() {
        return this.signatures;
    }

    public List<PGPSignature> signaturesForId(String id) {
        return ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(this.nested().getSignaturesForID(id)).asScala()).toList();
    }

    public List<Signature> directKeySignatures() {
        return this.signatures().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PublicKey.$anonfun$directKeySignatures$1(x$1)));
    }

    @Override
    public boolean verifyMessageStream(InputStream input, OutputStream output) {
        return this.verifyMessageStreamHelper(input, output, (Function1<Object, PGPPublicKey>)(Function1 & Serializable)id -> PublicKey.$anonfun$verifyMessageStream$1(this, BoxesRunTime.unboxToLong((Object)id)));
    }

    @Override
    public boolean verifySignatureStreams(InputStream msg, InputStream signature) {
        return this.verifySignatureStreamsHelper(msg, signature, (Function1<Object, PGPPublicKey>)(Function1 & Serializable)id -> PublicKey.$anonfun$verifySignatureStreams$1(this, BoxesRunTime.unboxToLong((Object)id)));
    }

    public void encryptFile(File input, File output) {
        FileInputStream in = new FileInputStream(input);
        FileOutputStream out = new FileOutputStream(output);
        try {
            this.encrypt(in, out, input.getName(), input.length(), new Date(input.lastModified()));
        }
        finally {
            in.close();
            out.close();
        }
    }

    public String encryptString(String input) {
        byte[] bytes = input.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.encrypt(in, out, "", bytes.length, new Date());
        }
        finally {
            in.close();
            out.close();
        }
        return out.toString(Charset.defaultCharset().name());
    }

    public void encrypt(InputStream data, OutputStream output, String fileName, long size, Date lastMod) {
        ArmoredOutputStream aout = new ArmoredOutputStream(output);
        SecureRandom rand = new SecureRandom();
        Provider provider = Security.getProvider("BC");
        int encAlgorithm = 3;
        boolean withIntegrityPacket = true;
        JcePGPDataEncryptorBuilder encryptorBuilder = new JcePGPDataEncryptorBuilder(encAlgorithm).setWithIntegrityPacket(withIntegrityPacket).setSecureRandom(rand).setProvider(provider);
        PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)encryptorBuilder);
        encGen.addMethod((PGPKeyEncryptionMethodGenerator)new JcePublicKeyKeyEncryptionMethodGenerator(this.nested()).setProvider(provider).setSecureRandom(rand));
        OutputStream cOut = encGen.open((OutputStream)aout, new byte[1024]);
        PGPLiteralDataGenerator lit = new PGPLiteralDataGenerator();
        OutputStream lOut = lit.open(cOut, 'b', fileName, size, lastMod);
        byte[] buffer = new byte[1024];
        this.read$1(data, buffer, lOut);
        lit.close();
        cOut.close();
        aout.close();
        data.close();
    }

    public Date encrypt$default$5() {
        return new Date();
    }

    @Override
    public void saveTo(OutputStream output) {
        ArmoredOutputStream armoredOut = new ArmoredOutputStream(output);
        this.nested().encode((OutputStream)armoredOut);
        armoredOut.close();
    }

    private String toString$lzycompute() {
        PublicKey publicKey = this;
        synchronized (publicKey) {
            if (!this.bitmap$0) {
                this.toString = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("PublicKey(%x, %s, %s@%d)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.keyID()), this.userIDs().mkString(","), this.algorithmName(), BoxesRunTime.boxToInteger((int)this.bitStrength())}));
                this.bitmap$0 = true;
            }
        }
        return this.toString;
    }

    public String toString() {
        return !this.bitmap$0 ? this.toString$lzycompute() : this.toString;
    }

    public static final /* synthetic */ boolean $anonfun$directKeySignatures$1(Signature x$1) {
        return x$1.signatureType() == 31;
    }

    public static final /* synthetic */ PGPPublicKey $anonfun$verifyMessageStream$1(PublicKey $this, long id) {
        Predef$.MODULE$.assert(id == $this.keyID());
        return $this.nested();
    }

    public static final /* synthetic */ PGPPublicKey $anonfun$verifySignatureStreams$1(PublicKey $this, long id) {
        if ($this.keyID() != id) {
            throw package$.MODULE$.error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Signature is not for this key.  %x != %x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)id), BoxesRunTime.boxToLong((long)$this.keyID())})));
        }
        return $this.nested();
    }

    private final void read$1(InputStream data$1, byte[] buffer$1, OutputStream lOut$1) {
        while (true) {
            int n = data$1.read(buffer$1);
            switch (n) {
                default: 
            }
            if (n <= 0) break;
            lOut$1.write(buffer$1, 0, n);
        }
    }

    public PublicKey(PGPPublicKey nested) {
        this.nested = nested;
        PublicKeyLike.$init$(this);
        StreamingSaveable.$init$(this);
        this.userIDs = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(nested.getUserIDs()).asScala()).toList();
        this.signatures = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(nested.getSignatures()).asScala()).toList().map((Function1 & Serializable)sig -> Signature$.MODULE$.apply((PGPSignature)sig));
    }
}

