/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.pgp;

import bleep.logging.TypedLogger;
import bleep.plugin.pgp.PgpSigner;
import bleep.plugin.pgp.cli.PgpCommandContext;
import java.math.BigInteger;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001]3A\u0001C\u0005\u0001!!A1\u0004\u0001B\u0001B\u0003%A\u0004\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u001d1\u0004A1A\u0005\u0002]Baa\u000f\u0001!\u0002\u0013A\u0004\"\u0002\u001f\u0001\t\u0003i\u0004\u0002C+\u0001\u0011\u000b\u0007I\u0011\t,\u0003+\t{WO\\2z\u0007\u0006\u001cH\u000f\\3QOB\u001c\u0016n\u001a8fe*\u0011!bC\u0001\u0004a\u001e\u0004(B\u0001\u0007\u000e\u0003\u0019\u0001H.^4j]*\ta\"A\u0003cY\u0016,\u0007o\u0001\u0001\u0014\u0007\u0001\tr\u0003\u0005\u0002\u0013+5\t1CC\u0001\u0015\u0003\u0015\u00198-\u00197b\u0013\t12C\u0001\u0004B]f\u0014VM\u001a\t\u00031ei\u0011!C\u0005\u00035%\u0011\u0011\u0002U4q'&<g.\u001a:\u0002\u0007\r$\b\u0010\u0005\u0002\u001eA5\taD\u0003\u0002 \u0013\u0005\u00191\r\\5\n\u0005\u0005r\"!\u0005)ha\u000e{W.\\1oI\u000e{g\u000e^3yi\u00061q\u000e\u001d;LKf\u00042A\u0005\u0013'\u0013\t)3C\u0001\u0004PaRLwN\u001c\t\u0003O9r!\u0001\u000b\u0017\u0011\u0005%\u001aR\"\u0001\u0016\u000b\u0005-z\u0011A\u0002\u001fs_>$h(\u0003\u0002.'\u00051\u0001K]3eK\u001aL!a\f\u0019\u0003\rM#(/\u001b8h\u0015\ti3#\u0001\u0004=S:LGO\u0010\u000b\u0004gQ*\u0004C\u0001\r\u0001\u0011\u0015Y2\u00011\u0001\u001d\u0011\u0015\u00113\u00011\u0001$\u0003\u0015YW-_%e+\u0005A\u0004C\u0001\n:\u0013\tQ4C\u0001\u0003M_:<\u0017AB6fs&#\u0007%\u0001\u0003tS\u001etGc\u0001 E\rB\u0019!cP!\n\u0005\u0001\u001b\"!B!se\u0006L\bC\u0001\nC\u0013\t\u00195C\u0001\u0003CsR,\u0007\"B#\u0007\u0001\u0004q\u0014aB2p]R,g\u000e\u001e\u0005\u0006\u000f\u001a\u0001\r\u0001S\u0001\u0007Y><w-\u001a:\u0011\u0005%\u0013fB\u0001&P\u001d\tYUJ\u0004\u0002*\u0019&\ta\"\u0003\u0002O\u001b\u00059An\\4hS:<\u0017B\u0001)R\u0003\u001d\u0001\u0018mY6bO\u0016T!AT\u0007\n\u0005M#&A\u0002'pO\u001e,'O\u0003\u0002Q#\u0006AAo\\*ue&tw-F\u0001'\u0001")
public class BouncyCastlePgpSigner
implements PgpSigner {
    private String toString;
    private final PgpCommandContext ctx;
    private final long keyId;
    private volatile boolean bitmap$0;

    public long keyId() {
        return this.keyId;
    }

    @Override
    public byte[] sign(byte[] content, TypedLogger<BoxedUnit> logger) {
        return (byte[])this.ctx.withPassphrase(this.keyId(), (Function1 & java.io.Serializable & Serializable)pw -> $this.ctx.secretKeyRing().apply(this.keyId()).sign(content, (char[])pw));
    }

    private String toString$lzycompute() {
        BouncyCastlePgpSigner bouncyCastlePgpSigner = this;
        synchronized (bouncyCastlePgpSigner) {
            if (!this.bitmap$0) {
                this.toString = new StringBuilder(8).append("BC-PGP(").append(this.ctx.secretKeyRing()).append(")").toString();
                this.bitmap$0 = true;
            }
        }
        return this.toString;
    }

    public String toString() {
        return !this.bitmap$0 ? this.toString$lzycompute() : this.toString;
    }

    public BouncyCastlePgpSigner(PgpCommandContext ctx, Option<String> optKey) {
        long l;
        this.ctx = ctx;
        Option<String> option = optKey;
        if (option instanceof Some) {
            Some some = (Some)option;
            String x = (String)some.value();
            l = new BigInteger(x, 16).longValue();
        } else {
            l = ctx.secretKeyRing().secretKey().keyID();
        }
        this.keyId = l;
    }
}

