/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.nosbt.io;

import bleep.plugin.nosbt.Using;
import bleep.plugin.nosbt.Using$;
import bleep.plugin.nosbt.io.TranslatedException;
import bleep.plugin.nosbt.io.TranslatedIOException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Properties;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.sys.package$;
import scala.util.control.Exception$;

public final class IO$
implements Serializable {
    public static final IO$ MODULE$ = new IO$();

    private IO$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IO$.class);
    }

    public void createDirectory(File dir) {
        for (int tryCount = 0; !dir.exists() && !dir.mkdirs() && tryCount < 100; ++tryCount) {
        }
        if (dir.isDirectory()) {
            return;
        }
        if (dir.exists()) {
            throw package$.MODULE$.error(new StringBuilder(37).append(this.failBase$1(dir)).append(": file exists and is not a directory.").toString());
        }
        throw package$.MODULE$.error(this.failBase$1(dir));
    }

    public <T> T translate(Function0<String> msg, Function0<T> f) {
        Object object;
        try {
            object = f.apply();
        }
        catch (IOException e) {
            throw new TranslatedIOException(new StringBuilder(0).append((String)msg.apply()).append(e.toString()).toString(), e);
        }
        catch (Exception e) {
            throw new TranslatedException(new StringBuilder(0).append((String)msg.apply()).append(e.toString()).toString(), e);
        }
        return (T)object;
    }

    public void delete(Iterable<File> files) {
        files.foreach((Function1)(JProcedure1 & Serializable)file -> this.delete((File)file));
    }

    public void delete(File file) {
        this.translate((Function0<String>)((Function0 & Serializable)() -> this.delete$$anonfun$2(file)), (Function0 & Serializable)() -> {
            this.delete$$anonfun$3(file);
            return BoxedUnit.UNIT;
        });
    }

    public File[] listFiles(FileFilter filter, File dir) {
        return this.wrapNull(dir.listFiles(filter));
    }

    public File[] listFiles(File dir, FileFilter filter) {
        return this.wrapNull(dir.listFiles(filter));
    }

    public File[] listFiles(File dir) {
        return this.wrapNull(dir.listFiles());
    }

    public File[] wrapNull(File[] a) {
        if (a == null) {
            return new File[0];
        }
        return a;
    }

    public Option<String> relativize(File base, File file) {
        Path basePath = (base.isAbsolute() ? base : base.getCanonicalFile()).toPath();
        Path filePath = (file.isAbsolute() ? file : file.getCanonicalFile()).toPath();
        if (filePath.startsWith(basePath) || filePath.normalize().startsWith(basePath.normalize())) {
            Option relativePath = Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{IllegalArgumentException.class})).opt(() -> this.$anonfun$1(basePath, filePath));
            return relativePath.map((Function1 & Serializable)_$1 -> _$1.toString());
        }
        return None$.MODULE$;
    }

    private <T extends AutoCloseable> Function1<T, BoxedUnit> closeCloseable() {
        return (JProcedure1 & Serializable)_$2 -> _$2.close();
    }

    public <T extends AutoCloseable> Using.OpenFile<T> file(Function1<File, T> openF) {
        return this.file(openF, this.closeCloseable());
    }

    public <T> Using.OpenFile<T> file(Function1<File, T> openF, Function1<T, BoxedUnit> closeF) {
        return new Using.OpenFile<T>(openF, closeF){
            private final Function1 openF$1;
            private final Function1 closeF$1;
            {
                this.openF$1 = openF$2;
                this.closeF$1 = closeF$2;
            }

            public Object openImpl(File file) {
                return this.openF$1.apply((Object)file);
            }

            public void close(Object t) {
                this.closeF$1.apply(t);
            }
        };
    }

    public Using.OpenFile<BufferedOutputStream> fileOutputStream(boolean append) {
        return this.file((Function1 & Serializable)f -> new BufferedOutputStream(new FileOutputStream((File)f, append)));
    }

    public boolean fileOutputStream$default$1() {
        return false;
    }

    public void write(Properties properties, String label, File to) {
        ((Using)((Object)this.fileOutputStream(this.fileOutputStream$default$1()))).apply(to, (JProcedure1 & Serializable)output -> properties.store((OutputStream)output, label));
    }

    public void load(Properties properties, File from) {
        if (from.exists()) {
            ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(from, (JProcedure1 & Serializable)input -> properties.load((InputStream)input));
            return;
        }
    }

    private final String failBase$1(File dir$1) {
        return new StringBuilder(27).append("Could not create directory ").append(dir$1).toString();
    }

    private final String delete$$anonfun$2(File file$1) {
        return new StringBuilder(22).append("Error deleting file ").append(file$1).append(": ").toString();
    }

    private final void delete$$anonfun$3(File file$2) {
        boolean deleted = file$2.delete();
        if (!deleted && file$2.isDirectory()) {
            this.delete((Iterable<File>)Predef$.MODULE$.wrapRefArray((Object[])this.listFiles(file$2)));
            file$2.delete();
            return;
        }
    }

    private final Path $anonfun$1(Path basePath$1, Path filePath$1) {
        return basePath$1.relativize(filePath$1);
    }
}

