/*
 * Decompiled with CFR 0.152.
 */
package sbtnativeimage.graal;

import geny.Writable$;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import os.Path;
import os.Path$;
import os.PathChunk;
import os.PathChunk$;
import os.PathConvertible;
import os.PermSet;
import os.ReadablePath;
import os.RelPath;
import os.RelPath$;
import os.Source;
import os.Source$;
import os.copy;
import os.isDir$;
import os.isFile$;
import os.makeDir;
import os.package$;
import os.read;
import os.temp$;
import os.walk$;
import os.write$;
import sbtnativeimage.graal.BytecodeProcessor;
import sbtnativeimage.graal.ClassPathEntry;
import sbtnativeimage.graal.JarCache;
import sbtnativeimage.graal.PathingJar;
import sbtnativeimage.graal.Processed;
import sbtnativeimage.graal.TempCache$;
import sbtnativeimage.graal.Unmodified;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

public final class BytecodeProcessor$ {
    public static BytecodeProcessor$ MODULE$;

    static {
        new BytecodeProcessor$();
    }

    public Seq<Path> toClean(Seq<ClassPathEntry> classpath) {
        return (Seq)classpath.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClassPathEntry classPathEntry = x0$1;
            if (classPathEntry instanceof Processed) {
                Processed processed = (Processed)classPathEntry;
                Path path = processed.path();
                JarCache jarCache = processed.cache();
                if (TempCache$.MODULE$.equals(jarCache)) {
                    return (Seq)new .colon.colon((Object)path, (List)Nil$.MODULE$);
                }
            }
            if (classPathEntry instanceof PathingJar) {
                PathingJar pathingJar = (PathingJar)classPathEntry;
                ClassPathEntry path = pathingJar.jar();
                Seq<ClassPathEntry> entries = pathingJar.entries();
                ClassPathEntry classPathEntry2 = path;
                return MODULE$.toClean((Seq<ClassPathEntry>)((Seq)entries.$plus$colon((Object)classPathEntry2, Seq$.MODULE$.canBuildFrom())));
            }
            return Nil$.MODULE$;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<ClassPathEntry> processPathingJar(Path pathingJar, JarCache cache) {
        Seq seq;
        block7: {
            try (JarFile jarFile = new JarFile(pathingJar.toIO());){
                String cp = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                if (cp != null && new StringOps(Predef$.MODULE$.augmentString(cp)).nonEmpty()) {
                    Seq entries = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cp.split(" +"))).toSeq().map((Function1 & Serializable & scala.Serializable)rawEntry -> Path$.MODULE$.apply(rawEntry, package$.MODULE$.pwd(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$), Seq$.MODULE$.canBuildFrom());
                    Seq<ClassPathEntry> processedCp = this.processClassPathEntries((Seq<Path>)entries, cache);
                    String x$1 = ".jar";
                    Source x$22 = temp$.MODULE$.apply$default$1();
                    Path x$3 = temp$.MODULE$.apply$default$2();
                    String x$4 = temp$.MODULE$.apply$default$3();
                    boolean x$5 = temp$.MODULE$.apply$default$5();
                    PermSet x$6 = temp$.MODULE$.apply$default$6();
                    Path dest = temp$.MODULE$.apply(x$22, x$3, x$4, x$1, x$5, x$6);
                    try (OutputStream outStream = Files.newOutputStream(dest.toNIO(), StandardOpenOption.CREATE);){
                        String stringCp = ((TraversableOnce)processedCp.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.path().toNIO(), Seq$.MODULE$.canBuildFrom())).mkString(" ");
                        Manifest manifest = new Manifest(jarFile.getManifest());
                        manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, stringCp);
                        JarOutputStream outjar = new JarOutputStream(outStream, manifest);
                        outjar.close();
                        ((Object)dest.toNIO()).toString();
                        seq = (Seq)new .colon.colon((Object)new PathingJar(new Processed(dest, pathingJar, TempCache$.MODULE$), processedCp), (List)Nil$.MODULE$);
                        break block7;
                    }
                }
                seq = this.processClassPathEntries((Seq<Path>)((Seq)new .colon.colon((Object)pathingJar, (List)Nil$.MODULE$)), cache);
            }
        }
        return seq;
    }

    public Seq<ClassPathEntry> processClassPath(String classPath, JarCache cache) {
        String maybePathingJar;
        String[] stringArray = classPath.split(File.pathSeparator);
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0 && (maybePathingJar = (String)((SeqLike)option.get()).apply(0)).endsWith(".jar")) {
            return this.processPathingJar(Path$.MODULE$.apply((Object)maybePathingJar, package$.MODULE$.pwd(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$), cache);
        }
        Seq cp0 = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).toSeq().map((Function1 & Serializable & scala.Serializable)x$3 -> Path$.MODULE$.apply(x$3, package$.MODULE$.pwd(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$), Seq$.MODULE$.canBuildFrom());
        return this.processClassPathEntries((Seq<Path>)cp0, cache);
    }

    public JarCache processClassPath$default$2() {
        return TempCache$.MODULE$;
    }

    public Seq<ClassPathEntry> processClassPathEntries(Seq<Path> entries, JarCache cache) {
        Seq cp = (Seq)entries.map((Function1 & Serializable & scala.Serializable)path -> cache.cache((Path)path, (Function1<Path, ClassPathEntry>)(Function1 & Serializable & scala.Serializable)dest -> {
            String string = path.ext();
            String string2 = "jar";
            if (!(string != null ? !string.equals(string2) : string2 != null) && isFile$.MODULE$.apply(path)) {
                return MODULE$.processJar((Path)path, (Path)dest, cache);
            }
            if (isDir$.MODULE$.apply(path)) {
                return MODULE$.processDir((Path)path, (Path)dest, cache);
            }
            return new Unmodified((Path)dest);
        }), Seq$.MODULE$.canBuildFrom());
        if (cp.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.modified()))) {
            ClassPathEntry created;
            String jarName = "scala3RuntimeFixes.jar";
            InputStream runtimeJarIs = this.getClass().getClassLoader().getResourceAsStream(jarName);
            if (runtimeJarIs == null) {
                throw new NoSuchElementException("Unable to find scala3RuntimeFixes.jar on classpath, did you add scala3-graal jar on classpath?");
            }
            ClassPathEntry classPathEntry = created = cache.put(RelPath$.MODULE$.apply((Object)jarName, (PathConvertible)PathConvertible.StringConvertible$.MODULE$), runtimeJarIs.readAllBytes());
            return (Seq)cp.$plus$colon((Object)classPathEntry, Seq$.MODULE$.canBuildFrom());
        }
        return cp;
    }

    public ClassPathEntry processDir(Path dir, Path dest, JarCache cache) {
        IndexedSeq paths = (IndexedSeq)walk$.MODULE$.apply(dir, walk$.MODULE$.apply$default$2(), walk$.MODULE$.apply$default$3(), walk$.MODULE$.apply$default$4(), walk$.MODULE$.apply$default$5(), walk$.MODULE$.apply$default$6()).filter((Function1)isFile$.MODULE$);
        Builder skipped = Seq$.MODULE$.newBuilder();
        Builder processed = Seq$.MODULE$.newBuilder();
        paths.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Path path = x0$1;
            String string = path.ext();
            String string2 = "class";
            if (string == null ? string2 != null : !string.equals(string2)) {
                return skipped.$plus$eq((Object)path);
            }
            byte[] original = read.bytes$.MODULE$.apply((ReadablePath)path);
            Option<byte[]> option = MODULE$.processClassFile(original);
            if (option instanceof Some) {
                Some some = (Some)option;
                byte[] content = (byte[])some.value();
                RelPath relPath = path.relativeTo(dir);
                Path destPath = dest.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(relPath));
                makeDir.all$.MODULE$.apply(destPath.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(package$.MODULE$.up())));
                Predef$.MODULE$.assert(content != original);
                write$.MODULE$.apply(destPath, (Source)Source$.MODULE$.WritableSource((Object)content, (Function1 & Serializable & scala.Serializable)a -> Writable$.MODULE$.ByteArrayWritable(a)), write$.MODULE$.apply$default$3(), write$.MODULE$.apply$default$4());
                return processed.$plus$eq((Object)path);
            }
            return skipped.$plus$eq((Object)path);
        });
        if (((TraversableOnce)processed.result()).nonEmpty()) {
            ((IterableLike)skipped.result()).foreach((Function1 & Serializable & scala.Serializable)file -> {
                BytecodeProcessor$.$anonfun$processDir$3(dest, dir, file);
                return BoxedUnit.UNIT;
            });
            return new Processed(dest, dir, cache);
        }
        return new Unmodified(dir);
    }

    public ClassPathEntry processJar(Path path, Path dest, JarCache cache) {
        ClassPathEntry classPathEntry;
        try (JarFile jarFile = new JarFile(path.toIO());){
            ObjectRef processedBytecode = ObjectRef.create((Object)None$.MODULE$);
            String endMarker = "///";
            ObjectRef processed = ObjectRef.create((Object)endMarker);
            Iterator classFilesIterator = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(jarFile.entries().asIterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)BytecodeProcessor$.$anonfun$processJar$4(x$7)));
            Set cachedEntries = classFilesIterator.map((Function1 & Serializable & scala.Serializable)entry -> this.processEntry$1((JarEntry)entry, jarFile, processed, processedBytecode, endMarker)).takeWhile((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)BytecodeProcessor$.$anonfun$processJar$6(endMarker, x$8))).toSet();
            if (((Option)processedBytecode.elem).isEmpty()) {
                classPathEntry = new Unmodified(path);
            } else {
                makeDir.all$.MODULE$.apply(dest.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(package$.MODULE$.up())));
                OutputStream outStream = Files.newOutputStream(dest.toNIO(), StandardOpenOption.CREATE);
                JarOutputStream outjar = new JarOutputStream(outStream);
                ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(jarFile.entries().asIterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
                    BytecodeProcessor$.$anonfun$processJar$7(jarFile, cachedEntries, processed, processedBytecode, outjar, entry);
                    return BoxedUnit.UNIT;
                });
                outjar.close();
                classPathEntry = new Processed(dest, path, cache);
            }
        }
        return classPathEntry;
    }

    public Option<byte[]> processClassReader(ClassReader reader) {
        ClassWriter writer = new ClassWriter(reader, 3);
        BytecodeProcessor.LazyValVisitor visitor = new BytecodeProcessor.LazyValVisitor(writer);
        Try res = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> reader.accept((ClassVisitor)visitor, 0));
        if (visitor.changed() && res.isSuccess()) {
            return new Some((Object)writer.toByteArray());
        }
        return None$.MODULE$;
    }

    public Option<byte[]> processClassFile(Function0<InputStream> content) {
        Option<byte[]> option;
        try (InputStream is = (InputStream)content.apply();){
            option = this.processClassReader(new ClassReader(is));
        }
        return option;
    }

    public Option<byte[]> processClassFile(byte[] content) {
        return this.processClassReader(new ClassReader(content));
    }

    public static final /* synthetic */ void $anonfun$processDir$3(Path dest$1, Path dir$1, Path file) {
        Path x$2 = file;
        Path x$3 = dest$1.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(file.relativeTo(dir$1)));
        boolean x$4 = true;
        boolean x$5 = copy.over$.MODULE$.apply$default$3();
        boolean x$6 = copy.over$.MODULE$.apply$default$4();
        boolean x$7 = copy.over$.MODULE$.apply$default$5();
        copy.over$.MODULE$.apply(x$2, x$3, x$5, x$6, x$7, x$4);
    }

    private final String processEntry$1(JarEntry entry, JarFile jarFile$1, ObjectRef processed$2, ObjectRef processedBytecode$1, String endMarker$1) {
        Option<byte[]> newBytecode = this.processClassFile((Function0<InputStream>)(Function0 & Serializable & scala.Serializable)() -> jarFile$1.getInputStream(entry));
        processed$2.elem = entry.getName();
        processedBytecode$1.elem = newBytecode;
        return (String)newBytecode.fold((Function0 & Serializable & scala.Serializable)() -> entry.getName(), (Function1 & Serializable & scala.Serializable)x$6 -> endMarker$1);
    }

    public static final /* synthetic */ boolean $anonfun$processJar$4(JarEntry x$7) {
        return x$7.getName().endsWith(".class");
    }

    public static final /* synthetic */ boolean $anonfun$processJar$6(String endMarker$1, String x$8) {
        String string = x$8;
        String string2 = endMarker$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$processJar$7(JarFile jarFile$1, Set cachedEntries$1, ObjectRef processed$2, ObjectRef processedBytecode$1, JarOutputStream outjar$1, JarEntry entry) {
        byte[] byArray;
        byte[] content = jarFile$1.getInputStream(entry).readAllBytes();
        String name = entry.getName();
        if (cachedEntries$1.contains((Object)name) || !name.endsWith(".class")) {
            byArray = content;
        } else {
            String string = name;
            String string2 = (String)processed$2.elem;
            byArray = !(string != null ? !string.equals(string2) : string2 != null) ? (byte[])((Option)processedBytecode$1.elem).get() : (byte[])MODULE$.processClassFile(content).getOrElse((Function0 & Serializable & scala.Serializable)() -> content);
        }
        byte[] destBytes = byArray;
        JarEntry newEntry = new JarEntry(entry.getName());
        outjar$1.putNextEntry(newEntry);
        outjar$1.write(destBytes);
        outjar$1.closeEntry();
    }

    private BytecodeProcessor$() {
        MODULE$ = this;
    }
}

