/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.jni.javah.util;

import com.github.sbt.jni.javah.ClassName;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public final class Utils {
    public static final int MAX_SUPPORTED_VERSION = 13;
    public static final List<String> MULTI_RELEASE_VERSIONS = IntStream.rangeClosed(9, 13).mapToObj(Integer::toString).collect(Collectors.toList());
    public static final Pattern SIMPLE_NAME_PATTERN = Pattern.compile("[^.;\\[/]+");
    public static final Pattern FULL_NAME_PATTERN = Pattern.compile("[^.;\\[/]+(\\.[^.;\\[/]+)*");
    public static final Pattern METHOD_NAME_PATTERN = Pattern.compile("(<init>)|(<cinit>)|([^.;\\[/<>]+)");
    public static final Pattern METHOD_TYPE_PATTERN = Pattern.compile("\\((?<args>(\\[*([BCDFIJSZ]|L[^.;\\[/]+(/[^.;\\\\\\[/]+)*;))*)\\)(?<ret>\\[*([BCDFIJSZV]|L[^.;\\[/]+(/[^.;\\[/]+)*;))");
    public static final PrintWriter NOOP_WRITER = new PrintWriter(new Writer(){

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    });

    public static String mangleName(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                stringBuilder.append('_');
                continue;
            }
            if (c == '_') {
                stringBuilder.append("_1");
                continue;
            }
            if (c == ';') {
                stringBuilder.append("_2");
                continue;
            }
            if (c == '[') {
                stringBuilder.append("_3");
                continue;
            }
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(String.format("_0%04x", c));
        }
        return stringBuilder.toString();
    }

    public static String escape(String string) {
        Objects.requireNonNull(string);
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c <= '~') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(String.format("\\u%04x", c));
        }
        return stringBuilder.toString();
    }

    public static Path classPathRoot(Path path) {
        Objects.requireNonNull(path);
        path = path.toAbsolutePath();
        if (Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return path;
        }
        try {
            FileSystem fileSystem = FileSystems.newFileSystem(path, (ClassLoader)null);
            String string = path.getFileName().toString().toLowerCase();
            if (string.endsWith(".jar") || string.endsWith(".zip")) {
                return fileSystem.getPath("/", new String[0]);
            }
            if (string.endsWith(".jmod")) {
                return fileSystem.getPath("/", "classes");
            }
            fileSystem.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return null;
    }

    public static ClassName superClassOf(ClassReader classReader) {
        Objects.requireNonNull(classReader);
        SuperNameVisitor superNameVisitor = new SuperNameVisitor();
        classReader.accept((ClassVisitor)superNameVisitor, 7);
        return superNameVisitor.superName;
    }

    static final class SuperNameVisitor
    extends ClassVisitor {
        ClassName superName = null;

        SuperNameVisitor() {
            super(458752);
        }

        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
            if (string3 != null) {
                this.superName = ClassName.ofInternalName(string3);
            }
        }
    }
}

