/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.jni.javah.util;

import com.github.sbt.jni.javah.ClassName;
import com.github.sbt.jni.javah.search.RuntimeSearchPath;
import com.github.sbt.jni.javah.search.SearchPath;
import com.github.sbt.jni.javah.util.ClassMetaInfo;
import com.github.sbt.jni.javah.util.Constant;
import com.github.sbt.jni.javah.util.NativeMethod;
import com.github.sbt.jni.javah.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public class JNIGenerator {
    private final PrintWriter errorHandle;
    private final Iterable<SearchPath> searchPaths;
    private final Path outputDir;

    public JNIGenerator(Path path) {
        this(path, null, null);
    }

    public JNIGenerator(Path path, Iterable<SearchPath> iterable) {
        this(path, iterable, null);
    }

    public JNIGenerator(Path path, Iterable<SearchPath> iterable, PrintWriter printWriter) {
        Objects.requireNonNull(path);
        if (iterable == null) {
            iterable = Collections.singleton(RuntimeSearchPath.INSTANCE);
        }
        if (printWriter == null) {
            printWriter = Utils.NOOP_WRITER;
        }
        this.errorHandle = printWriter;
        this.searchPaths = iterable;
        this.outputDir = path;
    }

    public void generate(ClassName className) {
        Objects.requireNonNull(className);
        if (Files.exists(this.outputDir, new LinkOption[0]) && !Files.isDirectory(this.outputDir, new LinkOption[0])) {
            throw new IllegalArgumentException(String.valueOf(this.outputDir) + "is not a directory");
        }
        if (Files.notExists(this.outputDir, new LinkOption[0])) {
            try {
                Files.createDirectories(this.outputDir, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                this.errorHandle.println("error: cannot create directory " + String.valueOf(this.outputDir));
                iOException.printStackTrace(this.errorHandle);
                return;
            }
        }
        Path path = this.outputDir.resolve(className.mangledName() + ".h");
        try (PrintWriter printWriter = new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));){
            this.generateTo(className, printWriter);
        }
        catch (Exception exception) {
            this.errorHandle.println("error: cannot write to " + String.valueOf(path));
            exception.printStackTrace(this.errorHandle);
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void generateTo(ClassName className, Writer writer) throws IOException {
        Object object;
        Objects.requireNonNull(className);
        Objects.requireNonNull(writer);
        ClassMetaInfo classMetaInfo = new ClassMetaInfo();
        Object object2 = this.search(className);
        if (object2 == null) {
            this.errorHandle.println("Not found class " + String.valueOf(className));
            return;
        }
        try (Iterator<NativeMethod> iterator = Files.newInputStream((Path)object2, new OpenOption[0]);){
            ClassReader object3 = new ClassReader((InputStream)((Object)iterator));
            object3.accept((ClassVisitor)classMetaInfo, 7);
        }
        catch (IOException iOException) {
            this.errorHandle.println("error: cannot open class file of " + String.valueOf(className));
            iOException.printStackTrace(this.errorHandle);
            this.errorHandle.flush();
            throw iOException;
        }
        object2 = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        ((PrintWriter)object2).println("/* DO NOT EDIT THIS FILE - it is machine generated */");
        ((PrintWriter)object2).println("#include <jni.h>");
        ((PrintWriter)object2).println("/* Header for class " + className.mangledName() + " */");
        ((PrintWriter)object2).println();
        ((PrintWriter)object2).println("#ifndef _Included_" + className.mangledName());
        ((PrintWriter)object2).println("#define _Included_" + className.mangledName());
        ((PrintWriter)object2).println("#ifdef __cplusplus");
        ((PrintWriter)object2).println("extern \"C\" {");
        ((PrintWriter)object2).println("#endif");
        for (Constant constant : classMetaInfo.constants) {
            object = className.mangledName() + "_" + constant.mangledName();
            ((PrintWriter)object2).println("#undef " + (String)object);
            ((PrintWriter)object2).println("#define " + (String)object + " " + constant.valueToString());
        }
        for (NativeMethod nativeMethod : classMetaInfo.methods) {
            object = this.mapTypeToNative(nativeMethod.type().getReturnType());
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("JNIEnv *");
            arrayList.add(nativeMethod.isStatic() ? "jclass" : "jobject");
            arrayList.addAll(Arrays.asList(this.mapArgsTypeToNative(nativeMethod.type())));
            String string = "Java_" + className.mangledName() + "_" + (classMetaInfo.isOverloadMethod(nativeMethod) ? nativeMethod.longMangledName() : nativeMethod.mangledName());
            ((PrintWriter)object2).println("/*");
            ((PrintWriter)object2).println(" * Class:      " + className.mangledName());
            ((PrintWriter)object2).println(" * Method:     " + nativeMethod.mangledName());
            ((PrintWriter)object2).println(" * Signature:  " + Utils.escape(nativeMethod.type().toString()));
            ((PrintWriter)object2).println(" */");
            ((PrintWriter)object2).println("JNIEXPORT " + (String)object + " JNICALL " + string);
            ((PrintWriter)object2).println("  (" + String.join((CharSequence)", ", arrayList) + ");");
            ((PrintWriter)object2).println();
        }
        ((PrintWriter)object2).println("#ifdef __cplusplus");
        ((PrintWriter)object2).println("}");
        ((PrintWriter)object2).println("#endif");
        ((PrintWriter)object2).println("#endif");
    }

    private Path search(ClassName className) {
        return SearchPath.searchFrom(this.searchPaths, className);
    }

    private String mapTypeToNative(Type type) {
        Objects.requireNonNull(type);
        String string = type.toString();
        if (string.startsWith("(")) {
            throw new IllegalArgumentException();
        }
        switch (string) {
            case "Z": {
                return "jboolean";
            }
            case "B": {
                return "jbyte";
            }
            case "C": {
                return "jchar";
            }
            case "S": {
                return "jshort";
            }
            case "I": {
                return "jint";
            }
            case "J": {
                return "jlong";
            }
            case "F": {
                return "jfloat";
            }
            case "D": {
                return "jdouble";
            }
            case "V": {
                return "void";
            }
            case "Ljava/lang/Class;": {
                return "jclass";
            }
            case "Ljava/lang/String;": {
                return "jstring";
            }
            case "Ljava/lang/Throwable;": {
                return "jthrowable";
            }
            case "[Z": {
                return "jbooleanArray";
            }
            case "[B": {
                return "jbyteArray";
            }
            case "[C": {
                return "jcharArray";
            }
            case "[S": {
                return "jshortArray";
            }
            case "[I": {
                return "jintArray";
            }
            case "[J": {
                return "jlongArray";
            }
            case "[F": {
                return "jfloatArray";
            }
            case "[D": {
                return "jdoubleArray";
            }
        }
        if (string.startsWith("[")) {
            return "jobjectArray";
        }
        if (string.startsWith("L") && string.endsWith(";")) {
            Object object = ClassName.ofInternalName(string.substring(1, string.length() - 1));
            if (this.isThrowable((ClassName)object)) {
                return "jthrowable";
            }
            return "jobject";
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf(type));
    }

    private String[] mapArgsTypeToNative(Type type) {
        Objects.requireNonNull(type);
        if (!Utils.METHOD_TYPE_PATTERN.matcher(type.toString()).matches()) {
            throw new IllegalArgumentException(String.valueOf(type) + " is not a method type");
        }
        Type[] typeArray = type.getArgumentTypes();
        String[] stringArray = new String[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            stringArray[i] = this.mapTypeToNative(typeArray[i]);
        }
        return stringArray;
    }

    private boolean isThrowable(ClassName className) {
        boolean bl;
        block19: {
            if (className == null) {
                return false;
            }
            switch (className.className()) {
                case "java.lang.Throwable": 
                case "java.lang.Error": 
                case "java.lang.Exception": {
                    return true;
                }
                case "java.lang.Object": {
                    return false;
                }
            }
            Object object = Files.newInputStream(this.search(className), new OpenOption[0]);
            try {
                bl = this.isThrowable(Utils.superClassOf(new ClassReader((InputStream)object)));
                if (object == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    this.errorHandle.println("warning: class " + String.valueOf(className) + " not found");
                    return false;
                }
            }
            ((InputStream)object).close();
        }
        return bl;
    }
}

