/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.jni.javah.util;

import com.github.sbt.jni.javah.ClassName;
import com.github.sbt.jni.javah.util.Constant;
import com.github.sbt.jni.javah.util.NativeMethod;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassMetaInfo
extends ClassVisitor {
    public final List<Constant> constants = new LinkedList<Constant>();
    public final List<NativeMethod> methods = new LinkedList<NativeMethod>();
    public final Map<String, Integer> counts = new HashMap<String, Integer>();
    ClassName superClassName;
    ClassName name;

    public ClassMetaInfo() {
        super(458752);
    }

    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.superClassName = string3 == null ? null : ClassName.ofInternalName(string3);
        this.name = ClassName.ofInternalName(string);
    }

    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        this.counts.put(string, this.counts.getOrDefault(string, 0) + 1);
        if ((n & 0x100) != 0) {
            this.methods.add(NativeMethod.of(n, string, string2));
        }
        return null;
    }

    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        if (object != null && !(object instanceof String)) {
            this.constants.add(Constant.of(string, object));
        }
        return null;
    }

    public boolean isOverloadMethod(NativeMethod nativeMethod) {
        Objects.requireNonNull(nativeMethod);
        return this.counts.getOrDefault(nativeMethod.name(), 1) > 1;
    }
}

