/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.jni.javah;

import com.github.sbt.jni.javah.ClassName;
import com.github.sbt.jni.javah.search.ClassPath;
import com.github.sbt.jni.javah.search.ModulePath;
import com.github.sbt.jni.javah.search.RuntimeSearchPath;
import com.github.sbt.jni.javah.search.SearchPath;
import com.github.sbt.jni.javah.util.JNIGenerator;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class JavahTask {
    private final List<SearchPath> searchPaths = new LinkedList<SearchPath>();
    private Path outputDir;
    private Path outputFile;
    private PrintWriter errorHandle = new PrintWriter(System.err, true);
    private final List<ClassName> classes = new LinkedList<ClassName>();

    public void run() {
        if (this.outputDir == null && this.outputFile == null) {
            throw new AssertionError();
        }
        JNIGenerator jNIGenerator = new JNIGenerator(this.outputDir, this.searchPaths, this.errorHandle);
        for (ClassName className : this.classes) {
            try {
                jNIGenerator.generate(className);
            }
            catch (Exception exception) {
                exception.printStackTrace(this.errorHandle);
            }
        }
    }

    public boolean hasClasses() {
        return !this.classes.isEmpty();
    }

    public void addClass(ClassName className) {
        Objects.requireNonNull(className);
        this.classes.add(className);
    }

    public void addClass(String string) {
        Objects.requireNonNull(string);
        this.classes.add(ClassName.ofFullName(string));
    }

    public void addClasses(Iterable<String> iterable) {
        Objects.requireNonNull(iterable);
        iterable.forEach(string -> this.classes.add(ClassName.ofFullName(string)));
    }

    public void addRuntimeSearchPath() {
        this.searchPaths.add(RuntimeSearchPath.INSTANCE);
    }

    public void addSearchPath(SearchPath searchPath) {
        Objects.requireNonNull(searchPath);
        this.searchPaths.add(searchPath);
    }

    public void addClassPath(Path path) {
        Objects.requireNonNull(path);
        this.searchPaths.add(new ClassPath(path));
    }

    public void addModulePath(Path path) {
        Objects.requireNonNull(path);
        this.searchPaths.add(new ModulePath(path));
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(Path path) {
        this.outputDir = path;
    }

    public Path getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(Path path) {
        this.outputFile = path;
    }

    public PrintWriter getErrorHandle() {
        return this.errorHandle;
    }

    public void setErrorHandle(Writer writer) {
        this.errorHandle = writer instanceof PrintWriter || writer == null ? (PrintWriter)writer : new PrintWriter(writer);
    }
}

