/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.jni.javah.search;

import com.github.sbt.jni.javah.ClassName;
import com.github.sbt.jni.javah.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.jar.Manifest;
import java.util.stream.Collectors;

public interface SearchPath {
    public Path search(ClassName var1);

    default public Path search(String string) {
        Objects.requireNonNull(string);
        return this.search(ClassName.ofFullName(string));
    }

    public static Path searchFrom(Iterable<SearchPath> iterable, ClassName className) {
        Objects.requireNonNull(iterable);
        Objects.requireNonNull(className);
        for (SearchPath searchPath : iterable) {
            Path path;
            if (searchPath == null || (path = searchPath.search(className)) == null) continue;
            return path;
        }
        return null;
    }

    public static Path searchFromRoots(Iterable<Path> iterable, ClassName className) {
        Objects.requireNonNull(iterable);
        Objects.requireNonNull(className);
        for (Path path : iterable) {
            if (path == null || !Files.isDirectory(path, new LinkOption[0])) continue;
            Path path2 = path.resolve(className.relativePath());
            if (Files.isRegularFile(path2, new LinkOption[0])) {
                return path2;
            }
            if (!Files.isSymbolicLink(path2)) continue;
            try {
                if (!Files.isRegularFile(path2 = Files.readSymbolicLink(path2), new LinkOption[0])) continue;
                return path2;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public static List<Path> multiReleaseRoots(Path path2) {
        Object object;
        Objects.requireNonNull(path2);
        if (!Files.isDirectory(path2, new LinkOption[0])) {
            return Collections.emptyList();
        }
        boolean bl = false;
        try {
            object = Files.newInputStream(path2.resolve("META-INF").resolve("MANIFEST.MF"), new OpenOption[0]);
            try {
                bl = "true".equals(new Manifest((InputStream)object).getMainAttributes().getValue("Multi-Release"));
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        catch (IOException | NullPointerException exception) {
            // empty catch block
        }
        if (bl && Files.isDirectory((Path)(object = path2.resolve("META-INF").resolve("versions")), new LinkOption[0])) {
            try {
                List list = Files.list((Path)object).map(Path::toAbsolutePath).filter(path -> Files.isDirectory(path, new LinkOption[0])).filter(path -> Utils.MULTI_RELEASE_VERSIONS.contains(path.getFileName().toString())).sorted(Comparator.comparing(path -> Integer.parseInt(path.getFileName().toString())).reversed()).collect(Collectors.toCollection(LinkedList::new));
                list.add(path2);
                return Collections.unmodifiableList(list);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.singletonList(path2);
    }
}

