/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.jni.javah.search;

import com.github.sbt.jni.javah.ClassName;
import com.github.sbt.jni.javah.search.SearchPath;
import com.github.sbt.jni.javah.util.Utils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ModulePath
implements SearchPath {
    private final Path path;
    private List<Path> roots;

    public ModulePath(Path path2) {
        Objects.requireNonNull(path2);
        this.path = path2 = path2.toAbsolutePath();
        if (Files.notExists(path2, new LinkOption[0]) || !Files.isDirectory(path2, new LinkOption[0])) {
            this.roots = Collections.emptyList();
        } else {
            try {
                this.roots = Files.list(path2).map(Path::toAbsolutePath).filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> {
                    String string = path.getFileName().toString().toLowerCase();
                    return string.endsWith(".jar") || string.endsWith(".zip") || string.endsWith(".jmod");
                }).map(Utils::classPathRoot).filter(Objects::nonNull).flatMap(path -> SearchPath.multiReleaseRoots(path).stream()).collect(Collectors.toList());
            }
            catch (IOException iOException) {
                this.roots = Collections.emptyList();
            }
        }
    }

    @Override
    public Path search(ClassName className) {
        Objects.requireNonNull(className);
        return SearchPath.searchFromRoots(this.roots, className);
    }

    public String toString() {
        return "ModulePath[" + this.path + "]";
    }
}

